/*
 * Decompiled with CFR 0.152.
 */
package pn;

import LESSolver.ILESSolver;
import invariants.InvariantsResultsFrame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import pn.modules.IModule;
import pn.modules.IResponseListener;
import pn.modules.pn.IArc;
import pn.modules.pn.IPetriNet;
import pn.modules.pn.IPlace;
import pn.modules.pn.ITransition;

public class ModuleImpl
extends JPanel
implements IModule {
    private ArrayList<IResponseListener> responseListeners;
    private ILESSolver lesSolver = null;
    public static boolean isDebug = true;
    private boolean error = false;
    private IPetriNet petriNet;
    private JButton jButton1;

    public ModuleImpl() {
        this.initComponents();
    }

    @Override
    public void addPetriNet(IPetriNet pn) {
        this.petriNet = pn;
    }

    @Override
    public String getHTMLDescription() {
        return "<html><h1>Invariants analysis module</h1>Module solves invariants for Petri nets. It solves both for place and transition invariants.<br><br>This module depends on the module LES Solver, which must be installed prior to the use of Invariants analysis module.<br><br>Author:<br>Peter Natafalu\u0139\u02c7i</html>";
    }

    @Override
    public void addResponseListener(IResponseListener r) {
        if (this.responseListeners == null) {
            this.responseListeners = new ArrayList();
        }
        this.responseListeners.add(r);
    }

    @Override
    public void executeCommand(String command) {
    }

    @Override
    public void open() {
        if (!this.openDependingModules()) {
            this.error = true;
        }
        InvariantsResultsFrame irf = new InvariantsResultsFrame(this);
        irf.setLocationRelativeTo(null);
        irf.setVisible(true);
    }

    @Override
    public void close() {
    }

    private boolean openDependingModules() {
        boolean result = true;
        try {
            File lesFile = new File("./modules/LESSolver.jar");
            URLClassLoader cl = new URLClassLoader(new URL[]{lesFile.toURI().toURL()}, this.getClass().getClassLoader());
            Class<?> cls = cl.loadClass("LESSolver.LESSolverImpl");
            this.lesSolver = (ILESSolver)cls.newInstance();
        }
        catch (Exception ex) {
            if (isDebug) {
                ex.printStackTrace();
            }
            result = false;
        }
        if (this.getLesSolver() == null) {
            result = false;
        }
        if (!result && !this.error) {
            JOptionPane.showMessageDialog(null, "Invariants module require LESSolver module. LESSolver module was not found or is corrupted.", "Missing Dependant module", 0);
        }
        return result;
    }

    @Override
    public String getName() {
        if (this.error) {
            return "Invariants analysis module(Error)";
        }
        return "Invariants analysis module";
    }

    @Override
    public JComponent getControlPanel() {
        if (this.error) {
            return null;
        }
        return this;
    }

    public static int[][] getPreTable(IPetriNet pn) {
        int[][] matrix = new int[pn.getPlaces().size()][pn.getTransitions().size()];
        for (IArc a : pn.getArcs()) {
            if (!(a.getStartingVertex() instanceof IPlace)) continue;
            matrix[pn.getPlaces().indexOf((Object)a.getStartingVertex())][pn.getTransitions().indexOf((Object)a.getEndingVertex())] = a.getCount();
        }
        return matrix;
    }

    public static int[][] getPostTable(IPetriNet pn) {
        int[][] matrix = new int[pn.getPlaces().size()][pn.getTransitions().size()];
        for (IArc a : pn.getArcs()) {
            if (!(a.getStartingVertex() instanceof ITransition)) continue;
            matrix[pn.getPlaces().indexOf((Object)a.getEndingVertex())][pn.getTransitions().indexOf((Object)a.getStartingVertex())] = a.getCount();
        }
        return matrix;
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/invariants/icon.png")));
        this.jButton1.setToolTipText("Invariants analysis module");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModuleImpl.this.jButton1ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton1));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton1));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        boolean found = false;
        this.petriNet = null;
        if (this.getPetriNet() == null) {
            int i = 0;
            while (i < this.responseListeners.size()) {
                ArrayList<IPetriNet> a = this.responseListeners.get(i).requestPetriNets();
                if (a != null && a.size() != 0) {
                    found = true;
                    this.addPetriNet(a.get(0));
                    this.open();
                }
                ++i;
            }
        }
        if (!found) {
            JOptionPane.showMessageDialog(null, "Please select Petri Net to analyze.", "No Petri net selected", 1);
        }
    }

    public ILESSolver getLesSolver() {
        return this.lesSolver;
    }

    public IPetriNet getPetriNet() {
        return this.petriNet;
    }

    @Override
    public String getHTMLHelpSK() {
        return "modules/modulesHelp/iam_sk.html";
    }

    @Override
    public String getHTMLHelpENG() {
        return "modules/modulesHelp/iam_eng.html";
    }

    @Override
    public String getTarget() {
        return "iam";
    }

    @Override
    public String getName(String prefix) {
        String languageName = null;
        if (prefix.equals("_sk")) {
            languageName = "Modul na anal&#253;zu invariantov";
        }
        if (prefix.equals("_eng")) {
            languageName = "Invariants analysis module";
        }
        return languageName;
    }
}

