/*
 * Decompiled with CFR 0.152.
 */
package pn;

import java.math.BigInteger;

public class BigRational
implements Comparable<BigRational> {
    public static final BigRational ZERO = new BigRational(0);
    private BigInteger num;
    private BigInteger den;

    public BigRational(int numerator, int denominator) {
        this(new BigInteger("" + numerator), new BigInteger("" + denominator));
    }

    public BigRational(int numerator) {
        this(numerator, 1);
    }

    public BigRational(String s) {
        String[] tokens = s.split("/");
        if (tokens.length == 2) {
            this.init(new BigInteger(tokens[0]), new BigInteger(tokens[1]));
        } else if (tokens.length == 1) {
            this.init(new BigInteger(tokens[0]), BigInteger.ONE);
        } else {
            throw new RuntimeException("Parse error in BigRational");
        }
    }

    public BigRational(BigInteger numerator, BigInteger denominator) {
        this.init(numerator, denominator);
    }

    private void init(BigInteger numerator, BigInteger denominator) {
        if (denominator.equals(BigInteger.ZERO)) {
            throw new RuntimeException("Denominator is zero");
        }
        BigInteger g = numerator.gcd(denominator);
        this.num = numerator.divide(g);
        this.den = denominator.divide(g);
        if (this.den.compareTo(BigInteger.ZERO) < 0) {
            this.den = this.den.negate();
            this.num = this.num.negate();
        }
    }

    public String toString() {
        if (this.den.equals(BigInteger.ONE)) {
            return "" + this.num;
        }
        return this.num + "/" + this.den;
    }

    @Override
    public int compareTo(BigRational b) {
        BigRational a = this;
        return a.num.multiply(b.den).compareTo(a.den.multiply(b.num));
    }

    public boolean isZero() {
        return this.compareTo(ZERO) == 0;
    }

    public boolean isPositive() {
        return this.compareTo(ZERO) > 0;
    }

    public boolean isNegative() {
        return this.compareTo(ZERO) < 0;
    }

    public boolean equals(Object y) {
        if (y == this) {
            return true;
        }
        if (y == null) {
            return false;
        }
        if (y.getClass() != this.getClass()) {
            return false;
        }
        BigRational b = (BigRational)y;
        return this.compareTo(b) == 0;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public static BigRational abs(BigRational a) {
        if (a.isNegative()) {
            return a.times(new BigRational(-1));
        }
        return a;
    }

    public BigRational times(BigRational b) {
        BigRational a = this;
        return new BigRational(a.num.multiply(b.num), a.den.multiply(b.den));
    }

    public BigRational plus(BigRational b) {
        BigRational a = this;
        BigInteger numerator = a.num.multiply(b.den).add(b.num.multiply(a.den));
        BigInteger denominator = a.den.multiply(b.den);
        return new BigRational(numerator, denominator);
    }

    public BigRational negate() {
        return new BigRational(this.num.negate(), this.den);
    }

    public BigRational minus(BigRational b) {
        BigRational a = this;
        return a.plus(b.negate());
    }

    public BigRational reciprocal() {
        return new BigRational(this.den, this.num);
    }

    public BigRational divides(BigRational b) {
        BigRational a = this;
        return a.times(b.reciprocal());
    }
}

