/*
 * Decompiled with CFR 0.152.
 */
package invariants;

import LESSolver.ILESSolver;
import invariants.Matrices;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pn.BigRational;
import pn.IPNInvariants;
import pn.modules.pn.IPetriNet;

public class PNInvariants
implements IPNInvariants {
    protected Matrices matrices;
    private Pattern pattern;
    private Matcher matcher;
    private IPetriNet pn;
    private String time;

    public PNInvariants(IPetriNet pn) {
        this.matrices = new Matrices(pn);
        this.pn = pn;
        this.pattern = Pattern.compile("\\[[\\d, /\\-]+?\\]");
    }

    @Override
    public BigRational[][] getPlaceInvariants(IPetriNet pn, ILESSolver lesSolver) {
        Pattern p = Pattern.compile("-??\\d+/?\\d*");
        int vectorCount = 0;
        String riesenie = lesSolver.solve(this.matrices.getIncidenceTransposeMatrix(), null).getTextualSolution().toString();
        if (riesenie.compareTo("System nema riesenie.") == 0) {
            return null;
        }
        this.matcher = this.pattern.matcher(riesenie);
        while (this.matcher.find()) {
            ++vectorCount;
        }
        this.matcher.reset();
        BigRational[][] matrix = new BigRational[vectorCount][pn.getPlaces().size()];
        int i = 0;
        while (this.matcher.find()) {
            Matcher m = p.matcher(this.matcher.group());
            int j = 0;
            while (m.find()) {
                matrix[i][j] = new BigRational(m.group());
                ++j;
            }
            ++i;
        }
        this.time = riesenie.substring(riesenie.indexOf("The computation"));
        return matrix;
    }

    public String getTimeInfo() {
        return this.time;
    }

    @Override
    public BigRational[][] getTransitionInvariants(IPetriNet pn, ILESSolver lesSolver) {
        Pattern p = Pattern.compile("-??\\d+/?\\d*");
        int vectorCount = 0;
        String riesenie = lesSolver.solve(this.matrices.getIncidenceMatrix(), null).getTextualSolution().toString();
        if (riesenie.compareTo("System nema riesenie.") == 0) {
            return null;
        }
        this.matcher = this.pattern.matcher(riesenie);
        while (this.matcher.find()) {
            ++vectorCount;
        }
        this.matcher.reset();
        BigRational[][] matrix = new BigRational[vectorCount][pn.getTransitions().size()];
        int i = 0;
        while (this.matcher.find()) {
            Matcher m = p.matcher(this.matcher.group());
            int j = 0;
            while (m.find()) {
                matrix[i][j] = new BigRational(m.group());
                ++j;
            }
            ++i;
        }
        this.time = riesenie.substring(riesenie.indexOf("The computation"));
        return matrix;
    }

    public String toHTML(BigRational[][] matrix, char type) {
        if (matrix == null) {
            return "<font color=\"red\"><p align=\"center\"><b>The solution does not exist.</b></p></font>";
        }
        int m = matrix.length;
        int n = matrix[0].length;
        StringBuilder stb = new StringBuilder("<table align=\"center\">");
        stb.append("<tr><td>" + type + " = </td><td> [</td>");
        int i = 0;
        while (i < n) {
            if (i == n - 1) {
                stb.append("<td>" + matrix[0][i] + "</td>");
            } else {
                stb.append("<td>" + matrix[0][i] + ",</td>");
            }
            ++i;
        }
        stb.append("<td>]</td></tr>");
        if (m < 2) {
            stb.append("</table");
            return stb.toString();
        }
        int a = 1;
        while (a < m) {
            stb.append("<tr><td>+ p<sub>" + (a - 1) + " </sub></td><td>[</td>");
            int i2 = 0;
            while (i2 < n) {
                if (i2 == n - 1) {
                    stb.append("<td>" + matrix[a][i2] + "</td>");
                } else {
                    stb.append("<td>" + matrix[a][i2] + ",</td>");
                }
                ++i2;
            }
            stb.append("<td>]</td></tr>");
            ++a;
        }
        stb.append("</table>");
        return stb.toString();
    }

    public String placeInv(BigRational[][] matrix) {
        StringBuilder stb = new StringBuilder();
        int i = 0;
        while (i < matrix.length) {
            int j = 0;
            while (j < matrix[0].length) {
                if (!matrix[i][j].isZero()) {
                    String title = this.pn.getPlaces().get(j).getName();
                    if (title.isEmpty() && (title = this.pn.getPlaces().get(j).getId()).isEmpty()) {
                        title = "p<sub>" + j + "</sub>";
                    }
                    stb.append(String.valueOf(title) + " ");
                    if (matrix[i][j].compareTo(new BigRational(1)) != 0) {
                        stb.deleteCharAt(stb.length() - 1);
                        stb.append("*" + matrix[i][j] + " ");
                    }
                }
                ++j;
            }
            if (stb.length() != 0) {
                stb.append("<br>");
            }
            ++i;
        }
        return stb.toString();
    }

    public String transitionInv(BigRational[][] matrix) {
        StringBuilder stb = new StringBuilder();
        int i = 0;
        while (i < matrix.length) {
            int j = 0;
            while (j < matrix[0].length) {
                if (!matrix[i][j].isZero()) {
                    String title = this.pn.getTransitions().get(j).getName();
                    if (title.isEmpty() && (title = this.pn.getTransitions().get(j).getId()).isEmpty()) {
                        title = "t<sub>" + j + "</sub>";
                    }
                    stb.append(String.valueOf(title) + " ");
                    if (matrix[i][j].compareTo(new BigRational(1)) != 0) {
                        stb.deleteCharAt(stb.length() - 1);
                        stb.append("*" + matrix[i][j] + " ");
                    }
                }
                ++j;
            }
            if (stb.length() != 0) {
                stb.append("<br>");
            }
            ++i;
        }
        return stb.toString();
    }
}

