/*
 * Decompiled with CFR 0.152.
 */
package invariants;

import pn.ModuleImpl;
import pn.modules.pn.IPetriNet;

public class Matrices {
    private int[][] incidenceTransposeMatrix;
    private int[][] incidenceMatrix;
    private IPetriNet pn;

    public Matrices(IPetriNet pn) {
        this.pn = pn;
        this.incidenceMatrix = new int[pn.getPlaces().size()][pn.getTransitions().size()];
        this.incidenceTransposeMatrix = new int[pn.getTransitions().size()][pn.getPlaces().size()];
        int[][] pre = ModuleImpl.getPreTable(pn);
        int[][] post = ModuleImpl.getPostTable(pn);
        int i = 0;
        while (i < pn.getPlaces().size()) {
            int j = 0;
            while (j < pn.getTransitions().size()) {
                int n = post[i][j] - pre[i][j];
                this.incidenceMatrix[i][j] = n;
                this.incidenceTransposeMatrix[j][i] = n;
                ++j;
            }
            ++i;
        }
    }

    public String transposeToTable() {
        StringBuilder stb = new StringBuilder("<table align=\"center\">");
        stb.append("<tr><th></th>");
        int i = 0;
        while (i < this.incidenceMatrix.length) {
            String title = this.pn.getPlaces().get(i).getName();
            if (title.isEmpty()) {
                title = this.pn.getPlaces().get(i).getId();
            }
            stb.append("<th>" + title + "</th>");
            ++i;
        }
        stb.append("</tr>");
        i = 0;
        while (i < this.incidenceTransposeMatrix.length) {
            stb.append("<tr>");
            int j = 0;
            while (j < this.incidenceTransposeMatrix[0].length) {
                if (j == 0) {
                    String title = this.pn.getTransitions().get(i).getName();
                    if (title.isEmpty() && (title = this.pn.getTransitions().get(i).getId()).isEmpty()) {
                        title = "t<sub>" + j + "</sub>";
                    }
                    stb.append("<th>" + title + "</th>");
                }
                stb.append("<td>" + this.incidenceTransposeMatrix[i][j] + "</td>");
                ++j;
            }
            stb.append("</tr>");
            ++i;
        }
        stb.append("</table><br>");
        return stb.toString();
    }

    public String incidenceToTable() {
        StringBuilder stb = new StringBuilder("<table align=\"center\">");
        stb.append("<tr><th></th>");
        int i = 0;
        while (i < this.incidenceMatrix[0].length) {
            String title = this.pn.getTransitions().get(i).getName();
            if (title.isEmpty()) {
                title = this.pn.getTransitions().get(i).getId();
            }
            stb.append("<th>" + title + "</th>");
            ++i;
        }
        stb.append("</tr>");
        i = 0;
        while (i < this.incidenceMatrix.length) {
            stb.append("<tr>");
            int j = 0;
            while (j < this.incidenceMatrix[0].length) {
                if (j == 0) {
                    String title = this.pn.getPlaces().get(i).getName();
                    if (title.isEmpty() && (title = this.pn.getPlaces().get(i).getId()).isEmpty()) {
                        title = "p<sub>" + j + "</sub>";
                    }
                    stb.append("<th>" + title + "</th>");
                }
                stb.append("<td>" + this.incidenceMatrix[i][j] + "</td>");
                ++j;
            }
            stb.append("</tr>");
            ++i;
        }
        stb.append("</table><br>");
        return stb.toString();
    }

    public int[][] getIncidenceTransposeMatrix() {
        return this.incidenceTransposeMatrix;
    }

    public int[][] getIncidenceMatrix() {
        return this.incidenceMatrix;
    }
}

