/*
 * Decompiled with CFR 0.152.
 */
package invariants;

import com.jogamp.opencl.CLContext;
import invariants.Matrices;
import invariants.PNInvariants;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import pn.BigRational;
import pn.ModuleImpl;

public class InvariantsResultsFrame
extends JFrame {
    private ModuleImpl entryPoint;
    private StringBuilder htmlPlaces = null;
    private StringBuilder htmlTransitions = null;
    private PNInvariants inv = null;
    private ButtonGroup buttonGroup1;
    private JScrollPane jScrollPane1;
    private JTextPane jTextPane1;
    private JRadioButton placeInvariantsButton;
    private JRadioButton transitionInvariantsButton;
    private JCheckBox useGPGPU;

    public InvariantsResultsFrame(ModuleImpl entryPoint) {
        this.entryPoint = entryPoint;
        this.initComponents();
        HTMLEditorKit kit = new HTMLEditorKit();
        StyleSheet style = kit.getStyleSheet();
        style.addRule("body {color:black; font-family:Arial, Helvetica, sans-serif; font-size: 10px;}");
        style.addRule("table {margin: 1px; border-style: solid;");
        style.addRule("th {font-weight: bold; border-style: solid; padding: 2px; text-align:center;}");
        style.addRule("td {border-style: solid; padding: 1px; text-align:right;}");
        this.jTextPane1.setEditorKit(kit);
        try {
            CLContext cLContext = CLContext.create();
        }
        catch (Exception ex) {
            System.out.println(ex);
            this.useGPGPU.setEnabled(false);
            this.useGPGPU.setToolTipText("OpenCL compatible device not found!");
        }
    }

    public void setResults(StringBuilder results) {
        results.append("</html>");
        this.jTextPane1.setText(results.toString());
    }

    private void compute() {
        if (this.inv == null) {
            this.inv = new PNInvariants(this.entryPoint.getPetriNet());
        }
        if (this.placeInvariantsButton.isSelected()) {
            if (this.htmlPlaces == null) {
                this.htmlPlaces = new StringBuilder();
                this.htmlPlaces.append("<html><h2>Place invariants analysis (S-invariants)</h2><br>");
                this.htmlPlaces.append("The incidence transpose matrix c<sup>T</sup> is: <br>");
                this.htmlPlaces.append(this.inv.matrices.transposeToTable());
                this.htmlPlaces.append("The solution of the equation c<sup>T</sup> . y = 0 is <br><br>");
                BigRational[][] res = this.inv.getPlaceInvariants(this.entryPoint.getPetriNet(), this.entryPoint.getLesSolver());
                this.htmlPlaces.append(this.inv.toHTML(res, 'y'));
                this.htmlPlaces.append("<br>" + this.inv.getTimeInfo());
                if (this.useGPGPU.isSelected()) {
                    this.htmlPlaces.append("<br>" + this.entryPoint.getLesSolver().solveGPU(new Matrices(this.entryPoint.getPetriNet()).getIncidenceTransposeMatrix(), null).getTextualSolution().toString());
                    this.htmlPlaces.append("<br>" + this.entryPoint.getLesSolver().solveGPUReal(new Matrices(this.entryPoint.getPetriNet()).getIncidenceTransposeMatrix(), null).getTextualSolution().toString());
                }
                this.htmlPlaces.append("<br><br>If parameters p<sub>0</sub>...p<sub>n</sub> are replaced for numbers and the expression <i>y</i> is evaluated, it becomes one of the invariants.");
                this.htmlPlaces.append("Substituting parameters p<sub>0</sub>...p<sub>n</sub> for different numbers yields to different invariants.");
                this.htmlPlaces.append("<br><br><b>One example of invariants:<br><br></b>");
                this.htmlPlaces.append(this.inv.placeInv(res));
            }
            this.setResults(this.htmlPlaces);
        } else {
            if (this.htmlTransitions == null) {
                this.htmlTransitions = new StringBuilder();
                this.htmlTransitions.append("<html><h2>Transition invariants analysis (T-invariants)</h2><br>");
                this.htmlTransitions.append("The incidence matrix c is: <br>");
                this.htmlTransitions.append(this.inv.matrices.incidenceToTable());
                this.htmlTransitions.append("The solution of the equation c . x = 0 is <br><br>");
                BigRational[][] res = this.inv.getTransitionInvariants(this.entryPoint.getPetriNet(), this.entryPoint.getLesSolver());
                this.htmlTransitions.append(this.inv.toHTML(res, 'x'));
                this.htmlTransitions.append("<br>" + this.inv.getTimeInfo());
                if (this.useGPGPU.isSelected()) {
                    this.htmlTransitions.append("<br>" + this.entryPoint.getLesSolver().solveGPU(new Matrices(this.entryPoint.getPetriNet()).getIncidenceTransposeMatrix(), null).getTextualSolution().toString().replace('y', 'x'));
                    this.htmlTransitions.append("<br>" + this.entryPoint.getLesSolver().solveGPUReal(new Matrices(this.entryPoint.getPetriNet()).getIncidenceTransposeMatrix(), null).getTextualSolution().toString().replace('y', 'x'));
                }
                this.htmlTransitions.append("<br><br>If parameters p<sub>0</sub>...p<sub>n</sub> are replaced for numbers and the expression <i>x</i> is evaluated, it becomes one of the invariants.");
                this.htmlTransitions.append("Substituting parameters p<sub>0</sub>...p<sub>n</sub> for different numbers yields to different invariants.");
                this.htmlTransitions.append("<br><br><b>One example of invariants:<br><br></b>");
                this.htmlTransitions.append(this.inv.transitionInv(res));
            }
            this.setResults(this.htmlTransitions);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jScrollPane1 = new JScrollPane();
        this.jTextPane1 = new JTextPane();
        this.placeInvariantsButton = new JRadioButton();
        this.transitionInvariantsButton = new JRadioButton();
        this.useGPGPU = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setTitle("Invariants analysis");
        this.jTextPane1.setEditable(false);
        this.jScrollPane1.setViewportView(this.jTextPane1);
        this.buttonGroup1.add(this.placeInvariantsButton);
        this.placeInvariantsButton.setText("Place Invariants");
        this.placeInvariantsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InvariantsResultsFrame.this.placeInvariantsButtonActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.transitionInvariantsButton);
        this.transitionInvariantsButton.setText("Transition Invariants");
        this.transitionInvariantsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InvariantsResultsFrame.this.transitionInvariantsButtonActionPerformed(evt);
            }
        });
        this.useGPGPU.setText("Use GP/GPU");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.placeInvariantsButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.transitionInvariantsButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.useGPGPU)).addComponent(this.jScrollPane1, -1, 498, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.placeInvariantsButton).addComponent(this.transitionInvariantsButton).addComponent(this.useGPGPU)).addGap(3, 3, 3).addComponent(this.jScrollPane1, -1, 391, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void placeInvariantsButtonActionPerformed(ActionEvent evt) {
        this.compute();
    }

    private void transitionInvariantsButtonActionPerformed(ActionEvent evt) {
        this.compute();
    }
}

