/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl.util.concurrent;

import com.jogamp.opencl.CLCommandQueue;
import com.jogamp.opencl.CLResource;
import com.jogamp.opencl.util.concurrent.CLPoolable;
import com.jogamp.opencl.util.concurrent.CLQueueContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CLExecutorService
implements CLResource {
    protected final ExecutorService excecutor;
    protected final List<CLCommandQueue> queues;
    private FinishAction finishAction = FinishAction.DO_NOTHING;
    private boolean released;

    protected CLExecutorService(ExecutorService executor, List<CLCommandQueue> queues) {
        this.queues = queues;
        this.excecutor = executor;
    }

    <R> TaskWrapper<R> wrapTask(CLPoolable<? extends CLQueueContext, R> task) {
        return new TaskWrapper(task, this.finishAction);
    }

    private <R> List<TaskWrapper<R>> wrapTasks(Collection<? extends CLPoolable<? extends CLQueueContext, R>> tasks) {
        ArrayList<TaskWrapper<R>> wrapper = new ArrayList<TaskWrapper<R>>(tasks.size());
        for (CLPoolable<CLQueueContext, R> cLPoolable : tasks) {
            if (cLPoolable == null) {
                throw new NullPointerException("at least one task was null");
            }
            wrapper.add(new TaskWrapper(cLPoolable, this.finishAction));
        }
        return wrapper;
    }

    public <R> List<Future<R>> invokeAll(Collection<? extends CLPoolable<? extends CLQueueContext, R>> tasks) throws InterruptedException {
        List<TaskWrapper<R>> wrapper = this.wrapTasks(tasks);
        return this.excecutor.invokeAll(wrapper);
    }

    public <R> List<Future<R>> invokeAll(Collection<? extends CLPoolable<? extends CLQueueContext, R>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        List<TaskWrapper<R>> wrapper = this.wrapTasks(tasks);
        return this.excecutor.invokeAll(wrapper, timeout, unit);
    }

    public <R> R invokeAny(Collection<? extends CLPoolable<? extends CLQueueContext, R>> tasks) throws InterruptedException, ExecutionException {
        List<TaskWrapper<R>> wrapper = this.wrapTasks(tasks);
        return this.excecutor.invokeAny(wrapper);
    }

    public <R> R invokeAny(Collection<? extends CLPoolable<? super CLQueueContext, R>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        List<TaskWrapper<R>> wrapper = this.wrapTasks(tasks);
        return this.excecutor.invokeAny(wrapper, timeout, unit);
    }

    public <R> Future<R> submit(CLPoolable<? extends CLQueueContext, R> task) {
        return this.excecutor.submit(this.wrapTask(task));
    }

    public <R> List<Future<R>> submitAll(Collection<? extends CLPoolable<? extends CLQueueContext, R>> tasks) {
        ArrayList<Future<R>> futures = new ArrayList<Future<R>>(tasks.size());
        for (CLPoolable<CLQueueContext, R> cLPoolable : tasks) {
            futures.add(this.submit(cLPoolable));
        }
        return futures;
    }

    public void flushQueues() {
        for (CLCommandQueue queue : this.queues) {
            queue.flush();
        }
    }

    public void finishQueues() {
        for (CLCommandQueue queue : this.queues) {
            queue.finish();
        }
    }

    public List<CLCommandQueue> getQueues() {
        return Collections.unmodifiableList(this.queues);
    }

    public int getPoolSize() {
        return this.queues.size();
    }

    public FinishAction getFinishAction() {
        return this.finishAction;
    }

    ExecutorService getExcecutor() {
        return this.excecutor;
    }

    @Override
    public boolean isReleased() {
        return this.released;
    }

    public void setFinishAction(FinishAction action) {
        this.finishAction = action;
    }

    @Override
    public void release() {
        if (this.released) {
            throw new RuntimeException(this.getClass().getSimpleName() + " already released");
        }
        this.released = true;
        this.excecutor.shutdownNow();
        try {
            this.excecutor.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FinishAction {
        DO_NOTHING,
        FLUSH,
        FINISH;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class TaskWrapper<R>
    implements Callable<R> {
        protected final CLPoolable<CLQueueContext, R> task;
        private final FinishAction mode;

        private TaskWrapper(CLPoolable<CLQueueContext, R> task, FinishAction mode) {
            this.task = task;
            this.mode = mode;
        }

        @Override
        public R call() throws Exception {
            CommandQueueThread thread = (CommandQueueThread)((Object)Thread.currentThread());
            Object key = this.task.getContextKey();
            CLQueueContext context = thread.getContextMap().get(key);
            if (context == null) {
                context = this.task.createQueueContext(thread.getQueue());
                thread.getContextMap().put(key, context);
            }
            R result = this.task.execute(context);
            if (this.mode.equals((Object)FinishAction.FLUSH)) {
                context.queue.flush();
            } else if (this.mode.equals((Object)FinishAction.FINISH)) {
                context.queue.finish();
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface CommandQueueThread {
        public Map<Object, CLQueueContext> getContextMap();

        public CLCommandQueue getQueue();
    }
}

