/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl.util.concurrent;

import com.jogamp.opencl.CLCommandQueue;
import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.util.CLMultiContext;
import com.jogamp.opencl.util.concurrent.CLExecutorService;
import com.jogamp.opencl.util.concurrent.CLPoolable;
import com.jogamp.opencl.util.concurrent.CLQueueContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CLCommandQueuePool
extends CLExecutorService {
    private CLCommandQueuePool(ExecutorService executor, List<CLCommandQueue> queues) {
        super(executor, queues);
    }

    public static CLCommandQueuePool create(CLMultiContext mc, CLCommandQueue.Mode ... modes) {
        return CLCommandQueuePool.create(mc.getDevices(), modes);
    }

    public static CLCommandQueuePool create(Collection<? extends CLDevice> devices, CLCommandQueue.Mode ... modes) {
        ArrayList<CLCommandQueue> queues = new ArrayList<CLCommandQueue>(devices.size());
        for (CLDevice cLDevice : devices) {
            queues.add(cLDevice.createCommandQueue(modes));
        }
        return CLCommandQueuePool.create(queues);
    }

    public static CLCommandQueuePool create(Collection<CLCommandQueue> queues) {
        ArrayList<CLCommandQueue> list = new ArrayList<CLCommandQueue>(queues);
        LinkedBlockingDeque<Runnable> queue = new LinkedBlockingDeque<Runnable>();
        CommandQueuePoolThreadFactory factory = new CommandQueuePoolThreadFactory(list);
        int size = list.size();
        CLThreadPoolExecutor executor = new CLThreadPoolExecutor(size, size, 0L, TimeUnit.MILLISECONDS, queue, factory);
        return new CLCommandQueuePool(executor, list);
    }

    CLPoolable<? extends CLQueueContext, ?> takeCLTask() throws InterruptedException {
        return ((CLFutureTask)this.getExcecutor().getQueue().take()).getCLPoolable();
    }

    public long getTaskCount() {
        return this.getExcecutor().getTaskCount();
    }

    public long getCompletedTaskCount() {
        return this.getExcecutor().getCompletedTaskCount();
    }

    public int getActiveCount() {
        return this.getExcecutor().getActiveCount();
    }

    @Override
    ThreadPoolExecutor getExcecutor() {
        return (ThreadPoolExecutor)this.excecutor;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [queues: " + this.getPoolSize() + " on finish: " + (Object)((Object)this.getFinishAction()) + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CLThreadPoolExecutor
    extends ThreadPoolExecutor {
        public CLThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
        }

        protected <R> RunnableFuture<R> newTaskFor(Callable<R> callable) {
            CLExecutorService.TaskWrapper wrapper = (CLExecutorService.TaskWrapper)callable;
            return new CLFutureTask(wrapper);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CLFutureTask<R>
    extends FutureTask<R> {
        private final CLExecutorService.TaskWrapper<R> wrapper;

        public CLFutureTask(CLExecutorService.TaskWrapper<R> wrapper) {
            super(wrapper);
            this.wrapper = wrapper;
        }

        public CLPoolable<? extends CLQueueContext, R> getCLPoolable() {
            return this.wrapper.task;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CommandQueuePoolThread
    extends Thread
    implements CLExecutorService.CommandQueueThread {
        private final CLCommandQueue queue;
        private final Map<Object, CLQueueContext> contextMap;

        public CommandQueuePoolThread(ThreadGroup group, Runnable runnable, CLCommandQueue queue, int index) {
            super(group, runnable, "queue-worker-thread-" + index + "[" + queue + "]");
            this.queue = queue;
            this.contextMap = new HashMap<Object, CLQueueContext>();
        }

        @Override
        public void run() {
            super.run();
            this.queue.finish();
            for (CLQueueContext context : this.contextMap.values()) {
                context.release();
            }
        }

        @Override
        public CLCommandQueue getQueue() {
            return this.queue;
        }

        @Override
        public Map<Object, CLQueueContext> getContextMap() {
            return this.contextMap;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CommandQueuePoolThreadFactory
    implements ThreadFactory {
        private final List<CLCommandQueue> queues;
        private int index;

        public CommandQueuePoolThreadFactory(List<CLCommandQueue> queues) {
            this.queues = queues;
            this.index = 0;
        }

        @Override
        public synchronized Thread newThread(Runnable runnable) {
            SecurityManager sm = System.getSecurityManager();
            ThreadGroup group = sm != null ? sm.getThreadGroup() : Thread.currentThread().getThreadGroup();
            CLCommandQueue queue = this.queues.get(this.index);
            CommandQueuePoolThread thread = new CommandQueuePoolThread(group, runnable, queue, this.index++);
            thread.setDaemon(true);
            return thread;
        }
    }
}

