/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl.util;

import com.jogamp.opencl.CLCommandQueue;
import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.CLPlatform;
import com.jogamp.opencl.CLVersion;
import com.jogamp.opencl.util.CLDeviceFilters;
import com.jogamp.opencl.util.Filter;
import java.util.Arrays;
import javax.media.opengl.GLContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CLPlatformFilters {
    public static Filter<CLPlatform> version(final CLVersion version) {
        return new Filter<CLPlatform>(){

            @Override
            public boolean accept(CLPlatform item) {
                return item.isAtLeast(version);
            }
        };
    }

    public static Filter<CLPlatform> type(final CLDevice.Type type) {
        return new Filter<CLPlatform>(){

            @Override
            public boolean accept(CLPlatform item) {
                return item.listCLDevices(type).length > 0;
            }
        };
    }

    public static Filter<CLPlatform> glSharing() {
        return new Filter<CLPlatform>(){
            private final Filter<CLDevice> glFilter = CLDeviceFilters.glSharing();

            @Override
            public boolean accept(CLPlatform item) {
                CLDevice[] devices;
                for (CLDevice device : devices = item.listCLDevices()) {
                    if (!this.glFilter.accept(device)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Filter<CLPlatform> glSharing(final GLContext context) {
        return new Filter<CLPlatform>(){
            private final Filter<CLPlatform> glFilter = CLPlatformFilters.glSharing();

            @Override
            public boolean accept(CLPlatform item) {
                String glVendor = context.getGL().glGetString(7936);
                String clVendor = item.getVendor();
                return clVendor.equals(glVendor) && this.glFilter.accept(item);
            }
        };
    }

    public static Filter<CLPlatform> extension(final String ... extensions) {
        return new Filter<CLPlatform>(){

            @Override
            public boolean accept(CLPlatform item) {
                return item.getExtensions().containsAll(Arrays.asList(extensions));
            }
        };
    }

    public static Filter<CLPlatform> queueMode(final CLCommandQueue.Mode ... modes) {
        return new Filter<CLPlatform>(){
            private final Filter<CLDevice> queueModeFilter;
            {
                this.queueModeFilter = CLDeviceFilters.queueMode(modes);
            }

            @Override
            public boolean accept(CLPlatform item) {
                for (CLDevice device : item.listCLDevices()) {
                    if (!this.queueModeFilter.accept(device)) continue;
                    return true;
                }
                return false;
            }
        };
    }
}

