/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl.util;

import com.jogamp.common.os.Platform;
import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.CLPlatform;
import com.jogamp.opencl.llb.impl.CLImpl;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CLInfo {
    public static StringBuilder print(StringBuilder sb) {
        CLPlatform[] platforms;
        sb.append("HOST_JRE: ").append(System.getProperty("java.runtime.version")).append("\n");
        sb.append("HOST_JVM: ").append(System.getProperty("java.vm.name")).append("\n");
        sb.append("HOST_ARCH: ").append(Platform.getArch()).append("\n");
        sb.append("HOST_NUM_CORES: ").append(Runtime.getRuntime().availableProcessors()).append("\n");
        sb.append("HOST_OS: ").append(Platform.getOS()).append("\n");
        sb.append("HOST_LITTLE_ENDIAN: ").append(Platform.isLittleEndian()).append("\n");
        CLPlatform.initialize();
        sb.append("CL_BINDING_UNAVAILABLE_FUNCTIONS: ");
        sb.append(((CLImpl)CLPlatform.getLowLevelCLInterface()).getAddressTable().getNullPointerFunctions());
        sb.append("\n");
        for (CLPlatform platform : platforms = CLPlatform.listCLPlatforms()) {
            CLDevice[] devices;
            Map<String, String> platformProperties = platform.getProperties();
            sb.append("\n");
            CLInfo.printInfo(sb, "", platformProperties);
            for (CLDevice device : devices = platform.listCLDevices()) {
                Map<String, String> deviceProperties = device.getProperties();
                sb.append("\n");
                CLInfo.printInfo(sb, " - ", deviceProperties);
            }
        }
        return sb;
    }

    private static void printInfo(StringBuilder sb, String prefix, Map<String, String> properties) {
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            sb.append(prefix).append(entry.getKey()).append(": ").append(entry.getValue()).append(Platform.getNewline());
        }
    }

    public static void main(String[] args) throws Exception {
        System.out.println(CLInfo.print(new StringBuilder()).toString());
    }
}

