/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl.llb.impl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.NativeSizeBuffer;
import com.jogamp.common.util.LongLongHashMap;
import com.jogamp.opencl.CLErrorHandler;
import com.jogamp.opencl.CLException;
import com.jogamp.opencl.llb.impl.BuildProgramCallback;
import com.jogamp.opencl.llb.impl.CLAbstractImpl;
import com.jogamp.opencl.llb.impl.CLEventCallback;
import com.jogamp.opencl.llb.impl.CLMemObjectDestructorCallback;
import com.jogamp.opencl.llb.impl.CLProcAddressTable;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;

public class CLImpl
extends CLAbstractImpl {
    private final LongLongHashMap contextCallbackMap = new LongLongHashMap();

    public CLImpl(CLProcAddressTable addressTable) {
        super(addressTable);
        this.contextCallbackMap.setKeyNotFoundValue(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long clCreateContext(NativeSizeBuffer properties, NativeSizeBuffer devices, CLErrorHandler pfn_notify, IntBuffer errcode_ret) {
        if (properties != null && !properties.isDirect()) {
            throw new RuntimeException("Argument \"properties\" was not a direct buffer");
        }
        if (errcode_ret != null && !errcode_ret.isDirect()) {
            throw new RuntimeException("Argument \"errcode_ret\" was not a direct buffer");
        }
        long address = this.addressTable._addressof_clCreateContext;
        if (address == 0L) {
            throw new UnsupportedOperationException("Method not available");
        }
        long[] global = new long[1];
        long ctx = this.clCreateContext0(properties != null ? properties.getBuffer() : null, Buffers.getDirectBufferByteOffset(properties), devices != null ? devices.remaining() : 0, devices != null ? devices.getBuffer() : null, Buffers.getDirectBufferByteOffset(devices), pfn_notify, global, errcode_ret, Buffers.getDirectBufferByteOffset(errcode_ret), address);
        if (pfn_notify != null && global[0] != 0L) {
            LongLongHashMap longLongHashMap = this.contextCallbackMap;
            synchronized (longLongHashMap) {
                this.contextCallbackMap.put(ctx, global[0]);
            }
        }
        return ctx;
    }

    private native long clCreateContext0(Object var1, int var2, int var3, Object var4, int var5, Object var6, long[] var7, Object var8, int var9, long var10);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long clCreateContextFromType(NativeSizeBuffer properties, long device_type, CLErrorHandler pfn_notify, IntBuffer errcode_ret) {
        if (properties != null && !properties.isDirect()) {
            throw new RuntimeException("Argument \"properties\" was not a direct buffer");
        }
        if (errcode_ret != null && !errcode_ret.isDirect()) {
            throw new RuntimeException("Argument \"errcode_ret\" was not a direct buffer");
        }
        long address = this.addressTable._addressof_clCreateContextFromType;
        if (address == 0L) {
            throw new UnsupportedOperationException("Method not available");
        }
        long[] global = new long[1];
        long ctx = this.clCreateContextFromType0(properties != null ? properties.getBuffer() : null, Buffers.getDirectBufferByteOffset(properties), device_type, pfn_notify, global, errcode_ret, Buffers.getDirectBufferByteOffset(errcode_ret), address);
        if (pfn_notify != null && global[0] != 0L) {
            LongLongHashMap longLongHashMap = this.contextCallbackMap;
            synchronized (longLongHashMap) {
                this.contextCallbackMap.put(ctx, global[0]);
            }
        }
        return ctx;
    }

    private native long clCreateContextFromType0(Object var1, int var2, long var3, Object var5, long[] var6, Object var7, int var8, long var9);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int clReleaseContext(long context) {
        long global = 0L;
        LongLongHashMap longLongHashMap = this.contextCallbackMap;
        synchronized (longLongHashMap) {
            global = this.contextCallbackMap.remove(context);
        }
        long address = this.addressTable._addressof_clReleaseContext;
        if (address == 0L) {
            throw new UnsupportedOperationException("Method not available");
        }
        return this.clReleaseContextImpl(context, global, address);
    }

    public native int clReleaseContextImpl(long var1, long var3, long var5);

    public int clBuildProgram(long program, int deviceCount, NativeSizeBuffer deviceList, String options, BuildProgramCallback cb) {
        if (deviceList != null && !deviceList.isDirect()) {
            throw new RuntimeException("Argument \"properties\" was not a direct buffer");
        }
        long address = this.addressTable._addressof_clBuildProgram;
        if (address == 0L) {
            throw new UnsupportedOperationException("Method not available");
        }
        return this.clBuildProgram0(program, deviceCount, deviceList != null ? deviceList.getBuffer() : null, Buffers.getDirectBufferByteOffset(deviceList), options, cb, address);
    }

    private native int clBuildProgram0(long var1, int var3, Object var4, int var5, String var6, BuildProgramCallback var7, long var8);

    public int clSetEventCallback(long event, int trigger, CLEventCallback callback) {
        long address = this.addressTable._addressof_clSetEventCallback;
        if (address == 0L) {
            throw new UnsupportedOperationException("Method not available");
        }
        return this.clSetEventCallback0(event, trigger, callback, address);
    }

    private native int clSetEventCallback0(long var1, int var3, CLEventCallback var4, long var5);

    public int clSetMemObjectDestructorCallback(long memObjID, CLMemObjectDestructorCallback cb) {
        long address = this.addressTable._addressof_clSetMemObjectDestructorCallback;
        if (address == 0L) {
            throw new UnsupportedOperationException("Method not available");
        }
        return this.clSetMemObjectDestructorCallback0(memObjID, cb, address);
    }

    private native int clSetMemObjectDestructorCallback0(long var1, CLMemObjectDestructorCallback var3, long var4);

    public ByteBuffer clEnqueueMapImage(long command_queue, long image, int blocking_map, long map_flags, NativeSizeBuffer origin, NativeSizeBuffer range, NativeSizeBuffer image_row_pitch, NativeSizeBuffer image_slice_pitch, int num_events_in_wait_list, NativeSizeBuffer event_wait_list, NativeSizeBuffer event, IntBuffer errcode_ret) {
        if (origin != null && !origin.isDirect()) {
            throw new CLException("Argument \"origin\" was not a direct buffer");
        }
        if (range != null && !range.isDirect()) {
            throw new CLException("Argument \"range\" was not a direct buffer");
        }
        if (image_row_pitch != null && !image_row_pitch.isDirect()) {
            throw new CLException("Argument \"image_row_pitch\" was not a direct buffer");
        }
        if (image_slice_pitch != null && !image_slice_pitch.isDirect()) {
            throw new CLException("Argument \"image_slice_pitch\" was not a direct buffer");
        }
        if (event_wait_list != null && !event_wait_list.isDirect()) {
            throw new CLException("Argument \"event_wait_list\" was not a direct buffer");
        }
        if (event != null && !event.isDirect()) {
            throw new CLException("Argument \"event\" was not a direct buffer");
        }
        if (errcode_ret != null && !errcode_ret.isDirect()) {
            throw new CLException("Argument \"errcode_ret\" was not a direct buffer");
        }
        long mapImageAddress = this.addressTable._addressof_clEnqueueMapImage;
        if (mapImageAddress == 0L) {
            throw new UnsupportedOperationException("Method not available");
        }
        long getImageInfoAddress = this.addressTable._addressof_clGetImageInfo;
        if (getImageInfoAddress == 0L) {
            throw new UnsupportedOperationException("Method not available");
        }
        ByteBuffer _res = this.clEnqueueMapImage0(command_queue, image, blocking_map, map_flags, origin != null ? origin.getBuffer() : null, Buffers.getDirectBufferByteOffset(origin), range != null ? range.getBuffer() : null, Buffers.getDirectBufferByteOffset(range), image_row_pitch != null ? image_row_pitch.getBuffer() : null, Buffers.getDirectBufferByteOffset(image_row_pitch), image_slice_pitch != null ? image_slice_pitch.getBuffer() : null, Buffers.getDirectBufferByteOffset(image_slice_pitch), num_events_in_wait_list, event_wait_list != null ? event_wait_list.getBuffer() : null, Buffers.getDirectBufferByteOffset(event_wait_list), event != null ? event.getBuffer() : null, Buffers.getDirectBufferByteOffset(event), errcode_ret, Buffers.getDirectBufferByteOffset(errcode_ret));
        if (_res == null) {
            return null;
        }
        Buffers.nativeOrder(_res);
        return _res;
    }

    private native ByteBuffer clEnqueueMapImage0(long var1, long var3, int var5, long var6, Object var8, int var9, Object var10, int var11, Object var12, int var13, Object var14, int var15, int var16, Object var17, int var18, Object var19, int var20, Object var21, int var22);

    public long clGetExtensionFunctionAddress(String name) {
        long address = this.addressTable._addressof_clGetExtensionFunctionAddress;
        if (address == 0L) {
            throw new UnsupportedOperationException("Method not available");
        }
        return this.dispatch_clGetExtensionFunctionAddress1(name, address);
    }

    private native long dispatch_clGetExtensionFunctionAddress1(String var1, long var2);

    public CLProcAddressTable getAddressTable() {
        return this.addressTable;
    }
}

