/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CLVersion
implements Comparable<CLVersion> {
    private static final Pattern pattern = Pattern.compile("OpenCL (?:C )?(\\d+)\\.(\\d+)(.*)");
    public static final CLVersion CL_1_0 = new CLVersion("OpenCL 1.0");
    public static final CLVersion CL_1_1 = new CLVersion("OpenCL 1.1");
    public final String fullversion;
    public final String implversion;
    public final short minor;
    public final short major;

    protected CLVersion(String version) {
        this.fullversion = version;
        Matcher matcher = pattern.matcher(version);
        matcher.matches();
        this.major = Short.parseShort(matcher.group(1));
        this.minor = Short.parseShort(matcher.group(2));
        this.implversion = matcher.groupCount() == 4 ? matcher.group(3).substring(1) : "";
    }

    @Override
    public int compareTo(CLVersion other) {
        return this.compareTo(other.major, other.minor);
    }

    private int compareTo(int otherMajor, int otherMinor) {
        if (otherMajor == this.major && otherMinor == this.minor) {
            return 0;
        }
        if (this.major > otherMajor || this.major == otherMajor && this.minor > otherMinor) {
            return 1;
        }
        return -1;
    }

    public boolean isAtLeast(CLVersion other) {
        return this.compareTo(other) >= 0;
    }

    public boolean isAtLeast(int major, int minor) {
        return this.compareTo(major, minor) >= 0;
    }

    public boolean isEqual(CLVersion other) {
        return this.isEqual(other.major, other.minor);
    }

    public boolean isEqual(int major, int minor) {
        return this.major == major && this.minor == minor;
    }

    public String getSpecVersion() {
        return "OpenCL " + this.major + '.' + this.minor;
    }

    public String getFullVersion() {
        return this.fullversion;
    }

    public String getImplVersion() {
        return this.implversion;
    }

    public short getMajor() {
        return this.major;
    }

    public short getMinor() {
        return this.minor;
    }

    public String toString() {
        return this.getFullVersion();
    }

    public int hashCode() {
        return this.fullversion.hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass() && this.fullversion.equals(((CLVersion)obj).fullversion);
    }
}

