/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl;

import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.CLException;
import com.jogamp.opencl.CLPlatform;
import com.jogamp.opencl.CLResource;
import com.jogamp.opencl.llb.CL;

public class CLSubDevice
extends CLDevice
implements CLResource {
    private volatile boolean released;
    private final CLDevice parent;

    private CLSubDevice(CLDevice parent, CLContext context, long id) {
        super(context, id);
        this.parent = parent;
    }

    private CLSubDevice(CLDevice parent, CLPlatform platform, long id) {
        super(platform, id);
        this.parent = parent;
    }

    static CLSubDevice createSubDevice(CLDevice device, long id) {
        if (device.context == null) {
            return new CLSubDevice(device, device.getPlatform(), id);
        }
        return new CLSubDevice(device, device.getContext(), id);
    }

    public CLDevice getParent() {
        return this.parent;
    }

    public void release() {
        if (this.released) {
            throw new RuntimeException("already released");
        }
        this.released = true;
        CL cl = CLPlatform.getLowLevelCLInterface();
        int ret = cl.clReleaseDeviceEXT(this.ID);
        CLException.checkForError(ret, "release failed");
    }

    public boolean isReleased() {
        return this.released;
    }

    public boolean isSubDevice() {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Partition {
        EQUALLY(16464),
        COUNTS(16465),
        NAMES(16466),
        DOMAIN(16467);

        public final int FLAG;

        private Partition(int type) {
            this.FLAG = type;
        }

        public static Partition valueOf(int domain) {
            Partition[] values;
            for (Partition value : values = Partition.values()) {
                if (value.FLAG != domain) continue;
                return value;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AffinityDomain {
        L1_CACHE(1),
        L2_CACHE(2),
        L3_CACHE(3),
        L4_CACHE(4),
        NUMA(16),
        NEXT_FISSIONABLE(256);

        public final int TYPE;

        private AffinityDomain(int type) {
            this.TYPE = type;
        }

        public static AffinityDomain valueOf(int domain) {
            AffinityDomain[] values;
            for (AffinityDomain value : values = AffinityDomain.values()) {
                if (value.TYPE != domain) continue;
                return value;
            }
            return null;
        }
    }
}

