/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl;

import com.jogamp.common.AutoCloseable;
import com.jogamp.common.nio.CachedBufferFactory;
import com.jogamp.common.nio.NativeSizeBuffer;
import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLEvent;
import com.jogamp.opencl.CLResource;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CLEventList
implements CLResource,
AutoCloseable,
Iterable<CLEvent> {
    private final CLEvent[] events;
    final NativeSizeBuffer IDs;
    final NativeSizeBuffer IDsView;
    int size;

    public CLEventList(int capacity) {
        this(null, capacity);
    }

    public CLEventList(CLEvent ... events) {
        this((CachedBufferFactory)null, events);
    }

    public CLEventList(CachedBufferFactory factory, int capacity) {
        this.events = new CLEvent[capacity];
        this.IDs = this.initIDBuffer(factory, capacity);
        this.IDsView = NativeSizeBuffer.wrap(this.IDs.getBuffer().duplicate());
    }

    public CLEventList(CachedBufferFactory factory, CLEvent ... events) {
        this.events = events;
        this.IDs = this.initIDBuffer(factory, events.length);
        this.IDsView = NativeSizeBuffer.wrap(this.IDs.getBuffer().duplicate());
        for (CLEvent event : events) {
            if (event == null) {
                throw new IllegalArgumentException("event list containes null element.");
            }
            this.IDs.put(event.ID);
        }
        this.IDs.rewind();
        this.size = events.length;
    }

    private NativeSizeBuffer initIDBuffer(CachedBufferFactory factory, int size) {
        if (factory == null) {
            return NativeSizeBuffer.allocateDirect(size);
        }
        return NativeSizeBuffer.wrap(factory.newDirectByteBuffer(size * NativeSizeBuffer.elementSize()));
    }

    void createEvent(CLContext context) {
        if (this.events[this.size] != null) {
            this.events[this.size].release();
        }
        this.events[this.size] = new CLEvent(context, this.IDs.get());
        ++this.size;
    }

    NativeSizeBuffer getEventBuffer(int index) {
        return (NativeSizeBuffer)NativeSizeBuffer.wrap(this.IDs.getBuffer().duplicate()).position(index);
    }

    public void waitForEvents() {
        if (this.size > 0) {
            this.events[0].getPlatform().getEventBinding().clWaitForEvents(this.size, this.IDsView);
        }
    }

    public void waitForEvents(int start, int range) {
        if (start + range < this.size || range <= 0) {
            throw new IndexOutOfBoundsException("args: [start: " + start + " range: " + range + "], eventcount: " + this.size);
        }
        NativeSizeBuffer view = this.getEventBuffer(start);
        this.getEvent(start).getPlatform().getEventBinding().clWaitForEvents(range, view);
    }

    public void waitForEvent(int index) {
        NativeSizeBuffer view = this.getEventBuffer(index);
        this.getEvent(index).getPlatform().getEventBinding().clWaitForEvents(1, view);
    }

    @Override
    public void release() {
        for (int i = 0; i < this.size; ++i) {
            this.events[i].release();
            this.events[i] = null;
        }
        this.size = 0;
        this.IDs.rewind();
    }

    @Override
    @Deprecated
    public final void close() throws Exception {
        this.release();
    }

    public CLEvent getEvent(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("list contains " + this.size + " events, can not return event with index " + index);
        }
        return this.events[index];
    }

    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.events.length;
    }

    @Override
    public boolean isReleased() {
        return this.size == 0;
    }

    @Override
    public Iterator<CLEvent> iterator() {
        return new EventIterator(this.events, this.size);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName()).append('[');
        for (int i = 0; i < this.size; ++i) {
            sb.append(this.events[i].toString());
            if (i + 1 == this.size) continue;
            sb.append(", ");
        }
        return sb.append(']').toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EventIterator
    implements Iterator<CLEvent> {
        private final CLEvent[] events;
        private final int size;
        private int index;

        private EventIterator(CLEvent[] events, int size) {
            this.events = events;
            this.size = size;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.size;
        }

        @Override
        public CLEvent next() {
            if (this.hasNext()) {
                return this.events[this.index++];
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() not supported.");
        }
    }
}

