/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.NativeSizeBuffer;
import com.jogamp.common.os.Platform;
import com.jogamp.opencl.CLBuffer;
import com.jogamp.opencl.CLCommandQueue;
import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.CLErrorHandler;
import com.jogamp.opencl.CLException;
import com.jogamp.opencl.CLImage2d;
import com.jogamp.opencl.CLImage3d;
import com.jogamp.opencl.CLImageFormat;
import com.jogamp.opencl.CLMemory;
import com.jogamp.opencl.CLObjectResource;
import com.jogamp.opencl.CLPlatform;
import com.jogamp.opencl.CLProgram;
import com.jogamp.opencl.CLResource;
import com.jogamp.opencl.CLSampler;
import com.jogamp.opencl.llb.CL;
import com.jogamp.opencl.llb.CLContextBinding;
import com.jogamp.opencl.llb.impl.CLImageFormatImpl;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CLContext
extends CLObjectResource {
    protected CLDevice[] devices;
    protected final Set<CLProgram> programs;
    protected final Set<CLSampler> samplers;
    protected final Set<CLMemory<? extends Buffer>> memoryObjects;
    protected final Map<CLDevice, List<CLCommandQueue>> queuesMap;
    protected final CLPlatform platform;
    private final ErrorDispatcher errorHandler;

    protected CLContext(CLPlatform platform, long contextID, ErrorDispatcher dispatcher) {
        super(contextID);
        this.platform = platform;
        this.programs = Collections.synchronizedSet(new HashSet());
        this.samplers = Collections.synchronizedSet(new HashSet());
        this.memoryObjects = Collections.synchronizedSet(new HashSet());
        this.queuesMap = new HashMap<CLDevice, List<CLCommandQueue>>();
        this.errorHandler = dispatcher;
    }

    private synchronized void initDevices(CLContextBinding cl) {
        if (this.devices == null) {
            NativeSizeBuffer deviceCount = NativeSizeBuffer.allocateDirect(1);
            int ret = cl.clGetContextInfo(this.ID, 4225, 0L, null, deviceCount);
            CLException.checkForError(ret, "can not enumerate devices");
            ByteBuffer deviceIDs = Buffers.newDirectByteBuffer((int)deviceCount.get());
            ret = cl.clGetContextInfo(this.ID, 4225, deviceIDs.capacity(), deviceIDs, null);
            CLException.checkForError(ret, "can not enumerate devices");
            this.devices = new CLDevice[deviceIDs.capacity() / (Platform.is32Bit() ? 4 : 8)];
            for (int i = 0; i < this.devices.length; ++i) {
                this.devices[i] = new CLDevice(this, Platform.is32Bit() ? (long)deviceIDs.getInt() : deviceIDs.getLong());
            }
        }
    }

    public static CLContext create() {
        return CLContext.create((CLPlatform)null, CLDevice.Type.ALL);
    }

    public static CLContext create(CLDevice.Type ... deviceTypes) {
        return CLContext.create(null, deviceTypes);
    }

    public static CLContext create(CLPlatform platform) {
        return CLContext.create(platform, CLDevice.Type.ALL);
    }

    public static CLContext create(CLPlatform platform, CLDevice.Type ... deviceTypes) {
        if (platform == null) {
            platform = CLPlatform.getDefault();
        }
        long type = CLContext.toDeviceBitmap(deviceTypes);
        NativeSizeBuffer properties = CLContext.setupContextProperties(platform);
        ErrorDispatcher dispatcher = new ErrorDispatcher();
        return new CLContext(platform, CLContext.createContextFromType(platform, dispatcher, properties, type), dispatcher);
    }

    public static CLContext create(CLDevice ... devices) {
        if (devices == null) {
            throw new IllegalArgumentException("no devices specified");
        }
        if (devices[0] == null) {
            throw new IllegalArgumentException("first device was null");
        }
        CLPlatform platform = devices[0].getPlatform();
        NativeSizeBuffer properties = CLContext.setupContextProperties(platform);
        ErrorDispatcher dispatcher = new ErrorDispatcher();
        CLContext context = new CLContext(platform, CLContext.createContext(platform, dispatcher, properties, devices), dispatcher);
        if (devices != null) {
            for (int i = 0; i < devices.length; ++i) {
                devices[i].setContext(context);
            }
        }
        return context;
    }

    protected static long createContextFromType(CLPlatform platform, CLErrorHandler handler, NativeSizeBuffer properties, long deviceType) {
        IntBuffer status = Buffers.newDirectIntBuffer(1);
        CLContextBinding cl = platform.getContextBinding();
        long context = cl.clCreateContextFromType(properties, deviceType, handler, status);
        CLException.checkForError(status.get(), "can not create CL context");
        return context;
    }

    protected static long createContext(CLPlatform platform, CLErrorHandler handler, NativeSizeBuffer properties, CLDevice ... devices) {
        IntBuffer status = Buffers.newDirectIntBuffer(1);
        NativeSizeBuffer pb = null;
        if (devices != null && devices.length != 0) {
            pb = NativeSizeBuffer.allocateDirect(devices.length);
            for (int i = 0; i < devices.length; ++i) {
                CLDevice device = devices[i];
                if (device == null) {
                    throw new IllegalArgumentException("device at index " + i + " was null.");
                }
                pb.put(i, device.ID);
            }
        }
        CLContextBinding cl = platform.getContextBinding();
        long context = cl.clCreateContext(properties, pb, handler, status);
        CLException.checkForError(status.get(), "can not create CL context");
        return context;
    }

    private static NativeSizeBuffer setupContextProperties(CLPlatform platform) {
        if (platform == null) {
            throw new RuntimeException("no OpenCL installation found");
        }
        return (NativeSizeBuffer)NativeSizeBuffer.allocateDirect(3).put(4228L).put(platform.ID).put(0L).rewind();
    }

    public CLProgram createProgram(String src) {
        CLProgram program = CLProgram.create(this, src);
        this.programs.add(program);
        return program;
    }

    public CLProgram createProgram(String ... sources) {
        if (sources.length == 0) {
            throw new IllegalArgumentException("source string array was empty");
        }
        StringBuilder sb = new StringBuilder(2048 * sources.length);
        for (String source : sources) {
            sb.append(source);
        }
        return this.createProgram(sb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CLProgram createProgram(InputStream ... sources) throws IOException {
        if (sources.length == 0) {
            throw new IllegalArgumentException("input stream array was empty");
        }
        StringBuilder sb = new StringBuilder(2048 * sources.length);
        for (InputStream source : sources) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(source));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    sb.append(line).append("\n");
                }
            }
            finally {
                reader.close();
            }
        }
        return this.createProgram(sb);
    }

    private CLProgram createProgram(StringBuilder sources) {
        return this.createProgram(sources.toString());
    }

    public CLProgram createProgram(Map<CLDevice, byte[]> binaries) {
        CLProgram program = CLProgram.create(this, binaries);
        this.programs.add(program);
        return program;
    }

    public final CLBuffer<ShortBuffer> createShortBuffer(int size, CLMemory.Mem ... flags) {
        return this.createBuffer(Buffers.newDirectShortBuffer(size), flags);
    }

    public final CLBuffer<IntBuffer> createIntBuffer(int size, CLMemory.Mem ... flags) {
        return this.createBuffer(Buffers.newDirectIntBuffer(size), flags);
    }

    public final CLBuffer<LongBuffer> createLongBuffer(int size, CLMemory.Mem ... flags) {
        return this.createBuffer(Buffers.newDirectLongBuffer(size), flags);
    }

    public final CLBuffer<FloatBuffer> createFloatBuffer(int size, CLMemory.Mem ... flags) {
        return this.createBuffer(Buffers.newDirectFloatBuffer(size), flags);
    }

    public final CLBuffer<DoubleBuffer> createDoubleBuffer(int size, CLMemory.Mem ... flags) {
        return this.createBuffer(Buffers.newDirectDoubleBuffer(size), flags);
    }

    public final CLBuffer<ByteBuffer> createByteBuffer(int size, CLMemory.Mem ... flags) {
        return this.createByteBuffer(size, CLMemory.Mem.flagsToInt(flags));
    }

    public final CLBuffer<ByteBuffer> createByteBuffer(int size, int flags) {
        return this.createBuffer(Buffers.newDirectByteBuffer(size), flags);
    }

    public final CLBuffer<?> createBuffer(int size, CLMemory.Mem ... flags) {
        return this.createBuffer((Buffer)size, CLMemory.Mem.flagsToInt(flags));
    }

    public final CLBuffer<?> createBuffer(int size, int flags) {
        CLBuffer<int> buffer = CLBuffer.create(this, size, flags);
        this.memoryObjects.add(buffer);
        return buffer;
    }

    public final <B extends Buffer> CLBuffer<B> createBuffer(B directBuffer, CLMemory.Mem ... flags) {
        return this.createBuffer(directBuffer, CLMemory.Mem.flagsToInt(flags));
    }

    public final <B extends Buffer> CLBuffer<B> createBuffer(B directBuffer, int flags) {
        CLBuffer<B> buffer = CLBuffer.create(this, directBuffer, flags);
        this.memoryObjects.add(buffer);
        return buffer;
    }

    public final CLImage2d<?> createImage2d(int width, int height, CLImageFormat format, CLMemory.Mem ... flags) {
        return this.createImage2d(null, width, height, 0, format, flags);
    }

    public final CLImage2d<?> createImage2d(int width, int height, int rowPitch, CLImageFormat format, CLMemory.Mem ... flags) {
        return this.createImage2d(null, width, height, rowPitch, format, flags);
    }

    public final <B extends Buffer> CLImage2d<B> createImage2d(B directBuffer, int width, int height, CLImageFormat format, CLMemory.Mem ... flags) {
        return this.createImage2d(directBuffer, width, height, 0, format, flags);
    }

    public final <B extends Buffer> CLImage2d<B> createImage2d(B directBuffer, int width, int height, int rowPitch, CLImageFormat format, CLMemory.Mem ... flags) {
        CLImage2d<B> image = CLImage2d.createImage(this, directBuffer, width, height, rowPitch, format, CLMemory.Mem.flagsToInt(flags));
        this.memoryObjects.add(image);
        return image;
    }

    public final CLImage3d<?> createImage3d(int width, int height, int depth, CLImageFormat format, CLMemory.Mem ... flags) {
        return this.createImage3d(null, width, height, depth, format, flags);
    }

    public final CLImage3d<?> createImage3d(int width, int height, int depth, int rowPitch, int slicePitch, CLImageFormat format, CLMemory.Mem ... flags) {
        return this.createImage3d(null, width, height, depth, rowPitch, slicePitch, format, flags);
    }

    public final <B extends Buffer> CLImage3d<B> createImage3d(B directBuffer, int width, int height, int depth, CLImageFormat format, CLMemory.Mem ... flags) {
        return this.createImage3d(directBuffer, width, height, depth, 0, 0, format, flags);
    }

    public final <B extends Buffer> CLImage3d<B> createImage3d(B directBuffer, int width, int height, int depth, int rowPitch, int slicePitch, CLImageFormat format, CLMemory.Mem ... flags) {
        CLImage3d<B> image = CLImage3d.createImage(this, directBuffer, width, height, depth, rowPitch, slicePitch, format, CLMemory.Mem.flagsToInt(flags));
        this.memoryObjects.add(image);
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CLCommandQueue createCommandQueue(CLDevice device, long properties) {
        CLCommandQueue queue = CLCommandQueue.create(this, device, properties);
        Map<CLDevice, List<CLCommandQueue>> map = this.queuesMap;
        synchronized (map) {
            List<CLCommandQueue> list = this.queuesMap.get(device);
            if (list == null) {
                list = new ArrayList<CLCommandQueue>();
                this.queuesMap.put(device, list);
            }
            list.add(queue);
        }
        return queue;
    }

    public CLSampler createSampler(CLSampler.AddressingMode addrMode, CLSampler.FilteringMode filtMode, boolean normalizedCoords) {
        CLSampler sampler = CLSampler.create(this, addrMode, filtMode, normalizedCoords);
        this.samplers.add(sampler);
        return sampler;
    }

    void onProgramReleased(CLProgram program) {
        this.programs.remove(program);
    }

    void onMemoryReleased(CLMemory<?> buffer) {
        this.memoryObjects.remove(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onCommandQueueReleased(CLDevice device, CLCommandQueue queue) {
        Map<CLDevice, List<CLCommandQueue>> map = this.queuesMap;
        synchronized (map) {
            List<CLCommandQueue> list = this.queuesMap.get(device);
            list.remove(queue);
            if (list.isEmpty()) {
                this.queuesMap.remove(device);
            }
        }
    }

    void onSamplerReleased(CLSampler sampler) {
        this.samplers.remove(sampler);
    }

    public void addCLErrorHandler(CLErrorHandler handler) {
        this.errorHandler.addHandler(handler);
    }

    public void removeCLErrorHandler(CLErrorHandler handler) {
        this.errorHandler.removeHandler(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release(Collection<? extends CLResource> resources) {
        if (!resources.isEmpty()) {
            CLResource[] array = null;
            Collection<? extends CLResource> collection = resources;
            synchronized (collection) {
                array = resources.toArray(new CLResource[resources.size()]);
            }
            CLResource[] arr$ = array;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                CLResource resource;
                CLResource cLResource = resource = arr$[i$];
                synchronized (cLResource) {
                    if (!resource.isReleased()) {
                        resource.release();
                    }
                    continue;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void release() {
        super.release();
        try {
            this.release(this.programs);
            this.release(this.memoryObjects);
            this.release(this.samplers);
            for (List<CLCommandQueue> queues : new ArrayList<List<CLCommandQueue>>(this.queuesMap.values())) {
                this.release(queues);
            }
        }
        finally {
            int ret = this.platform.getContextBinding().clReleaseContext(this.ID);
            CLException.checkForError(ret, "error releasing context");
        }
    }

    protected void overrideContext(CLDevice device) {
        device.setContext(this);
    }

    private CLImageFormat[] getSupportedImageFormats(int flags, int type) {
        int[] entries;
        CLContextBinding binding = this.platform.getContextBinding();
        int ret = binding.clGetSupportedImageFormats(this.ID, flags, type, 0, null, entries = new int[1], 0);
        if (ret != 0) {
            throw CLException.newException(ret, "error calling clGetSupportedImageFormats");
        }
        int count = entries[0];
        if (count == 0) {
            return new CLImageFormat[0];
        }
        CLImageFormat[] formats = new CLImageFormat[count];
        CLImageFormatImpl impl = CLImageFormatImpl.create(Buffers.newDirectByteBuffer(count * CLImageFormatImpl.size()));
        ret = binding.clGetSupportedImageFormats(this.ID, flags, type, count, impl, null);
        if (ret != 0) {
            throw CLException.newException(ret, "error calling clGetSupportedImageFormats");
        }
        ByteBuffer buffer = impl.getBuffer();
        for (int i = 0; i < formats.length; ++i) {
            formats[i] = new CLImageFormat(CLImageFormatImpl.create(buffer.slice()));
            buffer.position(i * CLImageFormatImpl.size());
        }
        return formats;
    }

    public CLImageFormat[] getSupportedImage2dFormats(CLMemory.Mem ... flags) {
        return this.getSupportedImageFormats(flags == null ? 0 : CLMemory.Mem.flagsToInt(flags), 4337);
    }

    public CLImageFormat[] getSupportedImage3dFormats(CLMemory.Mem ... flags) {
        return this.getSupportedImageFormats(flags == null ? 0 : CLMemory.Mem.flagsToInt(flags), 4338);
    }

    @Override
    public CLPlatform getPlatform() {
        return this.platform;
    }

    @Override
    public CLContext getContext() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CLProgram> getPrograms() {
        Set<CLProgram> set = this.programs;
        synchronized (set) {
            return Collections.unmodifiableList(new ArrayList<CLProgram>(this.programs));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CLMemory<? extends Buffer>> getMemoryObjects() {
        Set<CLMemory<? extends Buffer>> set = this.memoryObjects;
        synchronized (set) {
            return Collections.unmodifiableList(new ArrayList<CLMemory<? extends Buffer>>(this.memoryObjects));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CLSampler> getSamplers() {
        Set<CLSampler> set = this.samplers;
        synchronized (set) {
            return Collections.unmodifiableList(new ArrayList<CLSampler>(this.samplers));
        }
    }

    public CLDevice getMaxFlopsDevice() {
        return CLPlatform.findMaxFlopsDevice(this.getDevices());
    }

    public CLDevice getMaxFlopsDevice(CLDevice.Type type) {
        return CLPlatform.findMaxFlopsDevice(this.getDevices(), type);
    }

    public CLDevice[] getDevices() {
        this.initDevices(this.platform.getContextBinding());
        return this.devices;
    }

    public CL getCL() {
        return this.getPlatform().getCLBinding();
    }

    CLDevice getDevice(long dID) {
        CLDevice[] deviceArray = this.getDevices();
        for (int i = 0; i < deviceArray.length; ++i) {
            if (dID != deviceArray[i].ID) continue;
            return deviceArray[i];
        }
        return null;
    }

    protected static long toDeviceBitmap(CLDevice.Type[] deviceTypes) {
        long bitmap = 0L;
        if (deviceTypes != null) {
            for (int i = 0; i < deviceTypes.length; ++i) {
                CLDevice.Type type = deviceTypes[i];
                if (type == null) {
                    throw new IllegalArgumentException("Device type at index " + i + " was null.");
                }
                bitmap |= type.TYPE;
            }
        }
        return bitmap;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " [id: " + this.ID + ", platform: " + this.getPlatform().getName() + ", profile: " + this.getPlatform().getProfile() + ", devices: " + this.getDevices().length + "]";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CLContext other = (CLContext)obj;
        return this.ID == other.ID;
    }

    public int hashCode() {
        int hash = 7;
        hash = 23 * hash + (int)(this.ID ^ this.ID >>> 32);
        return hash;
    }

    protected static ErrorDispatcher createErrorHandler() {
        return new ErrorDispatcher();
    }

    protected static class ErrorDispatcher
    implements CLErrorHandler {
        private CLErrorHandler[] clientHandlers = new CLErrorHandler[0];

        protected ErrorDispatcher() {
        }

        public synchronized void onError(String errinfo, ByteBuffer private_info, long cb) {
            CLErrorHandler[] handlers = this.clientHandlers;
            for (int i = 0; i < handlers.length; ++i) {
                handlers[i].onError(errinfo, private_info, cb);
            }
        }

        private synchronized void addHandler(CLErrorHandler handler) {
            if (handler == null) {
                throw new IllegalArgumentException("handler was null.");
            }
            CLErrorHandler[] handlers = new CLErrorHandler[this.clientHandlers.length + 1];
            System.arraycopy(this.clientHandlers, 0, handlers, 0, this.clientHandlers.length);
            handlers[handlers.length - 1] = handler;
            this.clientHandlers = handlers;
        }

        private synchronized void removeHandler(CLErrorHandler handler) {
            if (handler == null) {
                throw new IllegalArgumentException("handler was null.");
            }
            for (int i = 0; i < this.clientHandlers.length; ++i) {
                if (!handler.equals(this.clientHandlers[i])) continue;
                CLErrorHandler[] handlers = new CLErrorHandler[this.clientHandlers.length - 1];
                System.arraycopy(this.clientHandlers, 0, handlers, 0, i);
                System.arraycopy(this.clientHandlers, i, handlers, 0, handlers.length - i);
                this.clientHandlers = handlers;
                return;
            }
        }
    }
}

