/*
 * Decompiled with CFR 0.152.
 */
package pn.util.translator;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import pn.logic.IPNLPlace;
import pn.logic.IPNLTransition;
import pn.tb.logic.PNLPetriNet;
import pn.util.translator.tree.Tree;
import pn.util.translator.tree.TreeConstant;
import pn.util.translator.tree.TreeFunctionDiv;
import pn.util.translator.tree.TreeFunctionMax;
import pn.util.translator.tree.TreeFunctionMinus;
import pn.util.translator.tree.TreeFunctionMod;
import pn.util.translator.tree.TreeFunctionMul;
import pn.util.translator.tree.TreeFunctionPlus;
import pn.util.translator.tree.TreePredicateAnd;
import pn.util.translator.tree.TreePredicateEQ;
import pn.util.translator.tree.TreePredicateGE;
import pn.util.translator.tree.TreePredicateGT;
import pn.util.translator.tree.TreePredicateLE;
import pn.util.translator.tree.TreePredicateLT;
import pn.util.translator.tree.TreePredicateNE;
import pn.util.translator.tree.TreePredicateOr;
import pn.util.translator.tree.TreePredicateXor;
import pn.util.translator.tree.TreeVariable;

public class Grammar {
    protected Tree tree;
    protected pn.logic.PNLPetriNet pn;
    protected final String REGEX_NUMERIC = "(((?<=[-+*/(])|(?<=^))-)?\\d+(\\.\\d+)?";
    protected final String REGEX_VARIABLE = "[a-zA-Z][a-zA-Z0-9]*";
    protected final String REGEX_OPERATION = "([-*/+|&^<>=]|(>=)|(<=)|(!=)|(==)|(max)|(,))";
    protected final String REGEX_PARANTHESIS = "[()]";

    public Grammar(pn.evpn.logic.PNLPetriNet pn) {
        this.pn = pn;
    }

    public Grammar(PNLPetriNet pn) {
        this.pn = pn;
    }

    public void parse(String input) {
        Pattern p = Pattern.compile(String.valueOf("(((?<=[-+*/(])|(?<=^))-)?\\d+(\\.\\d+)?") + "|" + "([-*/+|&^<>=]|(>=)|(<=)|(!=)|(==)|(max)|(,))" + "|" + "[a-zA-Z][a-zA-Z0-9]*" + "|" + "[()]");
        String s = input.replaceAll("\\s", "");
        Matcher m = p.matcher(s);
        ArrayList<String> parts = new ArrayList<String>();
        while (m.find()) {
            parts.add(m.group());
        }
        parts = this.bracketize(parts);
        this.tree = new Tree(null);
        try {
            this.tree = this.parse(parts, this.tree);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Syntax error in expression: " + input, "Syntax error!", 0);
            System.out.println("error onGrammar.parse: " + e.toString());
        }
    }

    protected ArrayList<String> bracketize(ArrayList<String> parts) {
        ArrayList<String> ret = new ArrayList<String>();
        int i = 0;
        while (i < parts.size()) {
            ret.add(parts.get(i));
            ++i;
        }
        int k = 0;
        while (k < 15) {
            int i2 = ret.size() - 1;
            while (i2 >= 0) {
                if (ret.get(i2).equals("+") && k == 0 || ret.get(i2).equals("-") && k == 1 || ret.get(i2).equals("*") && k == 2 || ret.get(i2).equals("/") && k == 3 || ret.get(i2).equals("%") && k == 4 || ret.get(i2).equals("&") && k == 5 || ret.get(i2).equals("|") && k == 6 || ret.get(i2).equals("^") && k == 7 || ret.get(i2).equals("<") && k == 8 || ret.get(i2).equals(">") && k == 9 || ret.get(i2).equals("==") && k == 10 || ret.get(i2).equals("<=") && k == 11 || ret.get(i2).equals(">=") && k == 12 || ret.get(i2).equals("!=") && k == 13) {
                    ret.add(i2, ")");
                    ret.add(i2 + 2, "(");
                    int z = 0;
                    int j = i2 + 3;
                    while (j < ret.size()) {
                        if (ret.get(j).equals("(")) {
                            ++z;
                        }
                        if (ret.get(j).equals(")")) {
                            --z;
                        }
                        if (z < 0) {
                            ret.add(j, ")");
                            break;
                        }
                        if (j == ret.size() - 1) {
                            ret.add(")");
                            break;
                        }
                        ++j;
                    }
                    z = 0;
                    j = i2 - 1;
                    while (j >= 0) {
                        if (ret.get(j).equals(")")) {
                            ++z;
                        }
                        if (ret.get(j).equals("(")) {
                            --z;
                        }
                        if (z < 0) {
                            ret.add(j, "(");
                            break;
                        }
                        if (j == 0) {
                            ret.add(j, "(");
                            break;
                        }
                        --j;
                    }
                }
                if (ret.get(i2).equals("max")) {
                    // empty if block
                }
                --i2;
            }
            ++k;
        }
        return ret;
    }

    /*
     * Unable to fully structure code
     */
    protected Tree parse(ArrayList<String> parts, Tree t) throws Exception {
        z = 0;
        i = 0;
        while (i < parts.size()) {
            block18: {
                block31: {
                    block30: {
                        block29: {
                            block28: {
                                block27: {
                                    block26: {
                                        block25: {
                                            block24: {
                                                block23: {
                                                    block22: {
                                                        block21: {
                                                            block20: {
                                                                block19: {
                                                                    if (parts.get(i).equals("(")) {
                                                                        ++z;
                                                                    }
                                                                    if (parts.get(i).equals(")")) {
                                                                        --z;
                                                                    }
                                                                    if (z == 0 && i == parts.size() - 1 && parts.size() > 1) {
                                                                        tmp = new ArrayList<String>();
                                                                        lTmp = parts.subList(1, parts.size() - 1);
                                                                        a = 0;
                                                                        while (a < lTmp.size()) {
                                                                            tmp.add(lTmp.get(a));
                                                                            ++a;
                                                                        }
                                                                        return this.parse(tmp, t);
                                                                    }
                                                                    if (z != 0) break block18;
                                                                    p1 = Pattern.compile("(((?<=[-+*/(])|(?<=^))-)?\\d+(\\.\\d+)?");
                                                                    p2 = Pattern.compile("[a-zA-Z][a-zA-Z0-9]*");
                                                                    p3 = Pattern.compile("([-*/+|&^<>=]|(>=)|(<=)|(!=)|(==)|(max)|(,))");
                                                                    m1 = p1.matcher(parts.get(i));
                                                                    m2 = p2.matcher(parts.get(i));
                                                                    m3 = p3.matcher(parts.get(i));
                                                                    if (!parts.get(i).equals("+")) break block19;
                                                                    t = new TreeFunctionPlus(t.getParent());
                                                                    ** GOTO lbl119
                                                                }
                                                                if (!parts.get(i).equals("-")) break block20;
                                                                t = new TreeFunctionMinus(t.getParent());
                                                                ** GOTO lbl119
                                                            }
                                                            if (!parts.get(i).equals("*")) break block21;
                                                            t = new TreeFunctionMul(t.getParent());
                                                            ** GOTO lbl119
                                                        }
                                                        if (!parts.get(i).equals("/")) break block22;
                                                        t = new TreeFunctionDiv(t.getParent());
                                                        ** GOTO lbl119
                                                    }
                                                    if (!parts.get(i).equals("%")) break block23;
                                                    t = new TreeFunctionMod(t.getParent());
                                                    ** GOTO lbl119
                                                }
                                                if (!parts.get(i).equals("&")) break block24;
                                                t = new TreePredicateAnd(t.getParent());
                                                ** GOTO lbl119
                                            }
                                            if (!parts.get(i).equals("|")) break block25;
                                            t = new TreePredicateOr(t.getParent());
                                            ** GOTO lbl119
                                        }
                                        if (!parts.get(i).equals("^")) break block26;
                                        t = new TreePredicateXor(t.getParent());
                                        ** GOTO lbl119
                                    }
                                    if (!parts.get(i).equals("<")) break block27;
                                    t = new TreePredicateLT(t.getParent());
                                    ** GOTO lbl119
                                }
                                if (!parts.get(i).equals(">")) break block28;
                                t = new TreePredicateGT(t.getParent());
                                ** GOTO lbl119
                            }
                            if (!parts.get(i).equals("==")) break block29;
                            t = new TreePredicateEQ(t.getParent());
                            ** GOTO lbl119
                        }
                        if (!parts.get(i).equals("<=")) break block30;
                        t = new TreePredicateLE(t.getParent());
                        ** GOTO lbl119
                    }
                    if (!parts.get(i).equals(">=")) break block31;
                    t = new TreePredicateGE(t.getParent());
                    ** GOTO lbl119
                }
                if (!parts.get(i).equals("!=")) {
                    if (m1.matches()) {
                        return new TreeConstant(t.getParent(), Double.valueOf(parts.get(i)));
                    }
                    if (m2.matches() && !m3.matches()) {
                        v = this.pn.getVertexById(parts.get(i));
                        if (v == null) {
                            throw new Exception("Syntax error: unknown variable");
                        }
                        if (v instanceof IPNLTransition) {
                            throw new Exception("Syntax error: variable is transition");
                        }
                        return new TreeVariable(t.getParent(), (IPNLPlace)v);
                    }
                    if (parts.get(i).equals("max")) {
                        t = new TreeFunctionMax(t.getParent());
                        lastpos = i + 1;
                        j = i + 1;
                        while (j < parts.size()) {
                            if (parts.get(j).equals(",")) {
                                t2 = new Tree(t);
                                tmp = new ArrayList<String>();
                                lTmp = parts.subList(lastpos + 1, j);
                                lastpos = j;
                                a = 0;
                                while (a < lTmp.size()) {
                                    tmp.add(lTmp.get(a));
                                    ++a;
                                }
                                t.addSon(this.parse(tmp, t2));
                            }
                            ++j;
                        }
                        t2 = new Tree(t);
                        tmp = new ArrayList<String>();
                        lTmp = parts.subList(lastpos + 1, parts.size() - 1);
                        a = 0;
                        while (a < lTmp.size()) {
                            tmp.add(lTmp.get(a));
                            ++a;
                        }
                        t.addSon(this.parse(tmp, t2));
                        return t;
                    }
                } else {
                    t = new TreePredicateNE(t.getParent());
lbl119:
                    // 14 sources

                    t2 = new Tree(t);
                    tmp = new ArrayList<String>();
                    lTmp = parts.subList(0, i);
                    a = 0;
                    while (a < lTmp.size()) {
                        tmp.add(lTmp.get(a));
                        ++a;
                    }
                    t.addSon(this.parse(tmp, t2));
                    t2 = new Tree(t);
                    tmp = new ArrayList<E>();
                    lTmp = parts.subList(i + 1, parts.size());
                    a = 0;
                    while (a < lTmp.size()) {
                        tmp.add(lTmp.get(a));
                        ++a;
                    }
                    t.addSon(this.parse(tmp, t2));
                    return t;
                }
            }
            ++i;
        }
        throw new Exception("Syntax error: function string contains illegal characters");
    }

    public double calculate() {
        return this.tree.getValue();
    }

    public ArrayList<double[]> calculateIntervals() {
        return this.tree.getIntervalValue();
    }
}

