/*
 * Decompiled with CFR 0.152.
 */
package pn.tb.logic;

import java.awt.Color;
import java.util.ArrayList;
import pn.gui.PNGUIPlace;
import pn.logic.IPNLPlace;
import pn.tb.logic.PNLVertex;
import pn.tb.logic.TBToken;

public class PNLPlace
extends PNLVertex
implements IPNLPlace {
    private ArrayList<TBToken> tokenList;
    private int tokenToFire = -1;

    public PNLPlace() {
        this.props.put("Color", new Color(0xFFFFFF));
        this.grVertex = new PNGUIPlace(this);
        this.tokenList = new ArrayList();
    }

    public PNLPlace(float x, float y) {
        super(x, y);
        this.props.put("Color", new Color(0xFFFFFF));
        this.grVertex = new PNGUIPlace(this);
        this.grVertex.setBounds(x, y, 30.0, 30.0);
        this.tokenList = new ArrayList();
    }

    public PNLPlace(float x, float y, int tokens) {
        super(x, y);
        this.props.put("Color", new Color(0xFFFFFF));
        this.grVertex = new PNGUIPlace(this);
        this.grVertex.setBounds(x, y, 30.0, 30.0);
        this.tokenList = new ArrayList();
    }

    public PNLPlace(String name) {
        super(name);
        this.props.put("Color", new Color(0xFFFFFF));
        this.grVertex = new PNGUIPlace(this);
        this.getGrVertex().setName(this.getName());
        this.tokenList = new ArrayList();
    }

    public int getTokenToFire() {
        return this.tokenToFire;
    }

    public void setTokenToFire(int index) {
        this.tokenToFire = index;
        if (index < 0) {
            this.tokenToFire = -1;
        }
        if (index >= this.tokenList.size()) {
            this.tokenToFire = -1;
        }
    }

    @Override
    public int getTokens() {
        return this.tokenList.size();
    }

    @Override
    public void setTokens(int t) {
        this.tokenList = new ArrayList();
        int i = 0;
        while (i < t) {
            this.tokenList.add(new TBToken(0, 0));
            ++i;
        }
        this.updateTokenInfo();
    }

    @Override
    public void decreaseTokens(int dt) {
        if (this.getTokens() >= dt) {
            int i = 0;
            while (i < dt) {
                this.tokenList.remove(this.tokenList.size() - 1);
                ++i;
            }
        }
        this.updateTokenInfo();
    }

    @Override
    public void increaseTokens(int dt) {
        int i = 0;
        while (i < dt) {
            this.tokenList.add(new TBToken(0, 0));
            ++i;
        }
        this.updateTokenInfo();
    }

    public void addToken(int minValue, int maxValue) {
        this.tokenList.add(new TBToken(minValue, maxValue));
        this.updateTokenInfo();
    }

    @Override
    public void addToken(int minValue) {
        this.tokenList.add(new TBToken(minValue, minValue));
        this.updateTokenInfo();
    }

    private void updateTokenInfo() {
        String text = String.valueOf(this.getId()) + "\n";
        int i = 0;
        while (i < this.tokenList.size()) {
            text = String.valueOf(text) + "[" + this.tokenList.get(i).getMinValue() + ", " + this.tokenList.get(i).getMaxValue() + "]\n";
            ++i;
        }
        this.getGrPlace().setAdvancedTexts(text);
    }

    public TBToken getToken(int index) {
        return this.tokenList.get(index);
    }

    public void removeToken(int index) {
        this.tokenList.remove(index);
        this.updateTokenInfo();
    }

    public void removeToken(TBToken token) {
        this.tokenList.remove(token);
        this.updateTokenInfo();
    }

    @Override
    public void setId(String id) {
        super.setId(id);
        this.updateTokenInfo();
    }

    @Override
    public PNGUIPlace getGrPlace() {
        return (PNGUIPlace)this.grVertex;
    }
}

