/*
 * Decompiled with CFR 0.152.
 */
package pn.simulation.tb;

import java.util.ArrayList;
import pn.logic.IPNLTransition;
import pn.tb.logic.PNLEdge;
import pn.tb.logic.PNLPlace;
import pn.tb.logic.PNLTransition;
import pn.tb.logic.TBToken;

public class SimTableLine
extends pn.simulation.SimTableLine {
    private boolean useMonotonous;
    private ArrayList<int[]> combinations;
    private ArrayList<int[]> results;
    private int combinationToFire;

    public SimTableLine(IPNLTransition t, PNLEdge[] inputEdgeList, PNLEdge[] outputEdgeList, boolean useMonotonous) {
        super(t, inputEdgeList, outputEdgeList);
        this.useMonotonous = useMonotonous;
        this.combinations = new ArrayList();
        this.combinationToFire = -1;
    }

    @Override
    public void fire() {
        int i;
        double[] outputValue = new double[]{-1.0, -1.0};
        int[] tokensToFire = new int[this.inputEdges.length];
        if (this.results != null && this.combinationToFire > -1) {
            this.combinationToFire = this.getRandomCombinationToFire();
            tokensToFire = this.combinations.get(this.combinationToFire);
            outputValue = new double[]{this.results.get(this.combinationToFire)[0], this.results.get(this.combinationToFire)[1]};
        } else {
            if (this.useMonotonous) {
                if (this.combinationToFire == -1) {
                    return;
                }
                tokensToFire = this.combinations.get(this.combinationToFire);
                i = 0;
                while (i < this.inputEdges.length) {
                    ((PNLPlace)this.inputEdges[i].getVertex1()).setTokenToFire(tokensToFire[i]);
                    ++i;
                }
            } else {
                i = 0;
                while (i < this.inputEdges.length) {
                    tokensToFire[i] = (int)Math.round(Math.random() * (double)(((PNLPlace)this.inputEdges[i].getVertex1()).getTokens() - 1));
                    ((PNLPlace)this.inputEdges[i].getVertex1()).setTokenToFire(tokensToFire[i]);
                    ++i;
                }
            }
            outputValue = ((PNLTransition)this.transition).getOutputValue();
        }
        i = 0;
        while (i < this.inputEdges.length) {
            ((PNLPlace)this.inputEdges[i].getVertex1()).setTokenToFire(-1);
            ((PNLPlace)this.inputEdges[i].getVertex1()).removeToken(tokensToFire[i]);
            ((PNLPlace)this.inputEdges[i].getVertex1()).getGrPlace().repaint();
            ++i;
        }
        i = 0;
        while (i < this.outputEdges.length) {
            ((PNLPlace)this.outputEdges[i].getVertex2()).addToken((int)Math.round(outputValue[0]), (int)Math.round(outputValue[1]));
            ++i;
        }
    }

    public boolean refresh(TBToken newestToken) {
        if (this.useMonotonous) {
            this.combinations.clear();
            this.combinationToFire = -1;
            this.setCanBeFired(false);
            int i = 0;
            while (i < this.getInputEdgesCount()) {
                if (((PNLPlace)this.getInputEdge(i).getVertex1()).getTokens() < 1) {
                    return false;
                }
                ++i;
            }
            int combs = 1;
            int[] counters = new int[this.inputEdges.length];
            int i2 = 0;
            while (i2 < this.inputEdges.length) {
                counters[i2] = ((PNLPlace)this.inputEdges[i2].getVertex1()).getTokens();
                if ((combs *= ((PNLPlace)this.inputEdges[i2].getVertex1()).getTokens()) == 0) {
                    return false;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < combs) {
                int[] t = new int[this.inputEdges.length];
                int k = 0;
                int d = i2;
                int j = this.inputEdges.length - 1;
                while (j >= 0) {
                    k = d % counters[j];
                    d /= counters[j];
                    t[j] = k;
                    ((PNLPlace)this.inputEdges[j].getVertex1()).setTokenToFire(k);
                    --j;
                }
                double[] out = ((PNLTransition)this.transition).getOutputValue();
                int j2 = 0;
                while (j2 < this.inputEdges.length) {
                    ((PNLPlace)this.inputEdges[j2].getVertex1()).setTokenToFire(-1);
                    ++j2;
                }
                if (newestToken == null || !(out[0] < (double)newestToken.getMinValue()) && (out[0] != (double)newestToken.getMinValue() || !(out[1] < (double)newestToken.getMaxValue()))) {
                    this.combinations.add(t);
                }
                ++i2;
            }
            if (this.combinations.size() > 0) {
                this.combinationToFire = (int)Math.round(Math.random() * (double)(this.combinations.size() - 1));
                this.setCanBeFired(true);
                return true;
            }
            return false;
        }
        int i = 0;
        while (i < this.getInputEdgesCount()) {
            if (((PNLPlace)this.getInputEdge(i).getVertex1()).getTokens() < 1) {
                this.setCanBeFired(false);
                return false;
            }
            this.setCanBeFired(true);
            ++i;
        }
        this.setCanBeFired(true);
        return true;
    }

    public int[] getHighestResult() {
        int[] out = new int[2];
        if (this.combinationToFire == -1) {
            return null;
        }
        int i = 0;
        while (i < this.combinations.size()) {
            int j = 0;
            while (j < this.inputEdges.length) {
                ((PNLPlace)this.inputEdges[j].getVertex1()).setTokenToFire(this.combinations.get(i)[j]);
                ++j;
            }
            double[] val = ((PNLTransition)this.transition).getOutputValue();
            int j2 = 0;
            while (j2 < this.inputEdges.length) {
                ((PNLPlace)this.inputEdges[j2].getVertex1()).setTokenToFire(-1);
                ++j2;
            }
            if ((double)out[0] < val[0] || (double)out[0] == val[0] && (double)out[1] <= val[1]) {
                out[0] = (int)Math.round(val[0]);
                out[1] = (int)Math.round(val[1]);
            }
            ++i;
        }
        return out;
    }

    public boolean findFireableCombinations(int highest) {
        this.results = new ArrayList();
        boolean b = false;
        int[] counters = new int[this.inputEdges.length];
        int i = 0;
        while (i < this.inputEdges.length) {
            counters[i] = ((PNLPlace)this.inputEdges[i].getVertex1()).getTokens();
            ++i;
        }
        i = 0;
        while (i < this.combinations.size()) {
            int[] t = new int[this.inputEdges.length];
            int k = 0;
            int d = i;
            int j = this.inputEdges.length - 1;
            while (j >= 0) {
                k = d % counters[j];
                d /= counters[j];
                t[j] = k;
                ((PNLPlace)this.inputEdges[j].getVertex1()).setTokenToFire(k);
                --j;
            }
            double[] outt = ((PNLTransition)this.transition).getOutputValue();
            int j2 = 0;
            while (j2 < this.inputEdges.length) {
                ((PNLPlace)this.inputEdges[j2].getVertex1()).setTokenToFire(-1);
                ++j2;
            }
            if (outt[1] <= (double)highest) {
                this.results.add(new int[]{(int)outt[0], (int)outt[1]});
                b = true;
            } else if (outt[0] <= (double)highest) {
                this.results.add(new int[]{(int)outt[0], highest});
                b = true;
            } else {
                this.results.add(null);
            }
            ++i;
        }
        return b;
    }

    private int getRandomCombinationToFire() {
        int r;
        while (this.results.get(r = (int)Math.round(Math.random() * (double)(this.results.size() - 1))) == null) {
        }
        return r;
    }
}

