/*
 * Decompiled with CFR 0.152.
 */
package pn.simulation.tb;

import java.util.ArrayList;
import pn.logic.IPNLPlace;
import pn.simulation.tb.SimTableLine;
import pn.tb.logic.PNLEdge;
import pn.tb.logic.PNLPetriNet;
import pn.tb.logic.PNLPlace;
import pn.tb.logic.PNLVertex;
import pn.tb.logic.TBToken;

public class SimTable
extends pn.simulation.SimTable {
    private boolean useStrong;
    private boolean useMonotonous;
    private TBToken newestToken;

    public SimTable(PNLPetriNet net, boolean useMonotonous, boolean useStrong) {
        this.net = net;
        this.newestToken = null;
        this.useStrong = useStrong;
        this.useMonotonous = useMonotonous;
        this.fireableLines = 0;
        this.lines = new SimTableLine[net.getTransitions().size()];
        int i = 0;
        while (i < this.lines.length) {
            ArrayList<PNLEdge> ieList = new ArrayList<PNLEdge>();
            ArrayList<PNLEdge> oeList = new ArrayList<PNLEdge>();
            int j = 0;
            while (j < net.getEdges().size()) {
                if (net.getEdges().get(j).getVertex1().getId().equals(((PNLVertex)((Object)net.getTransitions().get(i))).getId())) {
                    oeList.add((PNLEdge)net.getEdges().get(j));
                }
                if (net.getEdges().get(j).getVertex2().getId().equals(((PNLVertex)((Object)net.getTransitions().get(i))).getId())) {
                    ieList.add((PNLEdge)net.getEdges().get(j));
                }
                ++j;
            }
            PNLEdge[] a = new PNLEdge[ieList.size()];
            int j2 = 0;
            while (j2 < ieList.size()) {
                a[j2] = (PNLEdge)ieList.get(j2);
                ++j2;
            }
            PNLEdge[] b = new PNLEdge[oeList.size()];
            int j3 = 0;
            while (j3 < oeList.size()) {
                b[j3] = (PNLEdge)oeList.get(j3);
                ++j3;
            }
            this.lines[i] = new SimTableLine(net.getTransitions().get(i), a, b, this.useMonotonous || this.useStrong);
            ++i;
        }
        this.sort();
    }

    @Override
    protected void sort() {
        this.newestToken = this.getNewestToken();
        this.fireableLines = 0;
        int i = 0;
        while (i < this.lines.length) {
            if (((SimTableLine)this.lines[i]).refresh(this.newestToken)) {
                ++this.fireableLines;
            }
            ++i;
        }
        this.countingSort();
        i = 0;
        while (i < this.lines.length) {
            boolean b = this.lines[i].getCanBeFiredBool();
            if (this.useStrong) {
                int m = this.getLowestTransitionMaxValue();
                b = m == -1 ? false : ((SimTableLine)this.lines[i]).findFireableCombinations(m);
            }
            ((SimTableLine)this.lines[i]).getTransition().setFireable(b);
            ++i;
        }
    }

    @Override
    public String fire(int index) {
        if (this.newestToken == null) {
            return null;
        }
        if (this.fireableLines > 0 && this.lines[index].getCanBeFiredBool()) {
            this.lines[index].fire();
            this.highLightFired(index);
            this.sort();
            return this.lines[index].getTransition().getId();
        }
        return null;
    }

    @Override
    public boolean fire() {
        if (this.newestToken == null) {
            return false;
        }
        if (this.fireableLines > 0) {
            int r = this.lines.length - 1 - (int)Math.round(Math.random() * (double)(this.fireableLines - 1));
            this.lines[r].fire();
            this.highLightFired(r);
            this.sort();
            return true;
        }
        return false;
    }

    public TBToken getNewestToken() {
        TBToken token = null;
        ArrayList<IPNLPlace> places = this.net.getPlaces();
        boolean firstAdded = false;
        int i = 0;
        while (i < places.size()) {
            try {
                int j = 0;
                while (j < places.get(i).getTokens()) {
                    if (!firstAdded) {
                        token = ((PNLPlace)places.get(i)).getToken(j);
                        if (token != null) {
                            firstAdded = true;
                        }
                    } else {
                        TBToken token2 = ((PNLPlace)places.get(i)).getToken(j);
                        if (token2.getMinValue() >= token.getMinValue() && (token2.getMinValue() != token.getMinValue() || token2.getMaxValue() >= token.getMaxValue())) {
                            token = token2;
                        }
                    }
                    ++j;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        return token;
    }

    private int getLowestTransitionMaxValue() {
        int[] interval = new int[]{};
        int[] interval2 = new int[]{};
        boolean wasAssigned = false;
        int i = 0;
        while (i < this.lines.length) {
            if (this.lines[i].getCanBeFired() != 0) {
                if (!wasAssigned) {
                    interval = ((SimTableLine)this.lines[i]).getHighestResult();
                    wasAssigned = true;
                } else {
                    interval2 = ((SimTableLine)this.lines[i]).getHighestResult();
                    if (interval2[1] < interval[1] || interval2[1] == interval[1] && interval2[0] < interval[0]) {
                        System.out.println(String.valueOf(interval[1]) + " " + interval2[0]);
                        interval = interval2;
                    }
                }
            }
            ++i;
        }
        if (!wasAssigned) {
            return -1;
        }
        return interval[1];
    }

    private int getLineToFire() {
        int index = -1;
        int[] interval = new int[2];
        boolean wasAssigned = false;
        int i = 0;
        while (i < this.lines.length) {
            if (this.lines[i].getCanBeFired() != 0) {
                if (!wasAssigned) {
                    interval = ((SimTableLine)this.lines[i]).getHighestResult();
                    index = i;
                    wasAssigned = true;
                } else {
                    int[] interval2 = ((SimTableLine)this.lines[i]).getHighestResult();
                    if (interval[0] >= interval2[0] && (interval[0] != interval2[0] || interval[1] > interval2[1])) {
                        interval[0] = interval2[0];
                        interval[1] = interval2[1];
                        index = i;
                    }
                }
            }
            ++i;
        }
        return index;
    }
}

