/*
 * Decompiled with CFR 0.152.
 */
package pn.simulation.evpn;

import java.util.ArrayList;
import javax.swing.JOptionPane;
import pn.evpn.logic.PNLEdge;
import pn.evpn.logic.PNLPetriNet;
import pn.evpn.logic.PNLPlace;
import pn.evpn.logic.PNLVertex;
import pn.simulation.evpn.SimTableLine;

public class SimTable
extends pn.simulation.SimTable {
    public SimTable(PNLPetriNet net) {
        super(net);
        this.fireableLines = 0;
        this.lines = new SimTableLine[net.getTransitions().size()];
        int i = 0;
        while (i < this.lines.length) {
            ArrayList<PNLEdge> ieList = new ArrayList<PNLEdge>();
            ArrayList<PNLEdge> oeList = new ArrayList<PNLEdge>();
            int j = 0;
            while (j < net.getEdges().size()) {
                if (net.getEdges().get(j).getVertex1().getId().equals(((PNLVertex)((Object)net.getTransitions().get(i))).getId())) {
                    oeList.add((PNLEdge)net.getEdges().get(j));
                }
                if (net.getEdges().get(j).getVertex2().getId().equals(((PNLVertex)((Object)net.getTransitions().get(i))).getId())) {
                    ieList.add((PNLEdge)net.getEdges().get(j));
                }
                ++j;
            }
            PNLEdge[] a = new PNLEdge[ieList.size()];
            int j2 = 0;
            while (j2 < ieList.size()) {
                a[j2] = (PNLEdge)ieList.get(j2);
                ++j2;
            }
            PNLEdge[] b = new PNLEdge[oeList.size()];
            int j3 = 0;
            while (j3 < oeList.size()) {
                b[j3] = (PNLEdge)oeList.get(j3);
                ++j3;
            }
            this.lines[i] = new SimTableLine(net.getTransitions().get(i), a, b);
            ++i;
        }
        this.sort();
    }

    @Override
    public String fire(int index) {
        if (this.fireableLines > 0 && this.lines[index].getCanBeFiredBool()) {
            this.lines[index].fire();
            this.highLightFired(index);
            this.checkConsistency();
            this.sort();
            return this.lines[index].getTransition().getId();
        }
        return null;
    }

    @Override
    public boolean fire() {
        if (this.fireableLines > 0) {
            int r = this.lines.length - 1 - (int)Math.round(Math.random() * (double)(this.fireableLines - 1));
            this.lines[r].fire();
            this.highLightFired(r);
            this.checkConsistency();
            this.sort();
            return true;
        }
        return false;
    }

    private void checkConsistency() {
        int i = 0;
        while (i < this.net.getPlaces().size()) {
            if ((((PNLPlace)this.net.getPlaces().get(i)).getType() == 1 || ((PNLPlace)this.net.getPlaces().get(i)).getType() == 2) && ((PNLPlace)this.net.getPlaces().get(i)).getTokens() != ((PNLPlace)this.net.getPlaces().get(i)).getTokensByFunction()) {
                JOptionPane.showMessageDialog(null, "Place " + this.net.getPlaces().get(i).getName() + "(" + this.net.getPlaces().get(i).getId() + ") contains wrong number of tokens!", "Warning!", 0);
            }
            ++i;
        }
    }
}

