/*
 * Decompiled with CFR 0.152.
 */
package pn.simulation;

import pn.logic.IPNLTransition;
import pn.logic.PNLPetriNet;
import pn.simulation.SimTable;
import pn.simulation.Simulation;
import pn.simulation.SimulationRecorder;

public class Simulator {
    protected final PNLPetriNet petriNet;
    protected SimTable table;
    protected Simulation simulation;
    boolean simulationIsRecorded;
    SimulationRecorder simulationRecorder;

    public Simulator(PNLPetriNet net) {
        this.petriNet = net;
        int i = 0;
        while (i < this.petriNet.getPlaces().size()) {
            this.petriNet.getPlaces().get(i).getGrPlace().showTexts();
            ++i;
        }
        i = 0;
        while (i < this.petriNet.getTransitions().size()) {
            this.petriNet.getTransitions().get(i).getGrTransition().showTexts();
            ++i;
        }
        i = 0;
        while (i < this.petriNet.getEdges().size()) {
            this.petriNet.getEdge(i).getGrEdge().showTexts();
            ++i;
        }
        this.reset();
    }

    public void forward(int step) {
        int i = 0;
        while (i < step) {
            if (!this.table.fire()) break;
            ++i;
        }
    }

    public void fire(IPNLTransition t) {
        String tID = this.table.fire(t);
        if (this.simulationIsRecorded && this.simulationRecorder != null) {
            this.simulationRecorder.addFiredTransition(tID);
        }
    }

    public void reset() {
        this.table = new SimTable(this.petriNet);
    }

    public void setSimulationIsRecorded(boolean rec) {
        this.simulationIsRecorded = rec;
    }

    public void setSimulationRecorder(SimulationRecorder simRec) {
        this.simulationRecorder = simRec;
    }
}

