/*
 * Decompiled with CFR 0.152.
 */
package pn.simulation;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JFileChooser;
import pn.dialogs.AddTransitionToSimulation;
import pn.simulation.PNSLFilter;
import pn.simulation.Simulation;

public class SimulationRecorder {
    private Simulation simulation = new Simulation();

    public void addFiredTransition(String tID) {
        if (tID != null) {
            AddTransitionToSimulation addingWindow = new AddTransitionToSimulation(null, true, tID);
            String comment = addingWindow.getComment();
            this.simulation.addFiring(tID, comment);
        }
    }

    public void setSimulationMetadata(String[] metadata) {
        this.simulation.id = metadata[0];
        this.simulation.name = metadata[1];
        this.simulation.comment = metadata[2];
    }

    public void save() throws IOException {
        JFileChooser fc = new JFileChooser();
        fc.setFileFilter(new PNSLFilter());
        fc.setCurrentDirectory(new File("./"));
        int a = fc.showSaveDialog(null);
        if (a == 0) {
            String filePath = fc.getSelectedFile().getAbsolutePath();
            int i = filePath.lastIndexOf(46);
            if (i > -1 && i < filePath.length()) {
                if (!filePath.substring(i + 1).equals("pnsl")) {
                    filePath = String.valueOf(filePath) + ".pnsl";
                }
            } else {
                filePath = String.valueOf(filePath) + ".pnsl";
            }
            DataOutputStream dos = new DataOutputStream(new FileOutputStream(filePath));
            String s = this.generateHeader();
            s = String.valueOf(s) + this.generateFiringSequence();
            s = String.valueOf(s) + this.generateFooter();
            dos.writeBytes(s);
            dos.close();
        }
    }

    private String generateHeader() {
        String name = this.simulation.name != null ? this.simulation.name : "";
        String comment = this.simulation.comment != null ? this.simulation.comment : "";
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n  <pnsl>\n    <simulation id=\"" + this.simulation.id + "\">\n" + "        <header>\n" + "            <name>\n" + "                <text>" + name + "</text>\n" + "            </name>\n" + "            <comment>\n" + "                <text>" + comment + "</text>\n" + "            </comment>\n" + "        </header>\n";
    }

    private String generateFiringSequence() {
        String seq = "        <firingSequence>\n";
        int i = 0;
        while (i < this.simulation.firingSequence.size()) {
            String ID2 = this.simulation.firingSequence.get((int)i).transition != null ? this.simulation.firingSequence.get((int)i).transition : "";
            String comment = this.simulation.firingSequence.get((int)i).comment != null ? this.simulation.firingSequence.get((int)i).comment : "";
            seq = String.valueOf(seq) + "            <firing>\n                <transition id=\"" + ID2 + "\"/>\n" + "                <comment>" + comment + "</comment>\n" + "            </firing>\n";
            ++i;
        }
        seq = String.valueOf(seq) + "        </firingSequence>\n";
        return seq;
    }

    private String generateFooter() {
        return "    </simulation>\n</pnsl>";
    }
}

