/*
 * Decompiled with CFR 0.152.
 */
package pn.simulation;

import java.io.File;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import pn.dialogs.SimulationDialog;
import pn.logic.PNLTransition;
import pn.simulation.SimPanel;
import pn.simulation.Simulation;

public class SimulationReader {
    File file;
    Simulation simulation;
    SimulationDialog simDialog;
    private final SimPanel simPanel;
    short indexOfNextTransition;

    SimulationReader(SimPanel simPanel) {
        this.simPanel = simPanel;
    }

    public void read(String filePath) throws Exception {
        this.file = new File(filePath);
        if (this.file == null) {
            throw new Exception("File not found!");
        }
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(this.file);
            doc.getDocumentElement().normalize();
            Element main = (Element)doc.getElementsByTagName("simulation").item(0);
            Element header = (Element)main.getElementsByTagName("header").item(0);
            this.simulation = new Simulation();
            this.simulation.id = main.getAttribute("id");
            this.simulation.name = ((Element)header.getElementsByTagName("name").item(0)).getElementsByTagName("text").item(0).getTextContent();
            this.simulation.comment = ((Element)header.getElementsByTagName("comment").item(0)).getElementsByTagName("text").item(0).getTextContent();
            Element sequence = (Element)main.getElementsByTagName("firingSequence").item(0);
            int i = 0;
            while (i < sequence.getElementsByTagName("firing").getLength()) {
                this.simulation.addFiring(((Element)((Element)sequence.getElementsByTagName("firing").item(i)).getElementsByTagName("transition").item(0)).getAttribute("id"), ((Element)sequence.getElementsByTagName("firing").item(i)).getElementsByTagName("comment").item(0).getTextContent());
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("error onCreatePNSLReader: " + e.toString());
        }
    }

    public void simulate() {
        this.indexOfNextTransition = 0;
        this.simDialog = new SimulationDialog(null, true, this, this.simulation);
        this.simDialog.setVisible(true);
    }

    public void executeNextStep() {
        if (this.indexOfNextTransition < this.simulation.firingSequence.size()) {
            short s = this.indexOfNextTransition;
            this.indexOfNextTransition = (short)(s + 1);
            PNLTransition t = this.simPanel.getTransitionByID(this.simulation.firingSequence.get((int)s).transition);
            if (t != null) {
                this.simPanel.getSimulator().fire(t);
                this.simPanel.refreshNet();
            } else {
                JOptionPane.showMessageDialog(null, "Could not find transition with ID " + this.simulation.firingSequence.get((int)(this.indexOfNextTransition - 1)).transition + ".", "Simulation error", 0);
            }
        }
    }

    public void reset() {
        this.simPanel.reset();
        this.indexOfNextTransition = 0;
    }

    public short getIndexOfNextTransition() {
        return this.indexOfNextTransition;
    }
}

