/*
 * Decompiled with CFR 0.152.
 */
package pn.simulation;

import pn.logic.IPNLPlace;
import pn.logic.IPNLTransition;
import pn.logic.PNLEdge;

public class SimTableLine {
    protected IPNLTransition transition;
    protected PNLEdge[] inputEdges;
    protected PNLEdge[] outputEdges;
    protected int canBeFired;

    public SimTableLine() {
    }

    public SimTableLine(IPNLTransition t, PNLEdge[] inputEdgeList, PNLEdge[] outputEdgeList) {
        this.transition = t;
        this.inputEdges = inputEdgeList;
        this.outputEdges = outputEdgeList;
        this.canBeFired = 0;
    }

    public void fire() {
        int i = 0;
        while (i < this.inputEdges.length) {
            ((IPNLPlace)this.inputEdges[i].getVertex1()).decreaseTokens(this.inputEdges[i].getCount());
            ((IPNLPlace)this.inputEdges[i].getVertex1()).getGrPlace().repaint();
            ++i;
        }
        i = 0;
        while (i < this.outputEdges.length) {
            ((IPNLPlace)this.outputEdges[i].getVertex2()).increaseTokens(this.outputEdges[i].getCount());
            ++i;
        }
    }

    public boolean refresh() {
        int i = 0;
        while (i < this.getInputEdgesCount()) {
            if (this.getInputEdge(i).getCount() > ((IPNLPlace)this.getInputEdge(i).getVertex1()).getTokens()) {
                this.setCanBeFired(false);
                return false;
            }
            this.setCanBeFired(true);
            ++i;
        }
        this.setCanBeFired(true);
        return true;
    }

    public IPNLTransition getTransition() {
        return this.transition;
    }

    public PNLEdge getInputEdge(int index) {
        return this.inputEdges[index];
    }

    public int getInputEdgesCount() {
        return this.inputEdges.length;
    }

    public PNLEdge getOutputEdge(int index) {
        return this.outputEdges[index];
    }

    public int getOutputEdgesCount() {
        return this.outputEdges.length;
    }

    protected void setCanBeFired(boolean b) {
        this.canBeFired = b ? 1 : 0;
    }

    public int getCanBeFired() {
        return this.canBeFired;
    }

    public boolean getCanBeFiredBool() {
        return this.canBeFired != 0;
    }
}

