/*
 * Decompiled with CFR 0.152.
 */
package pn.simulation;

import java.util.ArrayList;
import pn.logic.IPNLTransition;
import pn.logic.PNLEdge;
import pn.logic.PNLPetriNet;
import pn.logic.PNLVertex;
import pn.simulation.SimTableLine;

public class SimTable {
    protected SimTableLine[] lines;
    protected int fireableLines;
    protected PNLPetriNet net;

    public SimTable() {
    }

    public SimTable(PNLPetriNet net) {
        this.net = net;
        this.fireableLines = 0;
        this.lines = new SimTableLine[net.getTransitions().size()];
        int i = 0;
        while (i < this.lines.length) {
            ArrayList<PNLEdge> ieList = new ArrayList<PNLEdge>();
            ArrayList<PNLEdge> oeList = new ArrayList<PNLEdge>();
            int j = 0;
            while (j < net.getEdges().size()) {
                if (net.getEdges().get(j).getVertex1().getId().equals(((PNLVertex)((Object)net.getTransitions().get(i))).getId())) {
                    oeList.add(net.getEdges().get(j));
                }
                if (net.getEdges().get(j).getVertex2().getId().equals(((PNLVertex)((Object)net.getTransitions().get(i))).getId())) {
                    ieList.add(net.getEdges().get(j));
                }
                ++j;
            }
            PNLEdge[] a = new PNLEdge[ieList.size()];
            int j2 = 0;
            while (j2 < ieList.size()) {
                a[j2] = (PNLEdge)ieList.get(j2);
                ++j2;
            }
            PNLEdge[] b = new PNLEdge[oeList.size()];
            int j3 = 0;
            while (j3 < oeList.size()) {
                b[j3] = (PNLEdge)oeList.get(j3);
                ++j3;
            }
            this.lines[i] = new SimTableLine(net.getTransitions().get(i), a, b);
            ++i;
        }
        this.sort();
    }

    public SimTableLine getLine(int index) {
        return this.lines[index];
    }

    public int getLinesCount() {
        return this.lines.length;
    }

    protected void sort() {
        this.fireableLines = 0;
        int i = 0;
        while (i < this.lines.length) {
            if (this.lines[i].refresh()) {
                ++this.fireableLines;
            }
            ++i;
        }
        this.countingSort();
        i = 0;
        while (i < this.lines.length) {
            this.lines[i].getTransition().setFireable(this.lines[i].getCanBeFiredBool());
            ++i;
        }
    }

    protected void countingSort() {
        int[] a = new int[2];
        SimTableLine[] s = new SimTableLine[this.lines.length];
        int i = 0;
        while (i < this.lines.length) {
            int n = this.lines[i].getCanBeFired();
            a[n] = a[n] + 1;
            ++i;
        }
        a[1] = a[1] + a[0];
        i = this.lines.length - 1;
        while (i >= 0) {
            int n = this.lines[i].getCanBeFired();
            int n2 = a[n] - 1;
            a[n] = n2;
            s[n2] = this.lines[i];
            --i;
        }
        this.lines = s;
    }

    public String fire(int index) {
        if (this.fireableLines > 0 && this.lines[index].getCanBeFiredBool()) {
            this.lines[index].fire();
            this.highLightFired(index);
            String tID = this.lines[index].getTransition().getId();
            this.sort();
            return tID;
        }
        return null;
    }

    public String fire(IPNLTransition t) {
        int i = 0;
        while (i < this.lines.length) {
            if (this.lines[i].getTransition().getId().equals(t.getId())) {
                return this.fire(i);
            }
            ++i;
        }
        return null;
    }

    public boolean fire() {
        if (this.fireableLines > 0) {
            int r = this.lines.length - 1 - (int)Math.round(Math.random() * (double)(this.fireableLines - 1));
            this.lines[r].fire();
            this.highLightFired(r);
            this.sort();
            return true;
        }
        return false;
    }

    public void highLightFired(int index) {
        int i = 0;
        while (i < this.lines.length) {
            this.lines[i].getTransition().getGrTransition().setHighlighted(i == index);
            ++i;
        }
    }

    public int getFireableLinesCount() {
        return this.fireableLines;
    }
}

