/*
 * Decompiled with CFR 0.152.
 */
package pn.simulation;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import pn.Editor;
import pn.MainFrame;
import pn.dialogs.NameAndCommentSimulationDialog;
import pn.logic.PNLTransition;
import pn.simulation.PNSLFilter;
import pn.simulation.SimulationReader;
import pn.simulation.SimulationRecorder;
import pn.simulation.tb.Simulator;
import pn.tb.logic.PNLPetriNet;

public class SimPanel
extends JPanel {
    private pn.simulation.Simulator simulator;
    private pn.logic.PNLPetriNet petriNetRef;
    private MainFrame parent;
    private Editor editor;
    private SimulationRecorder simulationRecorder;
    private boolean netIsBackedUp;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton5;
    private JButton jButton_openSimulation;
    private JButton jButton_startRecording;
    private JButton jButton_stopRecording;
    private JComboBox jComboBox1;
    private JToggleButton jToggleButton1;

    public SimPanel() {
        this.initComponents();
        this.netIsBackedUp = false;
    }

    public void setMainFrame(MainFrame p) {
        this.parent = p;
    }

    private void initComponents() {
        this.jButton5 = new JButton();
        this.jToggleButton1 = new JToggleButton();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jButton3 = new JButton();
        this.jComboBox1 = new JComboBox();
        this.jButton_openSimulation = new JButton();
        this.jButton_startRecording = new JButton();
        this.jButton_stopRecording = new JButton();
        this.jButton5.setText("jButton5");
        this.setBorder(BorderFactory.createTitledBorder("Simulation"));
        this.setToolTipText("Simulation panel");
        this.setPreferredSize(new Dimension(460, 63));
        this.jToggleButton1.setText("On/Off");
        this.jToggleButton1.setToolTipText("Turn on/off the simulation");
        this.jToggleButton1.setEnabled(false);
        this.jToggleButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimPanel.this.jToggleButton1ActionPerformed(evt);
            }
        });
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/pn/simulation/icons/rst.png")));
        this.jButton1.setToolTipText("Restart");
        this.jButton1.setEnabled(false);
        this.jButton1.setMargin(new Insets(0, 0, 0, 0));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimPanel.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setIcon(new ImageIcon(this.getClass().getResource("/pn/simulation/icons/fwd.png")));
        this.jButton2.setToolTipText("Do one step in simulation");
        this.jButton2.setEnabled(false);
        this.jButton2.setMargin(new Insets(0, 0, 0, 0));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimPanel.this.jButton2ActionPerformed(evt);
            }
        });
        this.jButton3.setIcon(new ImageIcon(this.getClass().getResource("/pn/simulation/icons/ffwd.png")));
        this.jButton3.setToolTipText("Jump 5 steps forward in simulation");
        this.jButton3.setEnabled(false);
        this.jButton3.setMargin(new Insets(0, 0, 0, 0));
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimPanel.this.jButton3ActionPerformed(evt);
            }
        });
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"GPN", "EvPN"}));
        this.jComboBox1.setToolTipText("Net types");
        this.jComboBox1.setEnabled(false);
        this.jButton_openSimulation.setIcon(new ImageIcon(this.getClass().getResource("/pn/simulation/icons/open.png")));
        this.jButton_openSimulation.setToolTipText("Open simulation file");
        this.jButton_openSimulation.setEnabled(false);
        this.jButton_openSimulation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimPanel.this.jButton_openSimulationActionPerformed(evt);
            }
        });
        this.jButton_startRecording.setIcon(new ImageIcon(this.getClass().getResource("/pn/simulation/icons/control_pause_record.png")));
        this.jButton_startRecording.setToolTipText("Start recording of simulation");
        this.jButton_startRecording.setEnabled(false);
        this.jButton_startRecording.setMaximumSize(new Dimension(25, 25));
        this.jButton_startRecording.setMinimumSize(new Dimension(25, 25));
        this.jButton_startRecording.setPreferredSize(new Dimension(25, 25));
        this.jButton_startRecording.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimPanel.this.jButton_startRecordingActionPerformed(evt);
            }
        });
        this.jButton_stopRecording.setIcon(new ImageIcon(this.getClass().getResource("/pn/simulation/icons/control_stop_square.png")));
        this.jButton_stopRecording.setToolTipText("Stop recording of simulation");
        this.jButton_stopRecording.setEnabled(false);
        this.jButton_stopRecording.setMaximumSize(new Dimension(25, 25));
        this.jButton_stopRecording.setMinimumSize(new Dimension(25, 25));
        this.jButton_stopRecording.setPreferredSize(new Dimension(25, 25));
        this.jButton_stopRecording.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimPanel.this.jButton_stopRecordingActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jComboBox1, -2, 116, -2).addGap(18, 18, 18).addComponent(this.jToggleButton1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton3).addGap(18, 18, 18).addComponent(this.jButton_openSimulation).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton_startRecording, -2, 31, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton_stopRecording, -2, 27, -2).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBox1, -2, -1, -2).addComponent(this.jToggleButton1)).addComponent(this.jButton1).addComponent(this.jButton2).addComponent(this.jButton3).addComponent(this.jButton_openSimulation).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton_startRecording, -2, -1, -2).addComponent(this.jButton_stopRecording, -2, -1, -2))).addContainerGap()));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.reset();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.forward(1);
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        this.forward(5);
    }

    private void jToggleButton1ActionPerformed(ActionEvent evt) {
        if (this.jToggleButton1.isSelected()) {
            this.start();
            this.setToolbarEnabled(false);
            this.petriNetRef.getGrPetriNet().repaintAll();
        } else {
            this.stop();
            this.setToolbarEnabled(true);
        }
    }

    private void jButton_openSimulationActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        fc.setFileFilter(new PNSLFilter());
        fc.setCurrentDirectory(new File("./"));
        int a = fc.showOpenDialog(null);
        if (a == 0) {
            SimulationReader sr = new SimulationReader(this);
            String filePath = fc.getSelectedFile().getAbsolutePath();
            try {
                sr.read(filePath);
            }
            catch (Exception e) {
                System.out.println("error on Importing Simulation File: " + e.toString() + "; " + filePath);
            }
            this.startSimulationFromFile();
            sr.simulate();
        }
    }

    private void jButton_startRecordingActionPerformed(ActionEvent evt) {
        this.jButton_startRecording.setEnabled(false);
        this.jButton_stopRecording.setEnabled(true);
        this.jButton2.setEnabled(false);
        this.jButton3.setEnabled(false);
        this.jButton_openSimulation.setEnabled(false);
        this.simulator.setSimulationIsRecorded(true);
        this.simulationRecorder = new SimulationRecorder();
        this.simulator.setSimulationRecorder(this.simulationRecorder);
        new NameAndCommentSimulationDialog(null, true, this.simulationRecorder);
    }

    private void jButton_stopRecordingActionPerformed(ActionEvent evt) {
        this.simulator.setSimulationIsRecorded(false);
        try {
            this.simulationRecorder.save();
        }
        catch (IOException ex) {
            Logger.getLogger(SimPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.simulationRecorder = null;
        this.jButton_startRecording.setEnabled(true);
        this.jButton_stopRecording.setEnabled(false);
        this.jButton2.setEnabled(true);
        this.jButton3.setEnabled(true);
        this.jButton_openSimulation.setEnabled(true);
    }

    private void setToolbarEnabled(boolean b) {
        this.parent.setToolbarEnabled(b);
    }

    public void update() {
        if (this.isSimulating()) {
            return;
        }
        this.jToggleButton1.setEnabled(this.parent.getSelectedEditor() != null);
        this.jComboBox1.setEnabled(this.parent.getSelectedEditor() != null);
        this.jButton_openSimulation.setEnabled(this.parent.getSelectedEditor() != null);
        this.editor = this.parent.getSelectedEditor();
        if (this.editor != null) {
            if (this.editor.getPetriNet().getType().equals("EvPN")) {
                this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"GPN", "EvPN"}));
            } else if (this.editor.getPetriNet().getType().equals("TB")) {
                this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"GPN", "TB Weak", "TB Weak monoton.", "TB Strong"}));
            } else {
                this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"GPN"}));
            }
            if (this.editor != this.parent.getSelectedEditor()) {
                this.jButton1.setEnabled(false);
                this.jButton2.setEnabled(false);
                this.jButton3.setEnabled(false);
                this.jToggleButton1.setEnabled(false);
            } else {
                this.jToggleButton1.setEnabled(true);
            }
        }
    }

    public void setPetriNet(pn.logic.PNLPetriNet net) {
        this.petriNetRef = net;
    }

    public pn.simulation.Simulator getSimulator() {
        return this.simulator;
    }

    private void start() {
        this.editor = this.parent.getSelectedEditor();
        this.setBorder(BorderFactory.createTitledBorder(String.valueOf((String)this.jComboBox1.getSelectedItem()) + " Simulation " + this.editor.getPetriNet().getName()));
        this.petriNetRef = this.parent.getPetriNet();
        if (!this.netIsBackedUp) {
            this.netIsBackedUp = true;
            this.parent.backupPetriNet();
        }
        this.jComboBox1.setEnabled(false);
        this.jButton1.setEnabled(true);
        this.jButton2.setEnabled(true);
        this.jButton3.setEnabled(true);
        this.jButton_startRecording.setEnabled(true);
        this.jButton_stopRecording.setEnabled(false);
        if (this.jComboBox1.getSelectedIndex() == 0) {
            this.simulator = new pn.simulation.Simulator(this.petriNetRef);
        } else if (this.jComboBox1.getSelectedIndex() == 1) {
            this.simulator = this.petriNetRef instanceof pn.evpn.logic.PNLPetriNet ? new pn.simulation.evpn.Simulator((pn.evpn.logic.PNLPetriNet)this.petriNetRef) : new Simulator((PNLPetriNet)this.petriNetRef, false, false);
        } else if (this.jComboBox1.getSelectedIndex() == 2) {
            if (this.petriNetRef instanceof PNLPetriNet) {
                this.simulator = new Simulator((PNLPetriNet)this.petriNetRef, true, false);
            }
        } else if (this.petriNetRef instanceof PNLPetriNet) {
            this.simulator = new Simulator((PNLPetriNet)this.petriNetRef, true, true);
        }
        this.parent.startSimulation();
    }

    private void startSimulationFromFile() {
        this.editor = this.parent.getSelectedEditor();
        this.setBorder(BorderFactory.createTitledBorder(String.valueOf((String)this.jComboBox1.getSelectedItem()) + " Simulation " + this.editor.getPetriNet().getName()));
        this.petriNetRef = this.parent.getPetriNet();
        if (!this.netIsBackedUp) {
            this.netIsBackedUp = true;
            this.parent.backupPetriNet();
        }
        this.jComboBox1.setEnabled(false);
        this.jToggleButton1.setSelected(true);
        this.simulator = new pn.simulation.Simulator(this.petriNetRef);
        this.setToolbarEnabled(false);
        this.petriNetRef.getGrPetriNet().repaintAll();
    }

    private void stop() {
        this.setBorder(BorderFactory.createTitledBorder("Simulation"));
        this.jComboBox1.setEnabled(true);
        this.jButton1.setEnabled(false);
        this.jButton2.setEnabled(false);
        this.jButton3.setEnabled(false);
        this.jButton_startRecording.setEnabled(false);
        this.jButton_stopRecording.setEnabled(false);
        this.parent.stopSimulation();
        this.parent.reset();
        this.netIsBackedUp = false;
        this.editor = null;
    }

    public void forward(int step) {
        this.simulator.forward(step);
        this.petriNetRef.refresh();
    }

    public void reset() {
        this.parent.reset();
        this.netIsBackedUp = false;
        this.start();
    }

    public Editor getAssignedEditor() {
        return this.editor;
    }

    public boolean isSimulating() {
        return this.jToggleButton1.isSelected();
    }

    public PNLTransition getTransitionByID(String ID2) {
        if (this.petriNetRef.getVertexById(ID2) instanceof PNLTransition) {
            return (PNLTransition)this.petriNetRef.getVertexById(ID2);
        }
        return null;
    }

    public void refreshNet() {
        this.petriNetRef.refresh();
    }
}

