/*
 * Decompiled with CFR 0.152.
 */
package pn.project;

import java.awt.Image;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import pn.modules.IModule;
import pn.modules.IResponseListener;
import pn.modules.pn.IPetriNet;
import pn.project.OtherFile;
import pn.project.Project;

public class ProjectSaver
implements IResponseListener {
    private Project project;

    public ProjectSaver(Project p) {
        this.project = p;
    }

    public void save(String fname) {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(fname));
            oos.writeUnshared(this.project);
            oos.close();
        }
        catch (Exception e) {
            System.out.println("error onSaveProject: " + e.toString());
        }
    }

    public void saveTxt(IPetriNet ipn) {
        try {
            if (this.project.getProjFileName() == null) {
                JFileChooser fc = new JFileChooser();
                fc.setFileSelectionMode(1);
                fc.setCurrentDirectory(new File("./"));
                int a = fc.showSaveDialog(null);
                if (a != 0) {
                    return;
                }
                if (JOptionPane.showConfirmDialog(null, "This operation can overwrite some of existing files. Do you want to continue?\nIt is preferred to save a project into a new directory.", "Warning!", 0) == 1) {
                    this.project.getParent().getParentAdv().setEdited(false);
                    return;
                }
                this.project.setProjFileName(fc.getSelectedFile().getAbsolutePath());
            }
            String fname = String.valueOf(this.project.getProjFileName()) + "/" + this.project.getName() + ".pnproj";
            DataOutputStream dos = new DataOutputStream(new FileOutputStream(fname));
            String s = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
            s = String.valueOf(s) + "<pntoolconf>\n";
            s = String.valueOf(s) + "  <project name=\"" + this.project.getName() + "\" version=\"2\">\n";
            int i = 0;
            while (i < this.project.getPetriNetsCount()) {
                s = String.valueOf(s) + "    <net filename=\"" + this.project.getPetriNet(i).getName() + "(" + this.project.getPetriNet(i).getId() + ").pnml\" />\n";
                if (ipn == null) {
                    this.savePetriNet(this.project.getPetriNet(i), String.valueOf(this.project.getProjFileName()) + "/" + this.project.getPetriNet(i).getName() + "(" + this.project.getPetriNet(i).getId() + ").pnml");
                } else if (ipn.getId().equals(this.project.getPetriNet(i).getId())) {
                    this.savePetriNet(this.project.getPetriNet(i), String.valueOf(this.project.getProjFileName()) + "/" + this.project.getPetriNet(i).getName() + "(" + this.project.getPetriNet(i).getId() + ").pnml");
                }
                ++i;
            }
            i = 0;
            while (i < this.project.getOtherFilesCount()) {
                s = String.valueOf(s) + "    <file filename=\"" + this.project.getOtherFile(i).getName() + "\" />\n";
                this.saveFile(this.project.getOtherFile(i), String.valueOf(this.project.getProjFileName()) + "/" + this.project.getOtherFile(i).getName());
                ++i;
            }
            s = String.valueOf(s) + "  </project>\n";
            s = String.valueOf(s) + "</pntoolconf>";
            dos.writeBytes(s);
            dos.close();
        }
        catch (Exception e) {
            System.out.println("error onSaveProject: " + e.toString());
        }
    }

    @Override
    public Image convertToImage(IPetriNet ipn) {
        return null;
    }

    @Override
    public ArrayList<IPetriNet> requestPetriNets() {
        return null;
    }

    @Override
    public void respond(IPetriNet pn) {
    }

    private void savePetriNet(IPetriNet pn, String fname) {
        try {
            File dir = new File("./modules/");
            File[] fileArray = dir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                try {
                    URLClassLoader cl;
                    Class<?> cls;
                    Object o;
                    if (!file.isDirectory() && (o = (cls = (cl = new URLClassLoader(new URL[]{file.toURI().toURL()})).loadClass("pn.ModuleImpl")).newInstance()) instanceof IModule && ((IModule)o).getName().equals("PNML Saver")) {
                        ((IModule)o).addPetriNet(pn);
                        ((IModule)o).executeCommand("set fname " + fname);
                        ((IModule)o).open();
                        ((IModule)o).close();
                        return;
                    }
                }
                catch (Exception e) {
                    System.out.println("error onLoadModule (" + file.getAbsolutePath() + "): " + e.toString());
                }
                ++n2;
            }
            JOptionPane.showMessageDialog(null, "Cannot load PNML Saver module!", "Error!", 0);
        }
        catch (Exception e) {
            System.out.println("error onLoadModules: " + e.toString());
        }
    }

    private void saveFile(OtherFile f, String fname) {
        f.saveAs(fname);
    }
}

