/*
 * Decompiled with CFR 0.152.
 */
package pn.project;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.MenuElement;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import pn.MainFrame;
import pn.modules.pn.IPetriNet;
import pn.modules.pn.impl.PetriNetImpl;
import pn.project.OtherFile;
import pn.project.PNGFilter;
import pn.project.Project;
import pn.project.ProjectTreeRenderer;
import pn.util.NameGenerator;

public class ProjectPanel
extends JPanel {
    private ArrayList<Project> projects;
    private Project mainProject;
    private MainFrame parent;
    private ArrayList<Boolean> expanded;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem10;
    private JMenuItem jMenuItem11;
    private JMenuItem jMenuItem12;
    private JMenuItem jMenuItem13;
    private JMenuItem jMenuItem14;
    private JMenuItem jMenuItem2;
    private JMenuItem jMenuItem3;
    private JMenuItem jMenuItem4;
    private JMenuItem jMenuItem5;
    private JMenuItem jMenuItem6;
    private JMenuItem jMenuItem7;
    private JMenuItem jMenuItem8;
    private JMenuItem jMenuItem9;
    private JPopupMenu jPopupMenu1;
    private JPopupMenu jPopupMenu2;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JTree jTree1;

    public ProjectPanel() {
        this.initComponents();
        this.jTree1.setCellRenderer(new ProjectTreeRenderer());
        this.jTree1.addMouseListener(new MousePopupListener());
        this.parent = (MainFrame)this.getParent();
        this.projects = new ArrayList();
        this.expanded = new ArrayList();
        this.resetModel();
    }

    public void addProject(Project p) {
        this.projects.add(p);
        this.expanded.add(true);
        this.mainProject = p;
        ((ProjectTreeRenderer)this.jTree1.getCellRenderer()).setMainProject(this.mainProject);
        this.resetModel();
    }

    public void closeMainProject() {
        if (this.mainProject == null) {
            return;
        }
        this.parent.closeTabs(this.mainProject);
        this.projects.remove(this.mainProject);
        this.expanded.remove(this.mainProject);
        this.mainProject = null;
        System.gc();
        this.resetModel();
    }

    public void setParent(MainFrame parent) {
        this.parent = parent;
    }

    public MainFrame getParentAdv() {
        return this.parent;
    }

    public void resetModel() {
        DefaultMutableTreeNode treeRoot = new DefaultMutableTreeNode("root");
        int i = 0;
        while (i < this.projects.size()) {
            DefaultMutableTreeNode treeNode2;
            DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode(this.projects.get(i));
            int j = 0;
            while (j < this.projects.get(i).getPetriNetsCount()) {
                treeNode2 = new DefaultMutableTreeNode(this.projects.get(i).getPetriNet(j));
                treeNode.add(treeNode2);
                ++j;
            }
            j = 0;
            while (j < this.projects.get(i).getOtherFilesCount()) {
                treeNode2 = new DefaultMutableTreeNode(this.projects.get(i).getOtherFile(j));
                treeNode.add(treeNode2);
                ++j;
            }
            treeRoot.add(treeNode);
            ++i;
        }
        this.jTree1.setModel(new DefaultTreeModel(treeRoot));
        i = 0;
        while (i < this.expanded.size()) {
            if (this.expanded.get(i).booleanValue()) {
                this.jTree1.expandRow(i);
            }
            ++i;
        }
    }

    public Project getMainProject() {
        return this.mainProject;
    }

    private void initComponents() {
        this.jPopupMenu1 = new JPopupMenu();
        this.jMenuItem4 = new JMenuItem();
        this.jMenuItem5 = new JMenuItem();
        this.jMenuItem3 = new JMenuItem();
        this.jMenuItem13 = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.jMenuItem6 = new JMenuItem();
        this.jMenuItem7 = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.jMenuItem8 = new JMenuItem();
        this.jMenuItem9 = new JMenuItem();
        this.jSeparator3 = new JSeparator();
        this.jMenuItem10 = new JMenuItem();
        this.jMenuItem11 = new JMenuItem();
        this.jMenuItem12 = new JMenuItem();
        this.jPopupMenu2 = new JPopupMenu();
        this.jMenuItem1 = new JMenuItem();
        this.jMenuItem2 = new JMenuItem();
        this.jMenuItem14 = new JMenuItem();
        this.jScrollPane1 = new JScrollPane();
        this.jTree1 = new JTree();
        this.jMenuItem4.setText("New file");
        this.jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectPanel.this.jMenuItem4ActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItem4);
        this.jMenuItem5.setText("New GPN");
        this.jMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectPanel.this.jMenuItem5ActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItem5);
        this.jMenuItem3.setText("New EvPN");
        this.jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectPanel.this.jMenuItem3ActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItem3);
        this.jMenuItem13.setText("New TB");
        this.jMenuItem13.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectPanel.this.jMenuItem13ActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItem13);
        this.jPopupMenu1.add(this.jSeparator1);
        this.jMenuItem6.setText("Open file");
        this.jMenuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectPanel.this.jMenuItem6ActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItem6);
        this.jMenuItem7.setText("Open PetriNet");
        this.jMenuItem7.setEnabled(false);
        this.jMenuItem7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectPanel.this.jMenuItem7ActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItem7);
        this.jPopupMenu1.add(this.jSeparator2);
        this.jMenuItem9.setText("Save project");
        this.jMenuItem9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectPanel.this.jMenuItem9ActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItem9);
        this.jPopupMenu1.add(this.jSeparator3);
        this.jMenuItem10.setText("Close project");
        this.jMenuItem10.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectPanel.this.jMenuItem10ActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItem10);
        this.jMenuItem11.setText("Delete project");
        this.jMenuItem11.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectPanel.this.jMenuItem11ActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItem11);
        this.jMenuItem12.setText("Rename project");
        this.jMenuItem12.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectPanel.this.jMenuItem12ActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItem12);
        this.jMenuItem1.setText("Rename\n");
        this.jMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectPanel.this.jMenuItem1ActionPerformed(evt);
            }
        });
        this.jPopupMenu2.add(this.jMenuItem1);
        this.jMenuItem2.setText("Remove from project");
        this.jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectPanel.this.jMenuItem2ActionPerformed(evt);
            }
        });
        this.jPopupMenu2.add(this.jMenuItem2);
        this.jMenuItem14.setText("Save as PNG");
        this.jMenuItem14.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectPanel.this.jMenuItem14ActionPerformed(evt);
            }
        });
        this.jPopupMenu2.add(this.jMenuItem14);
        DefaultMutableTreeNode treeNode1 = new DefaultMutableTreeNode("root");
        this.jTree1.setModel(new DefaultTreeModel(treeNode1));
        this.jTree1.setRootVisible(false);
        this.jTree1.setScrollsOnExpand(false);
        this.jTree1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ProjectPanel.this.jTree1MouseClicked(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                ProjectPanel.this.jTree1MousePressed(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTree1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 201, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 406, Short.MAX_VALUE));
    }

    private void jMenuItem8ActionPerformed(ActionEvent evt) {
        if (((DefaultMutableTreeNode)this.jTree1.getSelectionPath().getPathComponent(1)).getUserObject() instanceof Project) {
            this.mainProject = (Project)((DefaultMutableTreeNode)this.jTree1.getSelectionPath().getPathComponent(1)).getUserObject();
            ((ProjectTreeRenderer)this.jTree1.getCellRenderer()).setMainProject(this.mainProject);
            this.resetModel();
        }
    }

    private void jMenuItem9ActionPerformed(ActionEvent evt) {
        this.parent.setEdited(false);
        ((Project)((DefaultMutableTreeNode)this.jTree1.getSelectionPath().getPathComponent(1)).getUserObject()).save();
    }

    private void jMenuItem10ActionPerformed(ActionEvent evt) {
        if (((DefaultMutableTreeNode)this.jTree1.getSelectionPath().getPathComponent(1)).getUserObject() instanceof Project) {
            this.parent.closeTabs((Project)((DefaultMutableTreeNode)this.jTree1.getSelectionPath().getPathComponent(1)).getUserObject());
            this.projects.remove((Project)((DefaultMutableTreeNode)this.jTree1.getSelectionPath().getPathComponent(1)).getUserObject());
            this.expanded.remove(((DefaultMutableTreeNode)this.jTree1.getModel().getRoot()).getIndex((DefaultMutableTreeNode)this.jTree1.getSelectionPath().getPathComponent(1)));
            if (((DefaultMutableTreeNode)this.jTree1.getSelectionPath().getPathComponent(1)).getUserObject().equals(this.mainProject)) {
                this.mainProject = null;
                System.gc();
            }
            this.resetModel();
            this.parent.notifyProjectClosed();
        }
    }

    private void jMenuItem11ActionPerformed(ActionEvent evt) {
        if (((DefaultMutableTreeNode)this.jTree1.getSelectionPath().getPathComponent(1)).getUserObject() instanceof Project && JOptionPane.showConfirmDialog(this, "Do you really want to delete project " + ((Project)((DefaultMutableTreeNode)this.jTree1.getSelectionPath().getPathComponent(1)).getUserObject()).toString() + "?", "Delete project", 0) == 0) {
            if (((Project)((DefaultMutableTreeNode)this.jTree1.getSelectionPath().getPathComponent(1)).getUserObject()).getProjFileName() != null) {
                File f = new File(((Project)((DefaultMutableTreeNode)this.jTree1.getSelectionPath().getPathComponent(1)).getUserObject()).getProjFileName());
                f.delete();
            }
            this.parent.closeTabs((Project)((DefaultMutableTreeNode)this.jTree1.getSelectionPath().getPathComponent(1)).getUserObject());
            this.projects.remove((Project)((DefaultMutableTreeNode)this.jTree1.getSelectionPath().getPathComponent(1)).getUserObject());
            this.expanded.remove(((DefaultMutableTreeNode)this.jTree1.getModel().getRoot()).getIndex((DefaultMutableTreeNode)this.jTree1.getSelectionPath().getPathComponent(1)));
            if (((DefaultMutableTreeNode)this.jTree1.getSelectionPath().getPathComponent(1)).getUserObject().equals(this.mainProject)) {
                this.mainProject = null;
                System.gc();
            }
            this.resetModel();
            this.parent.notifyProjectClosed();
        }
    }

    private void jMenuItem12ActionPerformed(ActionEvent evt) {
        String n = JOptionPane.showInputDialog(this, "Type new project name:", "Rename project", 3);
        if (n == null) {
            return;
        }
        if (n.length() == 0) {
            return;
        }
        ((Project)((DefaultMutableTreeNode)this.jTree1.getSelectionPath().getPathComponent(1)).getUserObject()).rename(n);
    }

    private void jMenuItem7ActionPerformed(ActionEvent evt) {
    }

    private void jMenuItem6ActionPerformed(ActionEvent evt) {
        if (!(((DefaultMutableTreeNode)this.jTree1.getSelectionPath().getPathComponent(1)).getUserObject() instanceof Project)) {
            return;
        }
        JFileChooser fc = new JFileChooser();
        fc.setCurrentDirectory(new File("./"));
        int a = fc.showOpenDialog(null);
        if (a == 0) {
            OtherFile of = new OtherFile(fc.getSelectedFile().getName(), fc.getSelectedFile().getAbsolutePath());
            ((Project)((DefaultMutableTreeNode)this.jTree1.getSelectionPath().getPathComponent(1)).getUserObject()).addFile(of);
            this.resetModel();
        }
    }

    private void jMenuItem1ActionPerformed(ActionEvent evt) {
        String n = JOptionPane.showInputDialog(this, "Name:", "Rename", 3);
        if (n == null) {
            return;
        }
        if (n.length() == 0) {
            return;
        }
        if (((DefaultMutableTreeNode)this.jTree1.getSelectionPath().getPathComponent(2)).getUserObject() instanceof PetriNetImpl) {
            ((Project)((DefaultMutableTreeNode)this.jTree1.getSelectionPath().getPathComponent(1)).getUserObject()).renamePetriNet((PetriNetImpl)((DefaultMutableTreeNode)this.jTree1.getSelectionPath().getPathComponent(2)).getUserObject(), n);
            ((PetriNetImpl)((DefaultMutableTreeNode)this.jTree1.getSelectionPath().getPathComponent(2)).getUserObject()).setName(n);
            this.parent.notifyPetriNetRenamed((PetriNetImpl)((DefaultMutableTreeNode)this.jTree1.getSelectionPath().getPathComponent(2)).getUserObject());
            ((Project)((DefaultMutableTreeNode)this.jTree1.getSelectionPath().getPathComponent(1)).getUserObject()).getProjectSaver().saveTxt((PetriNetImpl)((DefaultMutableTreeNode)this.jTree1.getSelectionPath().getPathComponent(2)).getUserObject());
            return;
        }
        if (((DefaultMutableTreeNode)this.jTree1.getSelectionPath().getPathComponent(2)).getUserObject() instanceof OtherFile) {
            ((OtherFile)((DefaultMutableTreeNode)this.jTree1.getSelectionPath().getPathComponent(2)).getUserObject()).setName(n);
        }
    }

    private void jMenuItem2ActionPerformed(ActionEvent evt) {
        if (((DefaultMutableTreeNode)this.jTree1.getSelectionPath().getPathComponent(2)).getUserObject() instanceof OtherFile && JOptionPane.showConfirmDialog(this, "Do you really want to remove file " + ((OtherFile)((DefaultMutableTreeNode)this.jTree1.getSelectionPath().getPathComponent(2)).getUserObject()).toString() + " from project?", "Remove from project", 0) == 0) {
            ((Project)((DefaultMutableTreeNode)this.jTree1.getSelectionPath().getPathComponent(1)).getUserObject()).removeFile((OtherFile)((DefaultMutableTreeNode)this.jTree1.getSelectionPath().getPathComponent(2)).getUserObject());
            System.gc();
        }
        if (((DefaultMutableTreeNode)this.jTree1.getSelectionPath().getPathComponent(2)).getUserObject() instanceof IPetriNet && JOptionPane.showConfirmDialog(this, "Do you really want to remove petri net " + ((IPetriNet)((DefaultMutableTreeNode)this.jTree1.getSelectionPath().getPathComponent(2)).getUserObject()).toString() + " from project?", "Remove from project", 0) == 0) {
            this.parent.notifyPetriNetRemoved((IPetriNet)((DefaultMutableTreeNode)this.jTree1.getSelectionPath().getPathComponent(2)).getUserObject());
            ((Project)((DefaultMutableTreeNode)this.jTree1.getSelectionPath().getPathComponent(1)).getUserObject()).removePetriNet((IPetriNet)((DefaultMutableTreeNode)this.jTree1.getSelectionPath().getPathComponent(2)).getUserObject());
            System.gc();
        }
        this.resetModel();
    }

    private void jMenuItem4ActionPerformed(ActionEvent evt) {
        if (((DefaultMutableTreeNode)this.jTree1.getSelectionPath().getPathComponent(1)).getUserObject() instanceof Project) {
            String n = JOptionPane.showInputDialog(this, "File name:", "New file", 3);
            if (n == null) {
                return;
            }
            if (n.length() == 0) {
                return;
            }
            ((Project)((DefaultMutableTreeNode)this.jTree1.getSelectionPath().getPathComponent(1)).getUserObject()).addFile(new OtherFile(n, null));
            this.resetModel();
        }
    }

    private void jTree1MouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            if (this.jTree1.getSelectionPath().getPathCount() < 3) {
                return;
            }
            if (((DefaultMutableTreeNode)this.jTree1.getSelectionPath().getPathComponent(2)).getUserObject() instanceof IPetriNet) {
                this.parent.addPetriNet((IPetriNet)((DefaultMutableTreeNode)this.jTree1.getSelectionPath().getPathComponent(2)).getUserObject(), (Project)((DefaultMutableTreeNode)this.jTree1.getSelectionPath().getPathComponent(1)).getUserObject());
            }
        }
    }

    private void jTree1TreeWillExpand(TreeExpansionEvent evt) throws ExpandVetoException {
        this.expanded.set(((DefaultMutableTreeNode)this.jTree1.getModel().getRoot()).getIndex((DefaultMutableTreeNode)evt.getPath().getPathComponent(1)), true);
    }

    private void jTree1TreeWillCollapse(TreeExpansionEvent evt) throws ExpandVetoException {
        this.expanded.set(((DefaultMutableTreeNode)this.jTree1.getModel().getRoot()).getIndex((DefaultMutableTreeNode)evt.getPath().getPathComponent(1)), false);
    }

    private void jMenuItem5ActionPerformed(ActionEvent evt) {
        if (((DefaultMutableTreeNode)this.jTree1.getSelectionPath().getPathComponent(1)).getUserObject() instanceof Project) {
            String n = JOptionPane.showInputDialog(this, "Petri net name:", "New Petri net", 3);
            if (n == null) {
                return;
            }
            if (n.length() == 0) {
                return;
            }
            ((Project)((DefaultMutableTreeNode)this.jTree1.getSelectionPath().getPathComponent(1)).getUserObject()).addPetriNet(new PetriNetImpl(n, NameGenerator.getNewNetName((Project)((DefaultMutableTreeNode)this.jTree1.getSelectionPath().getPathComponent(1)).getUserObject()), "GPN"));
            this.resetModel();
        }
    }

    private void jMenuItem3ActionPerformed(ActionEvent evt) {
        if (((DefaultMutableTreeNode)this.jTree1.getSelectionPath().getPathComponent(1)).getUserObject() instanceof Project) {
            String n = JOptionPane.showInputDialog(this, "Petri net name:", "New Petri net", 3);
            if (n == null) {
                return;
            }
            if (n.length() == 0) {
                return;
            }
            ((Project)((DefaultMutableTreeNode)this.jTree1.getSelectionPath().getPathComponent(1)).getUserObject()).addPetriNet(new PetriNetImpl(n, NameGenerator.getNewNetName((Project)((DefaultMutableTreeNode)this.jTree1.getSelectionPath().getPathComponent(1)).getUserObject()), "EvPN"));
            this.resetModel();
        }
    }

    private void jMenuItem13ActionPerformed(ActionEvent evt) {
        if (((DefaultMutableTreeNode)this.jTree1.getSelectionPath().getPathComponent(1)).getUserObject() instanceof Project) {
            String n = JOptionPane.showInputDialog(this, "Petri net name:", "New Petri net", 3);
            if (n == null) {
                return;
            }
            if (n.length() == 0) {
                return;
            }
            ((Project)((DefaultMutableTreeNode)this.jTree1.getSelectionPath().getPathComponent(1)).getUserObject()).addPetriNet(new PetriNetImpl(n, NameGenerator.getNewNetName((Project)((DefaultMutableTreeNode)this.jTree1.getSelectionPath().getPathComponent(1)).getUserObject()), "TB"));
            this.resetModel();
        }
    }

    private void jMenuItem14ActionPerformed(ActionEvent evt) {
        if (((DefaultMutableTreeNode)this.jTree1.getSelectionPath().getPathComponent(2)).getUserObject() instanceof PetriNetImpl) {
            ImageIcon imgi = new ImageIcon(this.parent.convertToImage((IPetriNet)((DefaultMutableTreeNode)this.jTree1.getSelectionPath().getPathComponent(2)).getUserObject()));
            BufferedImage img = new BufferedImage(imgi.getIconWidth(), imgi.getIconHeight(), 1);
            img.getGraphics().setColor(new Color(0xFFFFFF));
            img.getGraphics().fillRect(0, 0, imgi.getIconWidth(), imgi.getIconHeight());
            img.getGraphics().drawImage(imgi.getImage(), 0, 0, null);
            JFileChooser fc = new JFileChooser();
            fc.setFileFilter(new PNGFilter());
            fc.setCurrentDirectory(new File("./"));
            int a = fc.showSaveDialog(null);
            if (a == 0) {
                try {
                    File f = new File(String.valueOf(fc.getSelectedFile().getAbsolutePath()) + ".png");
                    ImageIO.write((RenderedImage)img, "png", f);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                JOptionPane.showMessageDialog(null, "Petri net has been exported successfully.", this.getName(), 1);
            }
            return;
        }
    }

    private void jTree1MousePressed(MouseEvent evt) {
        int row = this.jTree1.getClosestRowForLocation(evt.getX(), evt.getY());
        this.jTree1.setSelectionRow(row);
    }

    public void SimulatePopupMenuClick(int PopupMenu2) {
        MenuElement[] element;
        if (this.jTree1.getRowCount() <= 0) {
            return;
        }
        if (this.jTree1.getSelectionPath() == null) {
            this.jTree1.setSelectionRow(0);
        }
        if (PopupMenu2 <= (element = this.jPopupMenu1.getSubElements()).length) {
            JMenuItem item = (JMenuItem)element[PopupMenu2];
            item.doClick();
            item.setSelected(false);
        }
    }

    private class MousePopupListener
    extends MouseAdapter {
        private MousePopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.checkPopup(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.checkPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.checkPopup(e);
        }

        private void checkPopup(MouseEvent e) {
            if (e.isPopupTrigger() && ProjectPanel.this.jTree1.getSelectionPath() != null) {
                if (ProjectPanel.this.jTree1.getSelectionPath().getPathCount() == 2) {
                    ProjectPanel.this.jPopupMenu1.show(ProjectPanel.this.jTree1, e.getX(), e.getY());
                }
                if (ProjectPanel.this.jTree1.getSelectionPath().getPathCount() == 3) {
                    ProjectPanel.this.jPopupMenu2.show(ProjectPanel.this.jTree1, e.getX(), e.getY());
                }
            }
        }
    }
}

