/*
 * Decompiled with CFR 0.152.
 */
package pn.project;

import java.awt.Image;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import pn.modules.IModule;
import pn.modules.IResponseListener;
import pn.modules.pn.IPetriNet;
import pn.project.OtherFile;
import pn.project.Project;

public class ProjectOpener
implements IResponseListener {
    private Project proj;

    public Project open(String fname) {
        try {
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(fname));
            Project p = (Project)ois.readUnshared();
            ois.close();
            return p;
        }
        catch (Exception e) {
            System.out.println("error onOpenProject: " + e.toString());
            return null;
        }
    }

    public Project getProject() {
        return this.proj;
    }

    public void loadProject(String fname) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new File(fname));
            doc.getDocumentElement().normalize();
            Node main = doc.getElementsByTagName("pntoolconf").item(0);
            NodeList nodeLst = ((Element)main).getElementsByTagName("project");
            this.loadProject(nodeLst.item(0), new File(fname).getParent());
        }
        catch (Exception e) {
            System.out.println("error onOpenProject: " + e.toString());
        }
    }

    private void loadProject(Node node, String dirname) {
        if (node.getNodeType() == 1) {
            this.proj = new Project();
            this.proj.SetOpenedFromFile(Boolean.TRUE);
            Element element = (Element)node;
            String name = element.getAttribute("name");
            String version = element.getAttribute("version");
            this.proj.createNew(name);
            NodeList nodes = element.getElementsByTagName("net");
            int i = 0;
            while (i < nodes.getLength()) {
                try {
                    this.startLoadingPetriNet(String.valueOf(dirname) + "/" + ((Element)nodes.item(i)).getAttribute("filename"));
                }
                catch (Exception e) {
                    System.out.println("error onLoadPetriNet: " + e.toString());
                }
                ++i;
            }
            nodes = element.getElementsByTagName("file");
            i = 0;
            while (i < nodes.getLength()) {
                try {
                    this.proj.addFile(this.loadFile(String.valueOf(dirname) + "/" + ((Element)nodes.item(i)).getAttribute("filename")));
                }
                catch (Exception e) {
                    System.out.println("error onLoadFiles: " + e.toString());
                }
                ++i;
            }
        }
    }

    @Override
    public Image convertToImage(IPetriNet ipn) {
        return null;
    }

    @Override
    public ArrayList<IPetriNet> requestPetriNets() {
        return null;
    }

    @Override
    public void respond(IPetriNet pn) {
        this.proj.addPetriNet(pn);
    }

    private void startLoadingPetriNet(String fname) {
        try {
            File dir = new File("./modules/");
            File[] fileArray = dir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                try {
                    URLClassLoader cl;
                    Class<?> cls;
                    Object o;
                    if (!file.isDirectory() && (o = (cls = (cl = new URLClassLoader(new URL[]{file.toURI().toURL()})).loadClass("pn.ModuleImpl")).newInstance()) instanceof IModule && ((IModule)o).getName().equals("PNML Opener")) {
                        ((IModule)o).addResponseListener(this);
                        ((IModule)o).executeCommand("set fname " + fname);
                        ((IModule)o).open();
                        ((IModule)o).close();
                        return;
                    }
                }
                catch (Exception e) {
                    System.out.println("error onLoadModule (" + file.getAbsolutePath() + "): " + e.toString());
                }
                ++n2;
            }
            JOptionPane.showMessageDialog(null, "Cannot load PNML Opener module!", "Error!", 0);
        }
        catch (Exception e) {
            System.out.println("error onLoadModules: " + e.toString());
        }
    }

    private OtherFile loadFile(String fname) {
        OtherFile f = new OtherFile(fname, fname);
        f.loadData(fname);
        return f;
    }
}

