/*
 * Decompiled with CFR 0.152.
 */
package pn.project;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import pn.modules.pn.IPetriNet;
import pn.modules.pn.impl.PetriNetImpl;
import pn.project.OtherFile;
import pn.project.ProjectOpener;
import pn.project.ProjectPanel;
import pn.project.ProjectSaver;
import pn.util.NameGenerator;

public class Project
implements Serializable {
    private ArrayList<IPetriNet> petriNets = new ArrayList();
    private ArrayList<OtherFile> otherFiles = new ArrayList();
    private String name;
    private transient String projFileName;
    private transient ProjectOpener opener = new ProjectOpener();
    private transient ProjectSaver saver = new ProjectSaver(this);
    private ProjectPanel parent;
    private Boolean openedfromfile = false;

    public Project(ProjectPanel parent) {
        this.parent = parent;
        NameGenerator.resetNetIndex();
    }

    public Project() {
        NameGenerator.resetNetIndex();
    }

    public Boolean IsOpenedFromFile() {
        return this.openedfromfile;
    }

    public void SetOpenedFromFile(Boolean openedfromfile) {
        this.openedfromfile = openedfromfile;
    }

    public ProjectPanel getParent() {
        return this.parent;
    }

    public void setParent(ProjectPanel parent) {
        this.parent = parent;
    }

    public void createNew(String name) {
        if (this.projFileName == null && !this.IsOpenedFromFile().booleanValue()) {
            JFileChooser fc = new JFileChooser();
            fc.setFileSelectionMode(1);
            fc.setCurrentDirectory(new File("./"));
            int a = fc.showSaveDialog(null);
            if (a != 0) {
                return;
            }
            Boolean success = new File(String.valueOf(fc.getSelectedFile().getAbsolutePath()) + "/" + name).mkdirs();
            if (success.booleanValue()) {
                this.setProjFileName(String.valueOf(fc.getSelectedFile().getAbsolutePath()) + "/" + name + "/");
                NameGenerator.resetNetIndex();
            }
        }
        this.name = name;
    }

    public void open(String fileName) {
        this.projFileName = fileName.substring(0, fileName.lastIndexOf("/") == -1 ? fileName.lastIndexOf("\\") : fileName.lastIndexOf("/"));
        this.opener.loadProject(fileName);
        Project p = this.opener.getProject();
        int i = 0;
        while (i < p.getPetriNetsCount()) {
            this.addPetriNet(p.getPetriNet(i));
            ++i;
        }
        i = 0;
        while (i < p.getOtherFilesCount()) {
            this.addFile(p.getOtherFile(i));
            ++i;
        }
        this.name = p.getName();
        NameGenerator.resetNetIndex();
    }

    public ProjectSaver getProjectSaver() {
        return this.saver;
    }

    public void saveWithoutUpdate() {
        this.saver.saveTxt(null);
    }

    public void save() {
        this.parent.getParentAdv().updateProject(this);
        this.saver.saveTxt(null);
    }

    public void saveAs(String fname) {
        this.projFileName = fname;
        this.saver.save(this.projFileName);
    }

    public void renamePetriNet(IPetriNet ipn, String newName) {
        File f = new File(String.valueOf(this.getProjFileName()) + "/" + ipn.getName() + "(" + ipn.getId() + ").pnml");
        f.renameTo(new File(String.valueOf(this.getProjFileName()) + "/" + newName + "(" + ipn.getId() + ").pnml"));
    }

    public void rename(String newName) {
        this.name = newName;
    }

    public IPetriNet getPetriNetById(String id) {
        int i = 0;
        while (i < this.petriNets.size()) {
            if (this.petriNets.get(i).getId().equals(id)) {
                return this.petriNets.get(i);
            }
            ++i;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setProjFileName(String fname) {
        this.projFileName = fname;
    }

    public String getProjFileName() {
        return this.projFileName;
    }

    public void updatePetriNet(IPetriNet pn) {
        int i = 0;
        while (i < this.petriNets.size()) {
            if (this.petriNets.get(i).getId().equals(pn.getId())) {
                this.petriNets.set(i, pn);
                this.parent.resetModel();
                return;
            }
            ++i;
        }
    }

    protected void setPetriNets(ArrayList<IPetriNet> nets) {
        this.petriNets = nets;
    }

    protected void setOtherFiles(ArrayList<OtherFile> files) {
        this.otherFiles = files;
    }

    public IPetriNet getPetriNet(int index) {
        return this.petriNets.get(index);
    }

    public int getPetriNetsCount() {
        return this.petriNets.size();
    }

    public void addPetriNet(IPetriNet ipn) {
        int i = 0;
        while (i < this.petriNets.size()) {
            if (this.petriNets.get(i).getId().equals(ipn.getId())) {
                if (ipn instanceof PetriNetImpl) {
                    ((PetriNetImpl)ipn).setId(NameGenerator.getNewNetName(this));
                    this.petriNets.add(ipn);
                } else {
                    PetriNetImpl pni = new PetriNetImpl(ipn.getArcs(), ipn.getPlaces(), ipn.getTransitions(), ipn.getName(), ipn.getId(), ipn.getType(), ipn.getAdditionalData());
                    pni.setId(NameGenerator.getNewNetName(this));
                    this.petriNets.add(pni);
                }
                return;
            }
            ++i;
        }
        this.petriNets.add(ipn);
    }

    public void removePetriNet(IPetriNet pn) {
        this.petriNets.remove(pn);
        this.save();
    }

    public void removePetriNet(int index) {
        this.petriNets.remove(index);
        this.save();
    }

    public void removeAllPetriNets() {
        this.petriNets.clear();
        this.save();
    }

    public OtherFile getOtherFile(int index) {
        return this.otherFiles.get(index);
    }

    public int getOtherFilesCount() {
        return this.otherFiles.size();
    }

    public void addFile(OtherFile fileName) {
        this.otherFiles.add(fileName);
    }

    public void removeFile(int index) {
        this.otherFiles.remove(index);
        this.save();
    }

    public void removeFile(OtherFile f) {
        this.otherFiles.remove(f);
        this.save();
    }

    public void removeAllOtherFiles() {
        this.otherFiles.clear();
        this.save();
    }

    public void removeAll() {
        this.removeAllPetriNets();
        this.removeAllOtherFiles();
        this.save();
    }

    public String toString() {
        return this.name;
    }
}

