/*
 * Decompiled with CFR 0.152.
 */
package pn.modules;

import java.util.ArrayList;
import java.util.Properties;
import pn.evpn.logic.PNLEdge;
import pn.logic.IPNLEdge;
import pn.logic.IPNLPlace;
import pn.logic.IPNLTransition;
import pn.logic.PNLPetriNet;
import pn.modules.pn.IArc;
import pn.modules.pn.IPetriNet;
import pn.modules.pn.IPlace;
import pn.modules.pn.ITransition;
import pn.modules.pn.IVertex;
import pn.modules.pn.impl.ArcImpl;
import pn.modules.pn.impl.PetriNetImpl;
import pn.modules.pn.impl.PlaceImpl;
import pn.modules.pn.impl.TransitionImpl;
import pn.tb.logic.PNLPlace;
import pn.tb.logic.PNLTransition;

public class PetriNetConverter {
    public static IPetriNet convert(PNLPetriNet pnlpn) {
        if (pnlpn == null) {
            return null;
        }
        ArrayList<IPlace> places = new ArrayList<IPlace>();
        ArrayList<ITransition> transitions = new ArrayList<ITransition>();
        ArrayList<IArc> arcs = new ArrayList<IArc>();
        int i = 0;
        while (i < pnlpn.getPlaces().size()) {
            places.add(PetriNetConverter.convertPlace(pnlpn.getPlaces().get(i)));
            ++i;
        }
        i = 0;
        while (i < pnlpn.getTransitions().size()) {
            transitions.add(PetriNetConverter.convertTransition(pnlpn.getTransitions().get(i)));
            ++i;
        }
        i = 0;
        while (i < pnlpn.getEdges().size()) {
            arcs.add(PetriNetConverter.convertArc(pnlpn.getEdge(i), places, transitions));
            ++i;
        }
        PetriNetImpl pni = new PetriNetImpl(arcs, places, transitions, pnlpn.getName(), pnlpn.getId(), pnlpn.getType(), pnlpn.getProperties());
        pni.setAdditionalData(pnlpn.getProperties());
        return pni;
    }

    private static IArc convertArc(IPNLEdge e, ArrayList<IPlace> places, ArrayList<ITransition> transitions) {
        int i;
        IVertex v1 = null;
        IVertex v2 = null;
        if (e.getVertex1() instanceof IPNLPlace) {
            i = 0;
            while (i < places.size()) {
                if (places.get(i).getId().equals(e.getVertex1().getId())) {
                    v1 = places.get(i);
                    break;
                }
                ++i;
            }
            i = 0;
            while (i < transitions.size()) {
                if (transitions.get(i).getId().equals(e.getVertex2().getId())) {
                    v2 = transitions.get(i);
                    break;
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < places.size()) {
                if (places.get(i).getId().equals(e.getVertex2().getId())) {
                    v2 = places.get(i);
                    break;
                }
                ++i;
            }
            i = 0;
            while (i < transitions.size()) {
                if (transitions.get(i).getId().equals(e.getVertex1().getId())) {
                    v1 = transitions.get(i);
                    break;
                }
                ++i;
            }
        }
        ArcImpl a = new ArcImpl(e.getKnots(), v1, v2, e.getId(), e.getCount(), e.getGrEdge().getCountPosX(), e.getGrEdge().getCountPosY());
        a.setCountX(e.getGrEdge().getCountPosX());
        a.setCountY(e.getGrEdge().getCountPosY());
        if (e instanceof PNLEdge) {
            a.setAdditionalData(((PNLEdge)e).getAllProperties());
        }
        return a;
    }

    private static IPlace convertPlace(IPNLPlace p) {
        PlaceImpl pi;
        Properties prop = new Properties();
        prop.put("Color", p.getProperty("Color"));
        if (p instanceof pn.evpn.logic.PNLPlace) {
            String type = "p";
            if (((pn.evpn.logic.PNLPlace)p).getType() == 1) {
                type = "pe";
                prop.put("EvPN Pe", p.getProperty("EvPN Pe"));
            }
            if (((pn.evpn.logic.PNLPlace)p).getType() == 2) {
                type = "pf";
                prop.put("EvPN Pf", p.getProperty("EvPN Pf"));
            }
            pi = new PlaceImpl(p.getId(), p.getName(), type, p.getGrPlace().getNamePositionX(), p.getGrPlace().getNamePositionY(), p.getX(), p.getY(), p.getTokens(), ((pn.evpn.logic.PNLPlace)p).getFunction());
        } else if (p instanceof PNLPlace) {
            ArrayList<double[]> tokens = new ArrayList<double[]>();
            int i = 0;
            while (i < ((PNLPlace)p).getTokens()) {
                tokens.add(new double[]{((PNLPlace)p).getToken(i).getMinValue(), ((PNLPlace)p).getToken(i).getMaxValue()});
                ++i;
            }
            prop.put("TB Tokens", tokens);
            pi = new PlaceImpl(p.getId(), p.getName(), p.getGrPlace().getNamePositionX(), p.getGrPlace().getNamePositionY(), p.getX(), p.getY(), p.getTokens());
        } else {
            pi = new PlaceImpl(p.getId(), p.getName(), p.getGrPlace().getNamePositionX(), p.getGrPlace().getNamePositionY(), p.getX(), p.getY(), p.getTokens());
        }
        pi.setAdditionalData(prop);
        return pi;
    }

    private static ITransition convertTransition(IPNLTransition t) {
        TransitionImpl ti = new TransitionImpl(t.getId(), t.getName(), t.getGrTransition().getNamePositionX(), t.getGrTransition().getNamePositionY(), t.getX(), t.getY());
        Properties prop = new Properties();
        prop.put("Color", t.getProperty("Color"));
        if (t instanceof PNLTransition) {
            prop.put("TB Function", ((PNLTransition)t).getFunction());
        }
        ti.setAdditionalData(prop);
        return ti;
    }
}

