/*
 * Decompiled with CFR 0.152.
 */
package pn.modules;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import javax.swing.JComponent;
import pn.MainFrame;
import pn.help.ModuleHelp;
import pn.modules.IModule;

public class ModuleCtrl {
    private ArrayList<IModule> modules = new ArrayList();
    private MainFrame parent;

    public ModuleCtrl(MainFrame parent) {
        this.parent = parent;
        this.load();
    }

    public void addModule(IModule m) {
        this.modules.add(m);
    }

    public IModule getModule(int index) {
        return this.modules.get(index);
    }

    public IModule getModuleByName(String name) {
        int i = 0;
        while (i < this.modules.size()) {
            if (this.modules.get(i).getName().equals(name)) {
                return this.modules.get(i);
            }
            ++i;
        }
        return null;
    }

    public void removeModule(int index) {
        this.eraseModule(this.modules.get(index));
        this.modules.remove(index);
    }

    public void removeModule(IModule m) {
        this.eraseModule(m);
        this.modules.remove(m);
    }

    public JComponent[] getControlPanels() {
        JComponent[] c = new JComponent[this.modules.size()];
        int i = 0;
        while (i < c.length) {
            c[i] = this.modules.get(i).getControlPanel();
            ++i;
        }
        return c;
    }

    public String[] getNames() {
        ArrayList<String> s = new ArrayList<String>();
        int i = 0;
        while (i < this.modules.size()) {
            s.add(this.modules.get(i).getName());
            ++i;
        }
        String[] a = new String[s.size()];
        return s.toArray(a);
    }

    public ArrayList<ModuleHelp> getHelps() {
        ArrayList<ModuleHelp> s = new ArrayList<ModuleHelp>();
        int i = 0;
        while (i < this.modules.size()) {
            IModule module = this.modules.get(i);
            s.add(new ModuleHelp(module.getName("_sk"), module.getName("_eng"), module.getTarget(), module.getHTMLHelpSK(), module.getHTMLHelpENG()));
            ++i;
        }
        return s;
    }

    public void eraseModule(IModule m) {
        try {
            File dir = new File("./modules/");
            File[] fileArray = dir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                URLClassLoader cl = new URLClassLoader(new URL[]{file.toURI().toURL()});
                Class<?> cls = cl.loadClass("pn.ModuleImpl");
                Object o = cls.newInstance();
                if (o instanceof IModule && ((IModule)o).equals(m)) {
                    file.delete();
                }
                ++n2;
            }
        }
        catch (Exception e) {
            System.out.println("error onEraseModule: " + e.toString());
        }
    }

    public void load() {
        try {
            File dir = new File("./modules/");
            File[] fileArray = dir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                try {
                    if (!file.isDirectory()) {
                        URLClassLoader cl = new URLClassLoader(new URL[]{file.toURI().toURL()});
                        Class<?> cls = cl.loadClass("pn.ModuleImpl");
                        Object o = cls.newInstance();
                        if (o instanceof IModule) {
                            ((IModule)o).addResponseListener(this.parent);
                            this.modules.add((IModule)o);
                        }
                    }
                }
                catch (Exception e) {
                    System.out.println("error onLoadModule (" + file.getAbsolutePath() + "): " + e.toString());
                }
                ++n2;
            }
        }
        catch (Exception e) {
            System.out.println("error onLoadModules: " + e.toString());
        }
    }
}

