/*
 * Decompiled with CFR 0.152.
 */
package pn.logic;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Properties;
import pn.gui.PNGUIPanel;
import pn.logic.IPNLPlace;
import pn.logic.IPNLTransition;
import pn.logic.IPNLVertex;
import pn.logic.PNLEdge;

public class PNLPetriNet
implements Serializable {
    protected ArrayList<PNLEdge> edgeList;
    protected ArrayList<IPNLVertex> vertexList;
    protected PNGUIPanel grPetriNet;
    protected String name;
    protected String id;
    protected String type;
    protected Properties props;

    public PNLPetriNet(ArrayList<PNLEdge> el, ArrayList<IPNLVertex> vl, String type) {
        this.edgeList = new ArrayList<PNLEdge>(el);
        this.vertexList = new ArrayList<IPNLVertex>(vl);
        this.grPetriNet = new PNGUIPanel();
        int i = 0;
        while (i < vl.size()) {
            this.grPetriNet.getLayer().addChild(vl.get(i).getGrVertex());
            ++i;
        }
        i = 0;
        while (i < el.size()) {
            this.grPetriNet.getLayer().addChild(el.get(i).getGrEdge());
            ++i;
        }
        this.name = "net1";
        this.id = "net1";
        this.type = new String(type);
        this.props = new Properties();
    }

    public PNLPetriNet(String type) {
        this.edgeList = new ArrayList();
        this.vertexList = new ArrayList();
        this.grPetriNet = new PNGUIPanel();
        this.name = "net1";
        this.id = "net1";
        this.type = new String(type);
    }

    public void addEdge(PNLEdge e) {
        this.edgeList.add(e);
        this.grPetriNet.getLayer().addChild(e.getGrEdge());
    }

    public PNLEdge getEdge(int index) {
        return this.edgeList.get(index);
    }

    public ArrayList<PNLEdge> getEdges() {
        return new ArrayList<PNLEdge>(this.edgeList);
    }

    public void addVertex(IPNLVertex v) {
        this.vertexList.add(v);
        this.grPetriNet.getLayer().addChild(v.getGrVertex());
    }

    public IPNLVertex getVertex(int index) {
        return this.vertexList.get(index);
    }

    public ArrayList<IPNLPlace> getPlaces() {
        ArrayList<IPNLPlace> p = new ArrayList<IPNLPlace>();
        int i = 0;
        while (i < this.vertexList.size()) {
            if (this.vertexList.get(i) instanceof IPNLPlace) {
                p.add((IPNLPlace)this.vertexList.get(i));
            }
            ++i;
        }
        return p;
    }

    public ArrayList<IPNLTransition> getTransitions() {
        ArrayList<IPNLTransition> t = new ArrayList<IPNLTransition>();
        int i = 0;
        while (i < this.vertexList.size()) {
            if (this.vertexList.get(i) instanceof IPNLTransition) {
                t.add((IPNLTransition)this.vertexList.get(i));
            }
            ++i;
        }
        return t;
    }

    public ArrayList<IPNLVertex> getVertices() {
        return new ArrayList<IPNLVertex>(this.vertexList);
    }

    public IPNLVertex getVertexByPos(float x, float y) {
        int i = 0;
        while (i < this.vertexList.size()) {
            if (this.getVertex(i).getX() < (double)x && this.getVertex(i).getY() < (double)y && this.getVertex(i).getX() + this.getVertex(i).getWidth() > (double)x && this.getVertex(i).getY() + this.getVertex(i).getHeight() > (double)y) {
                return this.getVertex(i);
            }
            ++i;
        }
        return null;
    }

    public IPNLVertex getVertexByName(String srchName) {
        int i = 0;
        while (i < this.vertexList.size()) {
            if (this.vertexList.get(i).getName().compareTo(srchName) == 0) {
                return this.vertexList.get(i);
            }
            ++i;
        }
        return null;
    }

    public IPNLVertex getVertexById(String srchId) {
        int i = 0;
        while (i < this.vertexList.size()) {
            if (this.vertexList.get(i).getId().compareTo(srchId) == 0) {
                return this.vertexList.get(i);
            }
            ++i;
        }
        return null;
    }

    public PNLEdge getEdgeById(String srchId) {
        int i = 0;
        while (i < this.edgeList.size()) {
            if (this.edgeList.get(i).getId().compareTo(srchId) == 0) {
                return this.edgeList.get(i);
            }
            ++i;
        }
        return null;
    }

    public IPNLVertex getLastVertexAdded() {
        return this.vertexList.get(this.vertexList.size() - 1);
    }

    public PNLEdge getLastEdgeAdded() {
        return this.edgeList.get(this.edgeList.size() - 1);
    }

    public void removeEdge(int index) {
        this.edgeList.get(index).getVertex1().getGrVertex().removeEdge(this.edgeList.get(index).getGrEdge());
        this.edgeList.get(index).getVertex2().getGrVertex().removeEdge(this.edgeList.get(index).getGrEdge());
        this.grPetriNet.getLayer().removeChild(this.edgeList.get(index).getGrEdge());
        this.edgeList.remove(index);
    }

    public void removeEdge(PNLEdge edge) {
        this.grPetriNet.getLayer().removeChild(edge.getGrEdge());
        this.edgeList.remove(edge);
        edge.getVertex1().getGrVertex().removeEdge(edge.getGrEdge());
        edge.getVertex2().getGrVertex().removeEdge(edge.getGrEdge());
    }

    public void removeVertex(int index) {
        this.grPetriNet.getLayer().removeChild(this.vertexList.get(index).getGrVertex());
        this.vertexList.remove(index);
    }

    public void removeVertex(IPNLVertex vert) {
        this.grPetriNet.getLayer().removeChild(vert.getGrVertex());
        this.vertexList.remove(vert);
    }

    public PNGUIPanel getGrPetriNet() {
        return this.grPetriNet;
    }

    public void refresh() {
        this.grPetriNet.repaintAll();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = new String(n);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String n) {
        this.id = new String(n);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = new String(type);
    }

    public Properties getProperties() {
        return this.props;
    }

    public void setProperties(Properties p) {
        this.props = p;
    }

    public String toString() {
        return this.name;
    }
}

