/*
 * Decompiled with CFR 0.152.
 */
package pn.logic;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import pn.gui.PNGUIEdge;
import pn.gui.PNGUIKnot;
import pn.logic.IPNLEdge;
import pn.logic.IPNLVertex;

public class PNLEdge
implements IPNLEdge,
Serializable {
    protected final IPNLVertex begin;
    protected final IPNLVertex end;
    protected PNGUIEdge grEdge;
    protected Properties props = new Properties();

    public PNLEdge(IPNLVertex v1, IPNLVertex v2) {
        this.begin = v1;
        this.end = v2;
        this.grEdge = new PNGUIEdge(v1.getGrVertex(), v2.getGrVertex(), this);
        this.setProps("", 1);
    }

    public PNLEdge(IPNLVertex v1, IPNLVertex v2, String id, int count) {
        this.begin = v1;
        this.end = v2;
        this.grEdge = new PNGUIEdge(v1.getGrVertex(), v2.getGrVertex(), this);
        this.props.put("Count", (Object)count);
        this.getGrEdge().setCount(count);
        this.setProps(id, count);
    }

    protected void setProps(String id, int count) {
        if (this.props == null) {
            this.props = new Properties();
        }
        this.props.put("Id", new String(id));
        this.props.put("Count", new Integer(count));
    }

    @Override
    public Object getProperty(String key) {
        return this.props.get(key);
    }

    @Override
    public void setProperty(String key, Object value) throws Exception {
        if (key.equals("Id")) {
            this.setId((String)value);
            return;
        }
        if (key.equals("Count")) {
            this.setCount(Integer.parseInt((String)value));
            return;
        }
        this.props.put(key, value);
    }

    @Override
    public int getPropertiesCount() {
        return this.props.size();
    }

    @Override
    public Object getProperty(int index) {
        Object o;
        if (index >= this.props.size()) {
            return null;
        }
        Enumeration<Object> e = this.props.elements();
        int counter = 0;
        do {
            o = e.nextElement();
        } while (++counter <= index);
        return o.toString();
    }

    @Override
    public Object getPropertyName(int index) {
        Object o;
        if (index >= this.props.size()) {
            return null;
        }
        Enumeration<Object> e = this.props.keys();
        int counter = 0;
        do {
            o = e.nextElement();
        } while (++counter <= index);
        return o;
    }

    @Override
    public boolean isEditableProperty(int index) {
        Object o;
        if (index >= this.props.size()) {
            return false;
        }
        Enumeration<Object> e = this.props.keys();
        int counter = 0;
        do {
            o = e.nextElement();
        } while (++counter <= index);
        if (((String)o).equals("Id")) {
            return false;
        }
        if (((String)o).equals("Name")) {
            return true;
        }
        if (((String)o).equals("Count")) {
            return true;
        }
        if (((String)o).equals("EvPN Function")) {
            return true;
        }
        if (((String)o).equals("EvPN d")) {
            return true;
        }
        return ((String)o).equals("EvPN w");
    }

    @Override
    public PNGUIEdge getGrEdge() {
        return this.grEdge;
    }

    @Override
    public IPNLVertex getVertex1() {
        return this.begin;
    }

    @Override
    public IPNLVertex getVertex2() {
        return this.end;
    }

    @Override
    public String getId() {
        return this.props.getProperty("Id");
    }

    @Override
    public void setId(String n) {
        this.props.put("Id", new String(n));
    }

    public String getName() {
        return (String)this.getProperty("Name");
    }

    public void setName(String name) {
        try {
            this.setProperty("Name", name);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public int getCount() {
        return (Integer)this.props.get("Count");
    }

    public void setCount(int c) {
        this.props.put("Count", new Integer(c));
        this.getGrEdge().setCount(c);
    }

    public void increase() {
        this.props.put("Count", new Integer(this.getCount() + 1));
    }

    public void decrease() {
        if (this.getCount() > 1) {
            this.props.put("Count", new Integer(this.getCount() - 1));
        }
    }

    public void addKnot(PNGUIKnot knot) {
        this.grEdge.addKnot(knot);
    }

    public void addKnots(ArrayList knots) {
        this.grEdge.addKnots(knots);
    }

    public void replaceKnots(ArrayList knots) {
        this.grEdge.replaceKnots(knots);
    }

    public void removeAllKnots() {
        this.grEdge.removeAllKnots();
    }

    @Override
    public ArrayList<double[]> getKnots() {
        ArrayList<double[]> a = new ArrayList<double[]>();
        int i = 0;
        while (i < this.grEdge.getKnotCount()) {
            double[] d = new double[]{this.grEdge.getKnot(i).getIntX(), this.grEdge.getKnot(i).getIntY()};
            a.add(d);
            ++i;
        }
        return a;
    }
}

