/*
 * Decompiled with CFR 0.152.
 */
package pn.help;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import pn.help.HelpException;
import pn.help.ModuleHelp;
import pn.modules.ModuleCtrl;

public class GenerateTOC {
    private static final String staticTOCpartSK = "<?xml version='1.0' encoding='ISO-8859-1'  ?>\n<!DOCTYPE toc\n  PUBLIC \"-//Sun Microsystems Inc.//DTD JavaHelp TOC Version 2.0//EN\"\n         \"../dtd/toc_2_0.dtd\">\n<toc version=\"2.0\">\n   <tocitem image=\"img.toplevelfolder\" target=\"index_sk\" text=\"Pomocn\u00edk pre PNTool2.1\">\n\n       <tocitem text=\"1. &#268;o je PNTool2.1 a na &#269;o ho m\u00f4&#382;ete pou&#382;i&#357;?\" target=\"index_sk\"/>\n\n       <tocitem text=\"2. Vytv\u00e1ranie a editovanie projektov\" target=\"edit_sk\" expand=\"true\">\n           <tocitem text=\"2.1 - Prid\u00e1vanie miest\" target=\"edit.places_sk\"/>\n           <tocitem text=\"2.2 - Prid\u00e1vanie prechodov\" target=\"edit.transitions_sk\"/>\n           <tocitem text=\"2.3 - Prid\u00e1vanie hran\" target=\"edit.edges_sk\"/>\n           <tocitem text=\"2.4 - Odstr\u00e1nenie komponentov\" target=\"edit.remove_sk\"/>\n       </tocitem>\n\n       <tocitem text=\"3. Simul\u00e1cia v PNTools2.1\" target=\"simulation_sk\"/>\n\n       <tocitem text=\"4. &#268;o s\u00fa moduly a ako ich spusti&#357;?\" target=\"modules_sk\"/>\n\n       <tocitem text=\"5. Dostupn\u00e9 moduly\" target=\"\" expand=\"true\">";
    private static final String staticTOCpartENG = "<?xml version='1.0' encoding='ISO-8859-1'  ?>\n<!DOCTYPE toc\nPUBLIC \"-//Sun Microsystems Inc.//DTD JavaHelp TOC Version 2.0//EN\"\n\"../dtd/toc_2_0.dtd\">\n<toc version=\"2.0\">\n\n<tocitem image=\"img.toplevelfolder\" target=\"index_eng\" text=\"Help for PNTool2.1\">\n\n    <tocitem text=\"1. What is PNTool2.1 and what can you do with this application?\" target=\"index_eng\"/>\n\n    <tocitem text=\"2. Creating and editing projects\" target=\"edit_eng\" expand=\"true\">\n        <tocitem text=\"2.1 - Addig places\" target=\"edit.places_eng\"/>\n        <tocitem text=\"2.2 - Adding transitions\" target=\"edit.transitions_eng\"/>\n        <tocitem text=\"2.3 - Adding edges\" target=\"edit.edges_eng\"/>\n        <tocitem text=\"2.4 - Removing components\" target=\"edit.remove_eng\"/>\n    </tocitem>\n\n    <tocitem text=\"3. Simulation in PNTools2.1\" target=\"simulation_eng\"/>\n\n    <tocitem text=\"4. What is module and how to run it?\" target=\"modules_eng\"/>\n\n    <tocitem text=\"5. Available modules\" target=\"\" expand=\"true\">";
    private String middleTOCPart = null;
    private ModuleCtrl moduleCtrl;
    private File file;

    public GenerateTOC(String prefix, ModuleCtrl moduleCtrl) throws HelpException {
        this.moduleCtrl = moduleCtrl;
        this.file = new File("help/helpSetTOC" + prefix + ".xml");
        this.save(prefix);
    }

    private void save(String prefix) throws HelpException {
        try {
            FileOutputStream fos = new FileOutputStream(this.file);
            DataOutputStream dos = new DataOutputStream(fos);
            if (prefix.equals("_sk")) {
                dos.writeBytes(staticTOCpartSK + this.generate(prefix) + "    </tocitem>\n</tocitem>\n</toc>");
            } else if (prefix.equals("_eng")) {
                dos.writeBytes(staticTOCpartENG + this.generate(prefix) + "    </tocitem>\n\n</tocitem>\n</toc>");
            } else {
                throw new HelpException("Wrong language prefix!");
            }
            dos.close();
            fos.close();
        }
        catch (IOException ex) {
            System.out.println("Error: " + ex.getMessage());
        }
    }

    private String generate(String prefix) throws HelpException {
        ArrayList<ModuleHelp> helps = this.moduleCtrl.getHelps();
        this.middleTOCPart = "\n";
        int i = 1;
        if (prefix.equals("_sk")) {
            for (ModuleHelp help : helps) {
                if (help.getTarget() == null) continue;
                this.middleTOCPart = String.valueOf(this.middleTOCPart) + "        <tocitem text=\"5." + i + " - " + help.getName(prefix) + "\" target=\"" + help.getTarget() + prefix + "\" />\n";
                ++i;
            }
        } else if (prefix.equals("_eng")) {
            for (ModuleHelp help : helps) {
                if (help.getTarget() == null) continue;
                this.middleTOCPart = String.valueOf(this.middleTOCPart) + "        <tocitem text=\"5." + i + " - " + help.getName(prefix) + "\" target=\"" + help.getTarget() + prefix + "\" />\n";
                ++i;
            }
        } else {
            throw new HelpException("Wrong prefix: " + prefix);
        }
        return this.middleTOCPart;
    }
}

