/*
 * Decompiled with CFR 0.152.
 */
package pn.help;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import pn.help.ModuleHelp;
import pn.modules.ModuleCtrl;

public class GenerateMapFile {
    private static final String staticMapPart = "<?xml version='1.0' encoding='UTF-8' ?>\n<!DOCTYPE map\n PUBLIC \"-//Sun Microsystems Inc.//DTD JavaHelp Map Version 2.0//EN\"\n \"http://java.sun.com/javase/technologies/desktop/javahelp/map_2_0.dtd\">\n\n<map version=\"2.0\">\n     <mapID target=\"index_sk\" url=\"content/index_sk.html\" />\n     <mapID target=\"index_eng\" url=\"content/index_eng.html\" />\n\n     <mapID target=\"edit_sk\" url=\"content/edit_sk.html\" />\n     <mapID target=\"edit.places_sk\" url=\"content/edit.places_sk.html\" />\n     <mapID target=\"edit.transitions_sk\" url=\"content/edit.transitions_sk.html\" />\n     <mapID target=\"edit.edges_sk\" url=\"content/edit.edges_sk.html\" />\n     <mapID target=\"edit.remove_sk\" url=\"content/edit.remove_sk.html\" />\n     <mapID target=\"simulation_sk\" url=\"content/simulation_sk.html\" />\n     <mapID target=\"modules_sk\" url=\"content/modules_sk.html\" />\n     <mapID target=\"edit_eng\" url=\"content/edit_eng.html\" />\n     <mapID target=\"edit.places_eng\" url=\"content/edit.places_eng.html\" />\n     <mapID target=\"edit.transitions_eng\" url=\"content/edit.transitions_eng.html\" />\n     <mapID target=\"edit.edges_eng\" url=\"content/edit.edges_eng.html\" />\n     <mapID target=\"edit.remove_eng\" url=\"content/edit.remove_eng.html\" />\n     <mapID target=\"simulation_eng\" url=\"content/simulation_eng.html\" />\n     <mapID target=\"modules_eng\" url=\"content/modules_eng.html\" />";
    private String middleMapPart;
    private ModuleCtrl moduleCtrl;
    private File file;

    public GenerateMapFile(ModuleCtrl moduleCtrl) {
        this.moduleCtrl = moduleCtrl;
        this.file = new File("help/helpSetMap.jhm");
        this.save();
    }

    public void save() {
        try {
            FileOutputStream fos = new FileOutputStream(this.file);
            DataOutputStream dos = new DataOutputStream(fos);
            dos.writeBytes(staticMapPart + this.generate() + "\n</map>");
            dos.close();
            fos.close();
        }
        catch (IOException ex) {
            System.out.println("Error: " + ex.getMessage());
        }
    }

    private String generate() {
        ArrayList<ModuleHelp> helps = this.moduleCtrl.getHelps();
        this.middleMapPart = "\n";
        for (ModuleHelp help : helps) {
            if (help.getTarget() == null) continue;
            this.middleMapPart = String.valueOf(this.middleMapPart) + "\n     <mapID target=\"" + help.getTarget() + "_sk" + "\" url=\"file:\\" + help.getPath("_sk") + "\" />";
            this.middleMapPart = String.valueOf(this.middleMapPart) + "\n     <mapID target=\"" + help.getTarget() + "_eng" + "\" url=\"file:\\" + help.getPath("_eng") + "\" />";
        }
        return this.middleMapPart;
    }
}

