/*
 * Decompiled with CFR 0.152.
 */
package pn.gui;

import edu.umd.cs.piccolo.PNode;
import java.awt.Color;
import java.util.ArrayList;
import pn.gui.Handle;
import pn.gui.PNGUIEdge;
import pn.gui.PNGUIText;

public class PNGUIVertex
extends PNode {
    protected PNGUIText name;
    protected PNGUIText comment;
    protected boolean showTexts;
    protected boolean selected = false;
    protected Color customColor;
    protected boolean showAdvTexts;
    protected PNGUIText advText;
    private ArrayList<PNGUIEdge> edges = new ArrayList();

    public PNGUIVertex() {
        this.addChild(new Handle((float)this.getGlobalBounds().getMinX(), (float)this.getGlobalBounds().getCenterY()));
        this.addChild(new Handle((float)this.getGlobalBounds().getCenterX(), (float)this.getGlobalBounds().getMinY()));
        this.addChild(new Handle((float)this.getGlobalBounds().getMaxX(), (float)this.getGlobalBounds().getCenterY()));
        this.addChild(new Handle((float)this.getGlobalBounds().getCenterX(), (float)this.getGlobalBounds().getMaxY()));
        this.name = new PNGUIText(this);
        this.name.setBounds(this.getGlobalBounds());
        this.addChild(this.name);
        this.comment = new PNGUIText(this);
        this.comment.setBounds(this.getGlobalBounds());
        this.addChild(this.comment);
        this.showTexts = true;
        this.showAdvTexts = true;
        this.advText = new PNGUIText(this);
        this.addChild(this.advText);
    }

    public Color getColor() {
        return this.customColor;
    }

    public void setColor(Color c) {
        this.customColor = c;
    }

    @Override
    public double getX() {
        return this.getGlobalBounds().getX();
    }

    @Override
    public double getY() {
        return this.getGlobalBounds().getY();
    }

    public void setAdvancedTexts(String text) {
        this.advText.setText(text);
        this.advText.repaint();
    }

    public void showAdvancedTexts() {
        this.showAdvTexts = true;
        this.advText.setVisible(true);
    }

    public void hideAdvancedTexts() {
        this.showAdvTexts = false;
        this.advText.setVisible(false);
    }

    public void showTexts() {
        this.showTexts = true;
        int i = 0;
        while (i < this.getChildrenCount()) {
            if (this.getChild(i) instanceof PNGUIText && !this.getChild(i).equals(this.advText)) {
                this.getChild(i).setVisible(true);
            }
            ++i;
        }
    }

    public void hideTexts() {
        this.showTexts = false;
        int i = 0;
        while (i < this.getChildrenCount()) {
            if (this.getChild(i) instanceof PNGUIText && !this.getChild(i).equals(this.advText)) {
                this.getChild(i).setVisible(false);
            }
            ++i;
        }
    }

    public void refreshTexts() {
        String tmpName = this.name.getText();
        String tmpComment = this.comment.getText();
        this.setName(tmpName);
        this.setNamePosition((float)this.getGlobalBounds().getX() - 20.0f, (float)this.getGlobalBounds().getY() + 20.0f);
    }

    public String getName() {
        if (this.name != null) {
            return this.name.getText();
        }
        return null;
    }

    public void setName(String text) {
        this.name.setText(text);
        this.name.repaint();
    }

    public int getNamePositionX() {
        return (int)this.name.getGlobalBounds().getX();
    }

    public int getNamePositionY() {
        return (int)this.name.getGlobalBounds().getY();
    }

    public void setNamePosition(double x, double y) {
        String tmpName = this.name.getText();
        this.removeChild(this.name);
        this.name = new PNGUIText(tmpName, this);
        this.name.setBounds(x, y, 100.0, 30.0);
        if (this.showTexts) {
            this.addChild(this.name);
        }
        this.advText.setBounds(x, y + 20.0, 100.0, 30.0);
    }

    protected void setHandles() {
        int i = 0;
        while (!(this.getChild(i) instanceof Handle)) {
            ++i;
        }
        ((Handle)this.getChild(i++)).setBounds(this.getGlobalBounds().getMinX(), this.getGlobalBounds().getCenterY());
        while (!(this.getChild(i) instanceof Handle)) {
            ++i;
        }
        ((Handle)this.getChild(i++)).setBounds(this.getGlobalBounds().getCenterX(), this.getGlobalBounds().getMinY());
        while (!(this.getChild(i) instanceof Handle)) {
            ++i;
        }
        ((Handle)this.getChild(i++)).setBounds(this.getGlobalBounds().getMaxX(), this.getGlobalBounds().getCenterY());
        while (!(this.getChild(i) instanceof Handle)) {
            ++i;
        }
        ((Handle)this.getChild(i)).setBounds(this.getGlobalBounds().getCenterX(), this.getGlobalBounds().getMaxY());
    }

    public double[] getClosestPort(double x, double y) {
        ArrayList<double[]> hl = new ArrayList<double[]>();
        double angle = Math.atan2(this.getGlobalBounds().getCenterY() - y, this.getGlobalBounds().getCenterX() - x);
        int i = 0;
        while (i < this.getChildrenCount()) {
            if (this.getChild(i) instanceof Handle) {
                hl.add(new double[]{this.getChild(i).getGlobalBounds().getCenterX(), this.getChild(i).getGlobalBounds().getCenterY()});
            }
            ++i;
        }
        if (angle < -2.356194490192345) {
            return (double[])hl.get(2);
        }
        if (angle < -0.7853981633974483) {
            return (double[])hl.get(3);
        }
        if (angle < 0.7853981633974483) {
            return (double[])hl.get(0);
        }
        if (angle < 2.356194490192345) {
            return (double[])hl.get(1);
        }
        return (double[])hl.get(2);
    }

    public void setSelected(boolean b) {
        this.selected = b;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void addEdge(PNGUIEdge e) {
        this.edges.add(e);
    }

    public int getEdgesCount() {
        return this.edges.size();
    }

    public PNGUIEdge getEdge(int index) {
        return this.edges.get(index);
    }

    public void removeEdge(PNGUIEdge e) {
        this.edges.remove(e);
    }

    public void removeEdge(int index) {
        this.edges.remove(index);
    }

    public PNGUIText getBasicText() {
        return this.name;
    }

    public PNGUIText getAdvancedText() {
        return this.advText;
    }
}

