/*
 * Decompiled with CFR 0.152.
 */
package pn.gui;

import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import pn.gui.PNGUIVertex;
import pn.logic.IPNLTransition;

public class PNGUITransition
extends PNGUIVertex {
    private Rectangle2D rect;
    private IPNLTransition pnlSelf;
    private boolean fireable;
    private boolean highlighted;

    public PNGUITransition(IPNLTransition pnlTransition) {
        this.pnlSelf = pnlTransition;
        this.fireable = false;
        this.highlighted = false;
        this.customColor = new Color(0xFFFFFF);
    }

    public Rectangle2D getRect() {
        if (this.rect == null) {
            this.rect = new Rectangle2D.Double();
        }
        return this.rect;
    }

    @Override
    public boolean setBounds(double x, double y, double width, double height) {
        if (this.rect == null) {
            this.rect = new Rectangle2D.Double();
        }
        if (super.setBounds(x, y, width, height)) {
            this.rect.setFrame(x, y, width, height);
            this.setHandles();
            return true;
        }
        return false;
    }

    public boolean setBounds(double x, double y) {
        if (this.rect == null) {
            this.rect = new Rectangle2D.Double();
        }
        if (super.setBounds(x, y, 30.0, 30.0)) {
            this.rect.setFrame(x, y, 30.0, 30.0);
            this.setHandles();
            return true;
        }
        return false;
    }

    @Override
    public void translate(double dx, double dy) {
        super.translate(dx, dy);
    }

    @Override
    public boolean intersects(Rectangle2D aBounds) {
        return this.getRect().intersects(aBounds);
    }

    @Override
    public void paint(PPaintContext aPaintContext) {
        if (this.selected) {
            this.setPaint(new Color(0xBBBBFF));
        } else {
            this.setPaint(this.customColor);
        }
        Graphics2D g2 = aPaintContext.getGraphics();
        g2.setStroke(new BasicStroke(3.0f));
        if (this.highlighted) {
            this.setPaint(new Color(0xCC9900));
        }
        g2.setColor((Color)this.getPaint());
        if (this.fireable) {
            if (!this.highlighted) {
                g2.setColor(new Color(51200));
            }
            g2.fill(this.getRect());
            g2.setColor(new Color(38400));
        } else {
            g2.fill(this.getRect());
            g2.setColor(new Color(0x969696));
        }
        g2.drawRect((int)this.getRect().getX(), (int)this.getRect().getY(), (int)this.getRect().getWidth(), (int)this.getRect().getHeight());
    }

    public void setHighlighted(boolean b) {
        this.highlighted = b;
    }

    public void setFireable(boolean b) {
        this.fireable = b;
    }

    public IPNLTransition getPNLSelf() {
        return this.pnlSelf;
    }
}

