/*
 * Decompiled with CFR 0.152.
 */
package pn.gui;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import pn.Editor;
import pn.util.Constants;

public class PNGUIToolBar
extends JPanel {
    private static final int TOOL_BUTTON_LEFT = 0;
    private static final int TOOL_BUTTON_TOP = 0;
    private static final int TOOL_BUTTON_SPACE = 1;
    private static final int TOOL_BUTTON_WIDTH = 28;
    private static final int TOOL_BUTTON_HEIGHT = 28;
    private static final String HELP_ADD_PLACE = "Adding place";
    private static final String HELP_ADD_TRANSITION = "Adding transition";
    private static final String HELP_ADD_EDGE = "Adding edge";
    private static final String HELP_DELETE = "Deleting place/transition/edge";
    private static final String HELP_SCROLL = "Moving canvas without changing offsets. Or hold middle mouse button to move.";
    private JTextField helpBar = null;
    private boolean isHorizontal;
    private Editor editor;

    public PNGUIToolBar(int left, int top, int width, int height, boolean isHorizontal, Editor editor) {
        this.isHorizontal = isHorizontal;
        this.setLayout(null);
        this.setBounds(left, top, width, height);
        this.createButtons();
        this.editor = editor;
    }

    public void setHelpBar(JTextField c) {
        this.helpBar = c;
    }

    private void createButtons() {
        JToggleButton button = new JToggleButton();
        if (this.isHorizontal) {
            button.setBounds(this.getComponentCount() * 29 + 0, 0, 28, 28);
        } else {
            button.setBounds(0, this.getComponentCount() * 29 + 0, 28, 28);
        }
        button.setIcon(new ImageIcon(ClassLoader.getSystemResource("pn/gui/icons/place.png")));
        button.addMouseListener(new MouseAdapter(){
            private final int index;
            {
                this.index = PNGUIToolBar.this.getComponentCount();
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                PNGUIToolBar.this.switchButtons(this.index);
                if (!((JToggleButton)evt.getSource()).isSelected()) {
                    PNGUIToolBar.this.helpBar.setText("");
                }
            }
        });
        button.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 27: {
                        PNGUIToolBar.this.deselectAll();
                    }
                }
            }
        });
        button.setToolTipText("Add place");
        this.add(button);
        button = new JToggleButton();
        if (this.isHorizontal) {
            button.setBounds(this.getComponentCount() * 29 + 0, 0, 28, 28);
        } else {
            button.setBounds(0, this.getComponentCount() * 29 + 0, 28, 28);
        }
        button.setIcon(new ImageIcon(ClassLoader.getSystemResource("pn/gui/icons/transition.png")));
        button.addMouseListener(new MouseAdapter(){
            private final int index;
            {
                this.index = PNGUIToolBar.this.getComponentCount();
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                PNGUIToolBar.this.switchButtons(this.index);
                if (!((JToggleButton)evt.getSource()).isSelected()) {
                    PNGUIToolBar.this.helpBar.setText("");
                }
            }
        });
        button.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 27: {
                        PNGUIToolBar.this.deselectAll();
                    }
                }
            }
        });
        button.setToolTipText("Add transition");
        this.add(button);
        button = new JToggleButton();
        if (this.isHorizontal) {
            button.setBounds(this.getComponentCount() * 29 + 0, 0, 28, 28);
        } else {
            button.setBounds(0, this.getComponentCount() * 29 + 0, 28, 28);
        }
        button.setIcon(new ImageIcon(ClassLoader.getSystemResource("pn/gui/icons/edge.png")));
        button.addMouseListener(new MouseAdapter(){
            private final int index;
            {
                this.index = PNGUIToolBar.this.getComponentCount();
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                PNGUIToolBar.this.switchButtons(this.index);
                if (!((JToggleButton)evt.getSource()).isSelected()) {
                    PNGUIToolBar.this.helpBar.setText("");
                }
            }
        });
        button.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 27: {
                        PNGUIToolBar.this.deselectAll();
                    }
                }
            }
        });
        button.setToolTipText("Add edge");
        this.add(button);
        button = new JToggleButton();
        if (this.isHorizontal) {
            button.setBounds(this.getComponentCount() * 29 + 0, 0, 28, 28);
        } else {
            button.setBounds(0, this.getComponentCount() * 29 + 0, 28, 28);
        }
        button.setIcon(new ImageIcon(ClassLoader.getSystemResource("pn/gui/icons/delete.png")));
        button.addMouseListener(new MouseAdapter(){
            private final int index;
            {
                this.index = PNGUIToolBar.this.getComponentCount();
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                PNGUIToolBar.this.switchButtons(this.index);
                if (!((JToggleButton)evt.getSource()).isSelected()) {
                    PNGUIToolBar.this.helpBar.setText("");
                }
            }
        });
        button.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 27: {
                        PNGUIToolBar.this.deselectAll();
                    }
                }
            }
        });
        button.setToolTipText("Delete place/transition/edge");
        this.add(button);
    }

    public void deselectAll() {
        int i = 0;
        while (i < this.getComponentCount()) {
            ((JToggleButton)this.getComponent(i)).setSelected(false);
            ++i;
        }
    }

    private void switchButtons(int active) {
        this.editor.getPNGUICanvasClickHandler().removeAll();
        if (this.helpBar != null) {
            this.helpBar.setText("");
        }
        int i = 0;
        while (i < this.getComponentCount()) {
            if (i != active) {
                ((JToggleButton)this.getComponent(i)).setSelected(false);
            }
            ++i;
        }
    }

    public Constants.AddEntity getEntityToAdd() {
        if (((JToggleButton)this.getComponent(0)).isSelected()) {
            return Constants.AddEntity.PLACE;
        }
        if (((JToggleButton)this.getComponent(1)).isSelected()) {
            return Constants.AddEntity.TRANSITION;
        }
        if (((JToggleButton)this.getComponent(2)).isSelected()) {
            return Constants.AddEntity.EDGE;
        }
        return null;
    }

    public boolean delete() {
        return ((JToggleButton)this.getComponent(3)).isSelected();
    }

    public boolean addedge() {
        return ((JToggleButton)this.getComponent(2)).isSelected();
    }

    @Override
    public void setEnabled(boolean e) {
        super.setEnabled(e);
        int i = 0;
        while (i < this.getComponentCount()) {
            this.getComponent(i).setEnabled(e);
            ++i;
        }
    }
}

