/*
 * Decompiled with CFR 0.152.
 */
package pn.gui;

import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import pn.gui.PNGUIVertex;
import pn.logic.IPNLPlace;

public class PNGUIPlace
extends PNGUIVertex {
    private Ellipse2D ellipse;
    private IPNLPlace pnlSelf;

    public PNGUIPlace(IPNLPlace pnlPlace) {
        this.pnlSelf = pnlPlace;
        this.customColor = new Color(0xFFFFFF);
    }

    public Ellipse2D getEllipse() {
        if (this.ellipse == null) {
            this.ellipse = new Ellipse2D.Double();
        }
        return this.ellipse;
    }

    @Override
    public boolean setBounds(double x, double y, double width, double height) {
        if (this.ellipse == null) {
            this.ellipse = new Ellipse2D.Double();
        }
        if (super.setBounds(x, y, width, height)) {
            this.ellipse.setFrame(x, y, width, height);
            this.setHandles();
            return true;
        }
        return false;
    }

    public boolean setBounds(double x, double y) {
        if (this.ellipse == null) {
            this.ellipse = new Ellipse2D.Double();
        }
        if (super.setBounds(x, y, 30.0, 30.0)) {
            this.ellipse.setFrame(x, y, 30.0, 30.0);
            this.setHandles();
            return true;
        }
        return false;
    }

    @Override
    public boolean intersects(Rectangle2D aBounds) {
        return this.getEllipse().intersects(aBounds);
    }

    @Override
    public void translate(double dx, double dy) {
        System.out.println("aaa");
        super.translate(dx, dy);
    }

    @Override
    public void paint(PPaintContext aPaintContext) {
        if (this.selected) {
            this.setPaint(new Color(0xBBBBFF));
        } else {
            this.setPaint(this.customColor);
        }
        Graphics2D g2 = aPaintContext.getGraphics();
        g2.setStroke(new BasicStroke(3.0f));
        g2.setColor((Color)this.getPaint());
        g2.fill(this.getEllipse());
        g2.setColor(new Color(0x969696));
        g2.drawArc((int)this.getEllipse().getX(), (int)this.getEllipse().getY(), (int)this.getEllipse().getWidth(), (int)this.getEllipse().getHeight(), 0, 360);
        g2.setColor(new Color(0, 0, 0));
        g2.drawString(String.valueOf(this.getPNLSelf().getTokens()), (float)(this.getEllipse().getCenterX() - 5.0), (float)(this.getEllipse().getCenterY() + 2.0));
    }

    public IPNLPlace getPNLSelf() {
        return this.pnlSelf;
    }
}

