/*
 * Decompiled with CFR 0.152.
 */
package pn.gui;

import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.Container;
import java.util.ArrayList;
import javax.swing.JLabel;
import pn.Editor;
import pn.MainFrame;
import pn.gui.PNGUICanvasClickHandler;
import pn.gui.PNGUICanvasKeyHandler;
import pn.gui.PNGUIEdge;
import pn.gui.PNGUIPlace;
import pn.gui.PNGUITransition;
import pn.gui.PNGUIVertex;
import pn.gui.PNSelectionEventHandler;
import pn.logic.PNLEdge;
import pn.logic.PNLPetriNet;
import pn.simulation.Simulator;

public class PNGUIPanel
extends PCanvas {
    private float offsetX = 0.0f;
    private float offsetY = 0.0f;
    private boolean isAllShown;
    private boolean level1Texts;
    private boolean level2Texts;
    private JLabel popupInfo = new JLabel("");
    private MainFrame mainFrame;
    private boolean isInSimulation = false;
    private PNSelectionEventHandler selectionEventHandler;

    public PNGUIPanel() {
        this.add(this.popupInfo);
        this.removeKeyListener(this.getKeyListeners()[0]);
        this.addKeyListener(new PNGUICanvasKeyHandler(this));
        this.removeInputEventListener(this.getPanEventHandler());
        this.selectionEventHandler = new PNSelectionEventHandler((PNode)this.getLayer(), this.getLayer());
        this.addInputEventListener(this.selectionEventHandler);
        this.getRoot().getDefaultInputManager().setKeyboardFocus(this.selectionEventHandler);
    }

    public void setEdited(boolean b) {
        this.mainFrame.setEdited(b);
    }

    public boolean isSelectedAnything() {
        return this.selectionEventHandler.getSelectionReference().size() > 0;
    }

    public boolean isSelected(PNode n) {
        return this.selectionEventHandler.getSelection().contains(n);
    }

    public void forceUnselectAll() {
        this.selectionEventHandler.unselectAll();
    }

    public void forceSelectNode(PNode n, Boolean unselectall) {
        if (unselectall.booleanValue()) {
            this.selectionEventHandler.unselectAll();
        }
        this.selectionEventHandler.select(n);
    }

    public void setMainFrame(MainFrame mf) {
        this.mainFrame = mf;
    }

    public MainFrame getMainFrame() {
        return this.mainFrame;
    }

    public void setPopupInfo(String s, int x, int y, int width, int height) {
        this.remove(this.popupInfo);
        this.popupInfo = new JLabel(s);
        this.popupInfo.setBounds(x - (int)this.getBounds().getX(), y - (int)this.getBounds().getY() + 20, width, height);
        this.add(this.popupInfo);
        this.repaint();
    }

    public void hidePopupInfo() {
        this.remove(this.popupInfo);
        this.popupInfo = new JLabel("");
        this.add(this.popupInfo);
        this.repaint();
    }

    public void setLevel1Shown(boolean b) {
        this.level1Texts = b;
        int i = 0;
        while (i < this.getLayer().getChildrenCount()) {
            if (this.getLayer().getChild(i) instanceof PNGUIEdge) {
                if (b) {
                    ((PNGUIEdge)this.getLayer().getChild(i)).showTexts();
                } else {
                    ((PNGUIEdge)this.getLayer().getChild(i)).hideTexts();
                    ((PNGUIEdge)this.getLayer().getChild(i)).hideKnots();
                }
            }
            if (this.getLayer().getChild(i) instanceof PNGUIVertex) {
                if (b) {
                    ((PNGUIVertex)this.getLayer().getChild(i)).showTexts();
                } else {
                    ((PNGUIVertex)this.getLayer().getChild(i)).hideTexts();
                }
            }
            ++i;
        }
    }

    public void setLevel2Shown(boolean b) {
        this.level2Texts = b;
        int i = 0;
        while (i < this.getLayer().getChildrenCount()) {
            if (this.getLayer().getChild(i) instanceof PNGUIEdge) {
                if (b) {
                    ((PNGUIEdge)this.getLayer().getChild(i)).showAdvancedTexts();
                } else {
                    ((PNGUIEdge)this.getLayer().getChild(i)).hideAdvancedTexts();
                    ((PNGUIEdge)this.getLayer().getChild(i)).hideKnots();
                }
            }
            if (this.getLayer().getChild(i) instanceof PNGUIVertex) {
                if (b) {
                    ((PNGUIVertex)this.getLayer().getChild(i)).showAdvancedTexts();
                } else {
                    ((PNGUIVertex)this.getLayer().getChild(i)).hideAdvancedTexts();
                }
            }
            ++i;
        }
    }

    public boolean isLevel1Shown() {
        return this.level1Texts;
    }

    public boolean isLevel2Shown() {
        return this.level2Texts;
    }

    public void addChild(PNode child) {
        this.getLayer().addChild(child);
    }

    public void removeChild(PNode child) {
        if (child != null) {
            this.getLayer().removeChild(child);
        }
    }

    public void startSimulation(Simulator sim) {
        this.isInSimulation = true;
        int i = 0;
        while (i < this.getMouseListeners().length) {
            if (this.getMouseListeners()[i] instanceof PNGUICanvasClickHandler) {
                ((PNGUICanvasClickHandler)this.getMouseListeners()[i]).startSimulation(sim);
                break;
            }
            ++i;
        }
    }

    public void stopSimulation() {
        this.isInSimulation = false;
        int i = 0;
        while (i < this.getMouseListeners().length) {
            if (this.getMouseListeners()[i] instanceof PNGUICanvasClickHandler) {
                ((PNGUICanvasClickHandler)this.getMouseListeners()[i]).stopSimulation();
                break;
            }
            ++i;
        }
    }

    public boolean isSimulating() {
        return this.isInSimulation;
    }

    public void translateBy(float dx, float dy) {
        this.offsetX += dx;
        this.offsetY += dy;
    }

    public float getOffsetX() {
        return this.offsetX;
    }

    public float getOffsetY() {
        return this.offsetY;
    }

    public PNode getChildByPos(float x, float y) {
        int i = 0;
        while (i < this.getLayer().getChildrenCount()) {
            if (!(this.getLayer().getChild(i) instanceof PNGUIEdge) && this.getLayer().getChild(i).getFullBounds().getX() < (double)x && this.getLayer().getChild(i).getFullBounds().getY() < (double)y && this.getLayer().getChild(i).getFullBounds().getX() + this.getLayer().getChild(i).getFullBounds().getWidth() > (double)x && this.getLayer().getChild(i).getFullBounds().getY() + this.getLayer().getChild(i).getFullBounds().getHeight() > (double)y) {
                return this.getLayer().getChild(i);
            }
            ++i;
        }
        return null;
    }

    public PNode getChildByPosIncludeEdges(float x, float y) {
        int i = 0;
        while (i < this.getLayer().getChildrenCount()) {
            if (this.getLayer().getChild(i).intersects(new PBounds(x, y, 1.0, 1.0))) {
                return this.getLayer().getChild(i);
            }
            ++i;
        }
        return null;
    }

    public void repaintEdges(PNode node) {
        int i = 0;
        while (i < this.getLayer().getChildrenCount()) {
            if (this.getLayer().getChild(i) instanceof PNGUIEdge && (((PNGUIEdge)this.getLayer().getChild(i)).getNode1() == node || ((PNGUIEdge)this.getLayer().getChild(i)).getNode2() == node)) {
                ((PNGUIEdge)this.getLayer().getChild(i)).repaint();
            }
            ++i;
        }
    }

    public void repaintAll() {
        this.getLayer().repaint();
        int i = 0;
        while (i < this.getLayer().getChildrenCount()) {
            if (this.getLayer().getChild(i) instanceof PNGUIPlace) {
                this.getLayer().getChild(i).moveToFront();
            }
            if (this.getLayer().getChild(i) instanceof PNGUITransition) {
                this.getLayer().getChild(i).moveToFront();
            }
            ++i;
        }
    }

    public void hideAllKnots() {
        int i = 0;
        while (i < this.getLayer().getChildrenCount()) {
            if (this.getLayer().getChild(i) instanceof PNGUIEdge) {
                ((PNGUIEdge)this.getLayer().getChild(i)).hideKnots();
            }
            ++i;
        }
    }

    public ArrayList<PNode> getSelected() {
        return new ArrayList<PNode>(this.selectionEventHandler.getSelection());
    }

    public ArrayList<PNode> getSelectedChildrenRef() {
        return new ArrayList<PNode>(this.selectionEventHandler.getSelectionReference());
    }

    public void deleteSelectedChildren() {
        ArrayList nodes = new ArrayList(this.selectionEventHandler.getSelectionReference());
        Container o = this.getParent();
        int counter = 0;
        do {
            o = o.getParent();
            if (++counter != 10) continue;
            return;
        } while (!(o instanceof Editor));
        PNLPetriNet pn = ((Editor)o).getPetriNet();
        int i = 0;
        while (i < nodes.size()) {
            ArrayList<PNLEdge> edges = pn.getEdges();
            if (nodes.get(i) instanceof PNGUIVertex) {
                int j = 0;
                while (j < edges.size()) {
                    if (edges.get(j).getGrEdge().getNode1().equals(nodes.get(i))) {
                        pn.removeEdge(j);
                        --j;
                    }
                    ++j;
                }
                if (nodes.get(i) instanceof PNGUIPlace) {
                    pn.removeVertex(((PNGUIPlace)nodes.get(i)).getPNLSelf());
                }
                if (nodes.get(i) instanceof PNGUITransition) {
                    pn.removeVertex(((PNGUITransition)nodes.get(i)).getPNLSelf());
                }
            }
            ++i;
        }
    }
}

