/*
 * Decompiled with CFR 0.152.
 */
package pn.gui;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import pn.gui.PNBasicInputEventHandler;
import pn.gui.PNGUIEdge;
import pn.gui.PNGUIPanel;

public class PNGUIKnot
extends PNode {
    private Rectangle2D rect;
    private double trueX;
    private double trueY;
    private boolean isVisible;
    private PNGUIEdge edge;

    public PNGUIKnot(float x, float y, Object parent) {
        this.setBounds(x, y);
        this.addInputEventListener(new KnotInputEventHandler(this, parent));
        this.isVisible = true;
    }

    public void setOwnerEdge(PNGUIEdge e) {
        this.edge = e;
    }

    public PNGUIEdge getOwnerEdge() {
        return this.edge;
    }

    public int getIntX() {
        return (int)this.getGlobalBounds().getCenter2D().getX();
    }

    public int getIntY() {
        return (int)this.getGlobalBounds().getCenter2D().getY();
    }

    public double getTrueX() {
        return this.trueX;
    }

    public double getTrueY() {
        return this.trueY;
    }

    public Rectangle2D getRect() {
        if (this.rect == null) {
            this.rect = new Rectangle2D.Double();
        }
        return this.rect;
    }

    @Override
    public void setVisible(boolean vis) {
        this.isVisible = vis;
    }

    @Override
    public boolean setBounds(double x, double y, double width, double height) {
        if (this.rect == null) {
            this.rect = new Rectangle2D.Double();
        }
        this.trueX = x + width / 2.0;
        this.trueY = y + height / 2.0;
        if (super.setBounds(x, y, width, height)) {
            this.rect.setFrame(x, y, width, height);
            return true;
        }
        return false;
    }

    public boolean setBounds(double x, double y) {
        if (this.rect == null) {
            this.rect = new Rectangle2D.Double();
        }
        this.trueX = x;
        this.trueY = y;
        if (super.setBounds(x - 2.0, y - 2.0, 5.0, 5.0)) {
            this.rect.setFrame(x - 2.0, y - 2.0, 5.0, 5.0);
            return true;
        }
        return false;
    }

    @Override
    public boolean intersects(Rectangle2D aBounds) {
        return this.getRect().intersects(aBounds);
    }

    @Override
    public void paint(PPaintContext aPaintContext) {
        if (this.isVisible) {
            if (this.getPaint() == null) {
                this.setPaint(new Color(0, 0, 0));
            }
            Graphics2D g2 = aPaintContext.getGraphics();
            g2.setColor((Color)this.getPaint());
            g2.fill(this.getRect());
        }
    }

    private class KnotInputEventHandler
    extends PNBasicInputEventHandler {
        public KnotInputEventHandler(PNode n, Object parent) {
            super(n, parent);
        }

        @Override
        public void mouseMoved(PInputEvent aEvent) {
            this.node.setBounds(((PNGUIKnot)this.node).getTrueX() - 5.0, ((PNGUIKnot)this.node).getTrueY() - 5.0, 10.0, 10.0);
            if (this.parent instanceof PNGUIPanel) {
                ((PNGUIPanel)this.parent).repaint();
            }
            aEvent.setHandled(true);
        }

        @Override
        public void mouseDragged(PInputEvent aEvent) {
            ((PNGUIKnot)this.node).getOwnerEdge().setIsBeingEdited(true);
            PBounds bounds1 = ((PNGUIKnot)this.node).getOwnerEdge().getFullBounds();
            PDimension delta = aEvent.getDeltaRelativeTo(this.node);
            this.node.translate(((Dimension2D)delta).getWidth(), ((Dimension2D)delta).getHeight());
            PBounds bounds2 = ((PNGUIKnot)this.node).getOwnerEdge().getFullBounds();
            double xratio = (((PNGUIKnot)this.node).getOwnerEdge().getBasicText().getX() - bounds1.getX()) / bounds1.getWidth();
            double yratio = (((PNGUIKnot)this.node).getOwnerEdge().getBasicText().getY() - bounds1.getY()) / bounds1.getHeight();
            ((PNGUIKnot)this.node).getOwnerEdge().getBasicText().setX(bounds2.getWidth() * xratio + bounds2.getX());
            ((PNGUIKnot)this.node).getOwnerEdge().getBasicText().setY(bounds2.getHeight() * yratio + bounds2.getY());
            ((PNGUIKnot)this.node).getOwnerEdge().getAdvancedText().setX(((PNGUIKnot)this.node).getOwnerEdge().getBasicText().getX());
            ((PNGUIKnot)this.node).getOwnerEdge().getAdvancedText().setY(((PNGUIKnot)this.node).getOwnerEdge().getBasicText().getY() + 20.0);
        }

        @Override
        public void mouseExited(PInputEvent aEvent) {
            ((PNGUIKnot)this.node).setBounds(((PNGUIKnot)this.node).getTrueX(), ((PNGUIKnot)this.node).getTrueY());
            if (this.parent instanceof PNGUIPanel) {
                ((PNGUIPanel)this.parent).repaint();
            }
            aEvent.setHandled(true);
        }
    }
}

