/*
 * Decompiled with CFR 0.152.
 */
package pn.gui;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import pn.gui.Arrow;
import pn.gui.PNGUIKnot;
import pn.gui.PNGUIText;
import pn.gui.PNGUIVertex;
import pn.logic.PNLEdge;

public class PNGUIEdge
extends PPath {
    protected PNGUIVertex node1;
    protected PNGUIVertex node2;
    protected PNGUIText count;
    protected double countPosXRatio;
    protected double countPosYRatio;
    protected PNLEdge pnlSelf;
    protected boolean isBezierPainted;
    protected boolean showTexts;
    protected boolean showAdvTexts;
    protected PNGUIText advText;
    protected boolean beingEdited = true;
    protected boolean autoTurnOff = true;

    public PNGUIEdge(PNGUIVertex node1, PNGUIVertex node2, PNLEdge pnlEdge) {
        this.node1 = node1;
        this.node2 = node2;
        this.node1.addEdge(this);
        this.node2.addEdge(this);
        this.setStroke(new BasicStroke(1.0f));
        this.pnlSelf = pnlEdge;
        this.isBezierPainted = true;
        this.addChild(new Arrow(node1.getClosestPort(this.node2.getGlobalBounds().getCenterX(), this.node2.getGlobalBounds().getCenterY()), node2.getClosestPort(this.node1.getGlobalBounds().getCenterX(), this.node1.getGlobalBounds().getCenterY())));
        this.count = new PNGUIText(this);
        this.count.setBounds(this.getCenter()[0], this.getCenter()[1], 100.0, 30.0);
        this.countPosXRatio = 0.5;
        this.countPosYRatio = 0.5;
        this.addChild(this.count);
        this.showTexts = true;
        this.showAdvTexts = true;
        this.advText = new PNGUIText(this);
        this.advText.setBounds(this.getCenter()[0], this.getCenter()[1] + 20.0, 100.0, 30.0);
        this.addChild(this.advText);
    }

    public boolean isBeingEdited() {
        return this.beingEdited;
    }

    public void setIsBeingEditedDontAutoTurnOff(boolean b) {
        this.autoTurnOff = !b;
        this.beingEdited = b;
    }

    public void setIsBeingEdited(boolean b) {
        this.beingEdited = b;
    }

    public GeneralPath getPath() {
        return this.getPathReference();
    }

    public PNode getNode1() {
        return this.node1;
    }

    public PNode getNode2() {
        return this.node2;
    }

    @Override
    public boolean setBounds(double x1, double y1, double x2, double y2) {
        return super.setBounds(x1, y1, x2, y2);
    }

    @Override
    public boolean intersects(Rectangle2D aBounds) {
        aBounds.setRect(aBounds.getX(), aBounds.getY(), 4.0, 4.0);
        float[] coords1 = new float[6];
        float[] coords2 = new float[6];
        GeneralPath segment = new GeneralPath();
        PathIterator pathIterator = this.getPath().getPathIterator(null);
        while (!pathIterator.isDone()) {
            pathIterator.currentSegment(coords1);
            pathIterator.next();
            if (!pathIterator.isDone()) {
                pathIterator.currentSegment(coords2);
                segment.moveTo(coords1[0], coords1[1]);
                segment.lineTo(coords2[0], coords2[1]);
                if (segment.intersects(aBounds)) {
                    return true;
                }
                pathIterator.next();
            }
            segment.reset();
        }
        return false;
    }

    @Override
    public void paint(PPaintContext aPaintContext) {
        if (this.getPaint() == null) {
            this.setPaint(Color.BLACK);
        }
        if (this.beingEdited) {
            this.reset();
            if (this.isBezierPainted) {
                this.bezierPaint(20);
            } else {
                this.normalPaint();
            }
            if (this.autoTurnOff) {
                this.beingEdited = false;
            }
        }
        Graphics2D g2 = aPaintContext.getGraphics();
        g2.setStroke(this.getStroke());
        g2.setColor((Color)this.getPaint());
        g2.draw(this.getPathReference());
    }

    private void normalPaint() {
        this.moveTo((float)this.node1.getClosestPort(this.node2.getGlobalBounds().getCenterX(), this.node2.getGlobalBounds().getCenterY())[0], (float)this.node1.getClosestPort(this.node2.getGlobalBounds().getCenterX(), this.node2.getGlobalBounds().getCenterY())[1]);
        int i = 0;
        while (i < this.getKnotCount()) {
            this.lineTo((float)this.getKnot(i).getGlobalBounds().getCenter2D().getX(), (float)this.getKnot(i).getGlobalBounds().getCenter2D().getY());
            ++i;
        }
        this.lineTo((float)this.node2.getClosestPort(this.node1.getGlobalBounds().getCenterX(), this.node1.getGlobalBounds().getCenterY())[0], (float)this.node2.getClosestPort(this.node1.getGlobalBounds().getCenterX(), this.node1.getGlobalBounds().getCenterY())[1]);
        double[] x1 = this.getKnotCount() > 0 ? new double[]{this.getKnot(this.getKnotCount() - 1).getGlobalBounds().getCenter2D().getX(), this.getKnot(this.getKnotCount() - 1).getGlobalBounds().getCenter2D().getY()} : new double[]{this.node1.getClosestPort(this.node2.getGlobalBounds().getCenterX(), this.node2.getGlobalBounds().getCenterY())[0], this.node1.getClosestPort(this.node2.getGlobalBounds().getCenterX(), this.node2.getGlobalBounds().getCenterY())[1]};
        double[] x2 = new double[]{this.node2.getClosestPort(this.node1.getGlobalBounds().getCenterX(), this.node1.getGlobalBounds().getCenterY())[0], this.node2.getClosestPort(this.node1.getGlobalBounds().getCenterX(), this.node1.getGlobalBounds().getCenterY())[1]};
        this.getArrow().calculatePoints(x1, x2);
    }

    private void bezierPaint(int resolution) {
        double[] x1 = null;
        double[] x2 = null;
        int n = this.getKnotCount() + 1;
        float t = 0.0f;
        if (n == 1) {
            this.normalPaint();
            return;
        }
        int j = 0;
        while (j <= resolution) {
            float[] closestPortNode1 = new float[]{(float)this.node1.getClosestPort(this.getKnot(0).getGlobalBounds().getCenter2D().getX(), this.getKnot(0).getGlobalBounds().getCenter2D().getY())[0], (float)this.node1.getClosestPort(this.getKnot(0).getGlobalBounds().getCenter2D().getX(), this.getKnot(0).getGlobalBounds().getCenter2D().getY())[1]};
            float[] closestPortNode2 = new float[]{(float)this.node2.getClosestPort(this.getKnot(this.getKnotCount() - 1).getGlobalBounds().getCenter2D().getX(), this.getKnot(this.getKnotCount() - 1).getGlobalBounds().getCenter2D().getY())[0], (float)this.node2.getClosestPort(this.getKnot(this.getKnotCount() - 1).getGlobalBounds().getCenter2D().getX(), this.getKnot(this.getKnotCount() - 1).getGlobalBounds().getCenter2D().getY())[1]};
            float x = closestPortNode1[0] * (float)Math.pow(1.0f - t, n);
            float y = closestPortNode1[1] * (float)Math.pow(1.0f - t, n);
            int i = 1;
            while (i < n) {
                x = (float)((double)x + this.getKnot(i - 1).getGlobalBounds().getCenter2D().getX() * (double)this.combNumber(n, i) * (double)((float)Math.pow(1.0f - t, n - i)) * (double)((float)Math.pow(t, i)));
                y = (float)((double)y + this.getKnot(i - 1).getGlobalBounds().getCenter2D().getY() * (double)this.combNumber(n, i) * (double)((float)Math.pow(1.0f - t, n - i)) * (double)((float)Math.pow(t, i)));
                ++i;
            }
            x += closestPortNode2[0] * (float)Math.pow(t, n);
            y += closestPortNode2[1] * (float)Math.pow(t, n);
            if (j == 0) {
                this.moveTo(x, y);
            } else {
                this.lineTo(x, y);
            }
            t += 1.0f / (float)resolution;
            if (j == resolution - 1) {
                x1 = new double[]{x, y};
            }
            if (j == resolution) {
                x2 = new double[]{x, y};
            }
            ++j;
        }
        this.getArrow().calculatePoints(x1, x2);
    }

    private int combNumber(int n, int k) {
        return (int)(this.factorial(n) / (this.factorial(n - k) * this.factorial(k)));
    }

    private long factorial(int n) {
        if (n <= 0) {
            return 0L;
        }
        if (n < 2) {
            return 1L;
        }
        long a = 1L;
        int i = 2;
        while (i <= n) {
            a *= (long)i;
            ++i;
        }
        return a;
    }

    public PNLEdge getPNLSelf() {
        return this.pnlSelf;
    }

    public void addKnot(PNGUIKnot knot) {
        knot.setOwnerEdge(this);
        this.addChild(knot);
    }

    public void addKnots(ArrayList<PNGUIKnot> knots) {
        int i = 0;
        while (i < knots.size()) {
            knots.get(i).setOwnerEdge(this);
            ++i;
        }
        i = 0;
        while (i < knots.size()) {
            this.addChild(knots.get(i));
            ++i;
        }
    }

    public void replaceKnots(ArrayList<PNGUIKnot> knots) {
        this.removeAllKnots();
        if (knots == null) {
            return;
        }
        this.addKnots(knots);
    }

    public void removeAllKnots() {
        int i = this.getChildrenCount() - 1;
        while (i >= 0) {
            if (this.getChild(i) instanceof PNGUIKnot) {
                this.removeChild(i);
            }
            --i;
        }
    }

    public int getKnotCount() {
        int count = 0;
        int i = 0;
        while (i < this.getChildrenCount()) {
            if (this.getChild(i) instanceof PNGUIKnot) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public PNGUIKnot getKnot(int index) {
        int count = 0;
        int i = 0;
        while (i < this.getChildrenCount()) {
            if (this.getChild(i) instanceof PNGUIKnot) {
                if (count == index) break;
                ++count;
            }
            ++i;
        }
        return (PNGUIKnot)this.getChild(i);
    }

    public void hideKnots() {
        int i = 0;
        while (i < this.getChildrenCount()) {
            if (this.getChild(i) instanceof PNGUIKnot) {
                ((PNGUIKnot)this.getChild(i)).setVisible(false);
            }
            ++i;
        }
    }

    public void showKnots() {
        int i = 0;
        while (i < this.getChildrenCount()) {
            if (this.getChild(i) instanceof PNGUIKnot) {
                ((PNGUIKnot)this.getChild(i)).setVisible(true);
            }
            ++i;
        }
    }

    public double[] getCenter() {
        return new double[]{(this.node1.getGlobalBounds().getCenterX() + this.node2.getGlobalBounds().getCenterX()) / 2.0, (this.node1.getGlobalBounds().getCenterY() + this.node2.getGlobalBounds().getCenterY()) / 2.0};
    }

    public void showTexts() {
        this.showTexts = true;
        int i = 0;
        while (i < this.getChildrenCount()) {
            if (this.getChild(i) instanceof PNGUIText && !this.getChild(i).equals(this.advText)) {
                this.getChild(i).setVisible(true);
            }
            ++i;
        }
    }

    public void hideTexts() {
        this.showTexts = false;
        int i = 0;
        while (i < this.getChildrenCount()) {
            if (this.getChild(i) instanceof PNGUIText && !this.getChild(i).equals(this.advText)) {
                this.getChild(i).setVisible(false);
            }
            ++i;
        }
    }

    public void setAdvancedTexts(String text) {
        this.advText.setText(text);
        this.advText.repaint();
    }

    public void showAdvancedTexts() {
        this.showAdvTexts = true;
        this.advText.setVisible(true);
    }

    public void hideAdvancedTexts() {
        this.showAdvTexts = false;
        this.advText.setVisible(false);
    }

    public void setBasicTexts(String text) {
        this.count.setText(text);
        this.count.repaint();
    }

    public int getCount() {
        if (this.count != null) {
            return Integer.parseInt(this.count.getText());
        }
        return 0;
    }

    public void setCount(int i) {
        this.count.setText(String.valueOf(i));
        this.count.repaint();
    }

    public void setCountPosition(float x, float y) {
        this.count.setBounds(this.getCenter()[0] + (double)x, this.getCenter()[1] + (double)y, 100.0, 30.0);
        this.advText.setBounds(this.getCenter()[0] + (double)x, this.getCenter()[1] + (double)y + 20.0, 100.0, 30.0);
    }

    public int getCountPosX() {
        return (int)this.count.getGlobalBounds().getX() - (int)this.getCenter()[0];
    }

    public int getCountPosY() {
        return (int)this.count.getGlobalBounds().getY() - (int)this.getCenter()[1];
    }

    private Arrow getArrow() {
        int i = 0;
        while (i < this.getChildrenCount()) {
            if (this.getChild(i) instanceof Arrow) {
                return (Arrow)this.getChild(i);
            }
            ++i;
        }
        return null;
    }

    public PNGUIText getBasicText() {
        return this.count;
    }

    public PNGUIText getAdvancedText() {
        return this.advText;
    }

    public void setBezierPaintStyle(boolean b) {
        this.isBezierPainted = b;
    }

    public PNode getChildByPos(float x, float y) {
        int i = 0;
        while (i < this.getChildrenCount()) {
            if (this.getChild(i).getFullBounds().getX() < (double)x && this.getChild(i).getFullBounds().getY() < (double)y && this.getChild(i).getFullBounds().getX() + this.getChild(i).getFullBounds().getWidth() > (double)x && this.getChild(i).getFullBounds().getY() + this.getChild(i).getFullBounds().getHeight() > (double)y) {
                return this.getChild(i);
            }
            ++i;
        }
        return null;
    }

    public boolean isAtPos(float x, float y) {
        if (this.pnlSelf.getKnots().size() == 0) {
            float v;
            double[] A = new double[]{this.node1.getClosestPort(this.node2.getGlobalBounds().getCenterX(), this.node2.getGlobalBounds().getCenterY())[0], this.node1.getClosestPort(this.node2.getGlobalBounds().getCenterX(), this.node2.getGlobalBounds().getCenterY())[1]};
            double[] B = new double[]{this.node2.getClosestPort(this.node1.getGlobalBounds().getCenterX(), this.node1.getGlobalBounds().getCenterY())[0], this.node2.getClosestPort(this.node1.getGlobalBounds().getCenterX(), this.node1.getGlobalBounds().getCenterY())[1]};
            double c = Math.sqrt(Math.pow(B[0] - A[0], 2.0) + Math.pow(B[1] - A[1], 2.0));
            double b = Math.sqrt(Math.pow((double)x - A[0], 2.0) + Math.pow((double)y - A[1], 2.0));
            double a = Math.sqrt(Math.pow((double)x - B[0], 2.0) + Math.pow((double)y - B[1], 2.0));
            double alpha = Math.acos((b * b + c * c - a * a) / (2.0 * b * c));
            double beta = Math.acos((-b * b + c * c + a * a) / (2.0 * a * c));
            if (alpha < 1.5707963267948966 && beta < 1.5707963267948966 && (v = (float)((int)(b * Math.sin(alpha) * 1000.0)) / 1000.0f) < 5.0f) {
                return true;
            }
        }
        int i = 0;
        while (i < this.pnlSelf.getKnots().size()) {
            if (this.pnlSelf.getKnots().get(i)[0] < (double)x && this.pnlSelf.getKnots().get(i)[1] < (double)y && this.pnlSelf.getKnots().get(i)[0] + 5.0 > (double)x && this.pnlSelf.getKnots().get(i)[1] + 5.0 > (double)y) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < this.getChildrenCount()) {
            if (this.getChild(i).getX() < (double)x && this.getChild(i).getY() < (double)y && this.getChild(i).getX() + this.getChild(i).getFullBounds().getWidth() > (double)x && this.getChild(i).getY() + this.getChild(i).getFullBounds().getHeight() > (double)y) {
                return true;
            }
            ++i;
        }
        return this.getPath().contains(x, y);
    }
}

