/*
 * Decompiled with CFR 0.152.
 */
package pn.gui;

import edu.umd.cs.piccolo.PNode;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import pn.evpn.logic.PNLTransition;
import pn.gui.EdgeInputEventHandler;
import pn.gui.PNBasicInputEventHandler;
import pn.gui.PNGUIEdge;
import pn.gui.PNGUIKnot;
import pn.gui.PNGUIPanel;
import pn.gui.PNGUIPlace;
import pn.gui.PNGUIToolBar;
import pn.gui.PNGUITransition;
import pn.gui.PlaceInputEventHandler;
import pn.gui.TransitionInputEventHandler;
import pn.logic.IPNLVertex;
import pn.simulation.Simulator;
import pn.tb.logic.PNLEdge;
import pn.tb.logic.PNLPetriNet;
import pn.tb.logic.PNLPlace;
import pn.util.Constants;
import pn.util.NameGenerator;

public class PNGUICanvasClickHandler
implements MouseListener {
    public final Object toolBar;
    private PNode tmpNode;
    private PNode tmpNode2;
    private PNode tmpNode3;
    private pn.logic.PNLPetriNet petriNet;
    private ArrayList<PNode> tmpKnotList;
    private Simulator simulator;
    private int edgeStatus = 0;

    public PNGUICanvasClickHandler(Object toolBar, pn.logic.PNLPetriNet pn) {
        this.toolBar = toolBar;
        this.petriNet = pn;
        this.simulator = null;
    }

    public void startSimulation(Simulator sim) {
        this.simulator = sim;
    }

    public void stopSimulation() {
        this.simulator = null;
    }

    public boolean isSimulating() {
        return this.simulator != null;
    }

    public void removeAll() {
        if (this.tmpKnotList != null) {
            int i = 0;
            while (i < this.tmpKnotList.size()) {
                try {
                    this.petriNet.getGrPetriNet().getLayer().removeChild(this.tmpKnotList.get(i));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
            this.tmpKnotList.clear();
        }
        this.petriNet.getGrPetriNet().forceUnselectAll();
        this.edgeStatus = 0;
        this.tmpNode2 = null;
        this.tmpNode3 = null;
        this.petriNet.refresh();
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    @Override
    public void mousePressed(MouseEvent me) {
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        int i;
        if (SwingUtilities.isRightMouseButton(me)) {
            if (!((PNGUIToolBar)this.toolBar).delete() && !((PNGUIToolBar)this.toolBar).addedge()) {
                ((PNGUIToolBar)this.toolBar).deselectAll();
            }
            this.edgeStatus = 0;
        }
        if (this.petriNet.getGrPetriNet().isSelectedAnything() && !SwingUtilities.isRightMouseButton(me) && !((PNGUIToolBar)this.toolBar).addedge()) {
            this.petriNet.getGrPetriNet().forceUnselectAll();
        }
        if (((PNGUIToolBar)this.toolBar).addedge() && SwingUtilities.isRightMouseButton(me)) {
            this.removeAll();
            return;
        }
        double xClicked = (double)me.getX() / this.petriNet.getGrPetriNet().getCamera().getViewScale() + this.petriNet.getGrPetriNet().getCamera().getViewBounds().getX();
        double yClicked = (double)me.getY() / this.petriNet.getGrPetriNet().getCamera().getViewScale() + this.petriNet.getGrPetriNet().getCamera().getViewBounds().getY();
        if (this.isSimulating()) {
            this.handleSimulationClick(xClicked, yClicked);
            return;
        }
        if (((PNGUIToolBar)this.toolBar).addedge()) {
            switch (this.edgeStatus) {
                case 0: {
                    this.removeAll();
                    this.tmpNode2 = ((PNGUIPanel)me.getSource()).getChildByPos((float)xClicked, (float)yClicked);
                    if (this.tmpNode2 != null && (this.tmpNode2 instanceof PNGUIPlace || this.tmpNode2 instanceof PNGUITransition)) {
                        this.petriNet.getGrPetriNet().forceSelectNode(this.tmpNode2, false);
                        this.edgeStatus = 1;
                        return;
                    }
                    return;
                }
                case 1: {
                    this.tmpNode3 = ((PNGUIPanel)me.getSource()).getChildByPos((float)xClicked, (float)yClicked);
                    if (!(this.tmpNode3 instanceof PNGUIPlace) && !(this.tmpNode3 instanceof PNGUITransition)) {
                        this.tmpNode3 = null;
                    }
                    if (this.tmpNode2 != null && this.tmpNode3 != null && this.tmpNode2 != this.tmpNode3) {
                        if (this.tmpNode2.getClass() == this.tmpNode3.getClass()) {
                            this.removeAll();
                            return;
                        }
                        this.edgeStatus = 2;
                        this.petriNet.getGrPetriNet().forceSelectNode(this.tmpNode2, false);
                        this.petriNet.getGrPetriNet().forceSelectNode(this.tmpNode3, false);
                    } else {
                        if (this.tmpNode3 == null) {
                            this.petriNet.getGrPetriNet().forceSelectNode(this.tmpNode2, false);
                            if (this.tmpKnotList == null) {
                                this.tmpKnotList = new ArrayList();
                            }
                            PNGUIKnot knot = new PNGUIKnot((float)xClicked, (float)yClicked, this.petriNet.getGrPetriNet());
                            this.tmpKnotList.add(knot);
                            this.petriNet.getGrPetriNet().getLayer().addChild(knot);
                            return;
                        }
                        return;
                    }
                }
                case 2: {
                    this.tmpNode = this.tmpNode2;
                    this.tmpNode2 = null;
                    this.tmpNode3 = null;
                    this.edgeStatus = 0;
                    break;
                }
            }
        } else {
            this.edgeStatus = 0;
        }
        if (((PNGUIToolBar)this.toolBar).getEntityToAdd() == null) {
            this.petriNet.getGrPetriNet().forceSelectNode(this.petriNet.getGrPetriNet().getChildByPos((float)xClicked, (float)yClicked), !SwingUtilities.isRightMouseButton(me));
        }
        if (((PNGUIToolBar)this.toolBar).getEntityToAdd() == Constants.AddEntity.PLACE) {
            if (this.tmpKnotList != null) {
                i = 0;
                while (i < this.tmpKnotList.size()) {
                    try {
                        this.petriNet.getGrPetriNet().getLayer().removeChild(this.tmpKnotList.get(i));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++i;
                }
                this.tmpKnotList.clear();
            }
            if (this.petriNet instanceof PNLPetriNet) {
                this.petriNet.addVertex(new PNLPlace(NameGenerator.generateNextNewPlaceId(this.petriNet)));
                ((PNLPlace)this.petriNet.getLastVertexAdded()).getGrPlace().addInputEventListener(new PlaceInputEventHandler(this.petriNet.getLastVertexAdded().getGrVertex(), this.petriNet.getGrPetriNet()));
                ((PNLPlace)this.petriNet.getLastVertexAdded()).getGrPlace().getBasicText().addInputEventListener(new PNBasicInputEventHandler(((PNLPlace)this.petriNet.getLastVertexAdded()).getGrPlace().getBasicText(), ((PNLPlace)this.petriNet.getLastVertexAdded()).getGrPlace(), this.petriNet.getGrPetriNet()));
                ((PNLPlace)this.petriNet.getLastVertexAdded()).getGrPlace().getAdvancedText().addInputEventListener(new PNBasicInputEventHandler(((PNLPlace)this.petriNet.getLastVertexAdded()).getGrPlace().getAdvancedText(), ((PNLPlace)this.petriNet.getLastVertexAdded()).getGrPlace(), this.petriNet.getGrPetriNet()));
                ((PNLPlace)this.petriNet.getLastVertexAdded()).setBounds(xClicked - 15.0, yClicked - 15.0, 30.0, 30.0);
                ((PNLPlace)this.petriNet.getLastVertexAdded()).refreshTexts();
            } else if (this.petriNet instanceof pn.evpn.logic.PNLPetriNet) {
                this.petriNet.addVertex(new pn.evpn.logic.PNLPlace(NameGenerator.generateNextNewPlaceId(this.petriNet)));
                ((pn.evpn.logic.PNLPlace)this.petriNet.getLastVertexAdded()).getGrPlace().addInputEventListener(new PlaceInputEventHandler(this.petriNet.getLastVertexAdded().getGrVertex(), this.petriNet.getGrPetriNet()));
                ((pn.evpn.logic.PNLPlace)this.petriNet.getLastVertexAdded()).getGrPlace().getBasicText().addInputEventListener(new PNBasicInputEventHandler(((pn.evpn.logic.PNLPlace)this.petriNet.getLastVertexAdded()).getGrPlace().getBasicText(), ((pn.evpn.logic.PNLPlace)this.petriNet.getLastVertexAdded()).getGrPlace(), this.petriNet.getGrPetriNet()));
                ((pn.evpn.logic.PNLPlace)this.petriNet.getLastVertexAdded()).getGrPlace().getAdvancedText().addInputEventListener(new PNBasicInputEventHandler(((pn.evpn.logic.PNLPlace)this.petriNet.getLastVertexAdded()).getGrPlace().getAdvancedText(), ((pn.evpn.logic.PNLPlace)this.petriNet.getLastVertexAdded()).getGrPlace(), this.petriNet.getGrPetriNet()));
                ((pn.evpn.logic.PNLPlace)this.petriNet.getLastVertexAdded()).setBounds(xClicked - 15.0, yClicked - 15.0, 30.0, 30.0);
                ((pn.evpn.logic.PNLPlace)this.petriNet.getLastVertexAdded()).refreshTexts();
            } else if (this.petriNet instanceof pn.logic.PNLPetriNet) {
                this.petriNet.addVertex(new pn.logic.PNLPlace(NameGenerator.generateNextNewPlaceId(this.petriNet)));
                ((pn.logic.PNLPlace)this.petriNet.getLastVertexAdded()).getGrPlace().addInputEventListener(new PlaceInputEventHandler(this.petriNet.getLastVertexAdded().getGrVertex(), this.petriNet.getGrPetriNet()));
                ((pn.logic.PNLPlace)this.petriNet.getLastVertexAdded()).getGrPlace().getBasicText().addInputEventListener(new PNBasicInputEventHandler(((pn.logic.PNLPlace)this.petriNet.getLastVertexAdded()).getGrPlace().getBasicText(), ((pn.logic.PNLPlace)this.petriNet.getLastVertexAdded()).getGrPlace(), this.petriNet.getGrPetriNet()));
                ((pn.logic.PNLPlace)this.petriNet.getLastVertexAdded()).getGrPlace().getAdvancedText().addInputEventListener(new PNBasicInputEventHandler(((pn.logic.PNLPlace)this.petriNet.getLastVertexAdded()).getGrPlace().getAdvancedText(), ((pn.logic.PNLPlace)this.petriNet.getLastVertexAdded()).getGrPlace(), this.petriNet.getGrPetriNet()));
                ((pn.logic.PNLPlace)this.petriNet.getLastVertexAdded()).setBounds(xClicked - 15.0, yClicked - 15.0, 30.0, 30.0);
                ((pn.logic.PNLPlace)this.petriNet.getLastVertexAdded()).refreshTexts();
            }
            this.petriNet.getGrPetriNet().setEdited(true);
        }
        if (((PNGUIToolBar)this.toolBar).getEntityToAdd() == Constants.AddEntity.TRANSITION) {
            if (this.tmpKnotList != null) {
                i = 0;
                while (i < this.tmpKnotList.size()) {
                    this.petriNet.getGrPetriNet().getLayer().removeChild(this.tmpKnotList.get(i));
                    ++i;
                }
                this.tmpKnotList.clear();
            }
            if (this.petriNet instanceof PNLPetriNet) {
                this.petriNet.addVertex(new pn.tb.logic.PNLTransition(NameGenerator.generateNextNewTransId(this.petriNet)));
                ((pn.tb.logic.PNLTransition)this.petriNet.getLastVertexAdded()).getGrTransition().addInputEventListener(new TransitionInputEventHandler(this.petriNet.getLastVertexAdded().getGrVertex(), this.petriNet.getGrPetriNet()));
                ((pn.tb.logic.PNLTransition)this.petriNet.getLastVertexAdded()).getGrTransition().getBasicText().addInputEventListener(new PNBasicInputEventHandler(((pn.tb.logic.PNLTransition)this.petriNet.getLastVertexAdded()).getGrTransition().getBasicText(), ((pn.tb.logic.PNLTransition)this.petriNet.getLastVertexAdded()).getGrTransition(), this.petriNet.getGrPetriNet()));
                ((pn.tb.logic.PNLTransition)this.petriNet.getLastVertexAdded()).getGrTransition().getAdvancedText().addInputEventListener(new PNBasicInputEventHandler(((pn.tb.logic.PNLTransition)this.petriNet.getLastVertexAdded()).getGrTransition().getAdvancedText(), ((pn.tb.logic.PNLTransition)this.petriNet.getLastVertexAdded()).getGrTransition(), this.petriNet.getGrPetriNet()));
                ((pn.tb.logic.PNLTransition)this.petriNet.getLastVertexAdded()).setBounds(xClicked - 15.0, yClicked - 15.0, 30.0, 30.0);
                ((pn.tb.logic.PNLTransition)this.petriNet.getLastVertexAdded()).refreshTexts();
            } else if (this.petriNet instanceof pn.evpn.logic.PNLPetriNet) {
                this.petriNet.addVertex(new PNLTransition(NameGenerator.generateNextNewTransId(this.petriNet)));
                ((PNLTransition)this.petriNet.getLastVertexAdded()).getGrTransition().addInputEventListener(new TransitionInputEventHandler(this.petriNet.getLastVertexAdded().getGrVertex(), this.petriNet.getGrPetriNet()));
                ((PNLTransition)this.petriNet.getLastVertexAdded()).getGrTransition().getBasicText().addInputEventListener(new PNBasicInputEventHandler(((PNLTransition)this.petriNet.getLastVertexAdded()).getGrTransition().getBasicText(), ((PNLTransition)this.petriNet.getLastVertexAdded()).getGrTransition(), this.petriNet.getGrPetriNet()));
                ((PNLTransition)this.petriNet.getLastVertexAdded()).getGrTransition().getAdvancedText().addInputEventListener(new PNBasicInputEventHandler(((PNLTransition)this.petriNet.getLastVertexAdded()).getGrTransition().getAdvancedText(), ((PNLTransition)this.petriNet.getLastVertexAdded()).getGrTransition(), this.petriNet.getGrPetriNet()));
                ((PNLTransition)this.petriNet.getLastVertexAdded()).setBounds(xClicked - 15.0, yClicked - 15.0, 30.0, 30.0);
                ((PNLTransition)this.petriNet.getLastVertexAdded()).refreshTexts();
            } else if (this.petriNet instanceof pn.logic.PNLPetriNet) {
                this.petriNet.addVertex(new pn.logic.PNLTransition(NameGenerator.generateNextNewTransId(this.petriNet)));
                ((pn.logic.PNLTransition)this.petriNet.getLastVertexAdded()).getGrTransition().addInputEventListener(new TransitionInputEventHandler(this.petriNet.getLastVertexAdded().getGrVertex(), this.petriNet.getGrPetriNet()));
                ((pn.logic.PNLTransition)this.petriNet.getLastVertexAdded()).getGrTransition().getBasicText().addInputEventListener(new PNBasicInputEventHandler(((pn.logic.PNLTransition)this.petriNet.getLastVertexAdded()).getGrTransition().getBasicText(), ((pn.logic.PNLTransition)this.petriNet.getLastVertexAdded()).getGrTransition(), this.petriNet.getGrPetriNet()));
                ((pn.logic.PNLTransition)this.petriNet.getLastVertexAdded()).getGrTransition().getAdvancedText().addInputEventListener(new PNBasicInputEventHandler(((pn.logic.PNLTransition)this.petriNet.getLastVertexAdded()).getGrTransition().getAdvancedText(), ((pn.logic.PNLTransition)this.petriNet.getLastVertexAdded()).getGrTransition(), this.petriNet.getGrPetriNet()));
                ((pn.logic.PNLTransition)this.petriNet.getLastVertexAdded()).setBounds(xClicked - 15.0, yClicked - 15.0, 30.0, 30.0);
                ((pn.logic.PNLTransition)this.petriNet.getLastVertexAdded()).refreshTexts();
            }
            this.petriNet.getGrPetriNet().setEdited(true);
        }
        if (((PNGUIToolBar)this.toolBar).getEntityToAdd() == Constants.AddEntity.EDGE) {
            PNode tmpNode2;
            if (this.petriNet.getGrPetriNet().getChildByPos((float)xClicked, (float)yClicked) != null) {
                if (this.tmpNode == null) {
                    this.tmpKnotList = new ArrayList();
                    this.tmpNode = ((PNGUIPanel)me.getSource()).getChildByPos((float)xClicked, (float)yClicked);
                } else {
                    PNode tmpNode22 = this.petriNet.getGrPetriNet().getChildByPos((float)xClicked, (float)yClicked);
                    if (tmpNode22 != this.tmpNode) {
                        int i2 = 0;
                        while (i2 < this.petriNet.getEdges().size()) {
                            if (this.petriNet.getEdge(i2).getVertex1().getGrVertex().equals(this.tmpNode) && this.petriNet.getEdge(i2).getVertex2().getGrVertex().equals(tmpNode22)) {
                                this.tmpNode = null;
                                tmpNode22 = null;
                            }
                            ++i2;
                        }
                        if (this.tmpNode instanceof PNGUIPlace && tmpNode22 instanceof PNGUITransition) {
                            if (this.petriNet instanceof PNLPetriNet) {
                                this.petriNet.addEdge(new PNLEdge(((PNGUIPlace)this.tmpNode).getPNLSelf(), ((PNGUITransition)tmpNode22).getPNLSelf(), NameGenerator.generateNextNewEdgeId(this.petriNet), 1));
                            } else if (this.petriNet instanceof pn.evpn.logic.PNLPetriNet) {
                                this.petriNet.addEdge(new pn.evpn.logic.PNLEdge(((PNGUIPlace)this.tmpNode).getPNLSelf(), ((PNGUITransition)tmpNode22).getPNLSelf(), NameGenerator.generateNextNewEdgeId(this.petriNet), 1));
                            } else if (this.petriNet instanceof pn.logic.PNLPetriNet) {
                                this.petriNet.addEdge(new pn.logic.PNLEdge(((PNGUIPlace)this.tmpNode).getPNLSelf(), ((PNGUITransition)tmpNode22).getPNLSelf(), NameGenerator.generateNextNewEdgeId(this.petriNet), 1));
                            }
                            this.petriNet.getLastEdgeAdded().getGrEdge().addInputEventListener(new EdgeInputEventHandler(this.petriNet.getLastEdgeAdded().getGrEdge(), this.petriNet.getGrPetriNet()));
                            this.petriNet.getLastEdgeAdded().getGrEdge().getBasicText().addInputEventListener(new PNBasicInputEventHandler(this.petriNet.getLastEdgeAdded().getGrEdge().getBasicText(), this.petriNet.getLastEdgeAdded().getGrEdge(), this.petriNet.getGrPetriNet()));
                            this.petriNet.getLastEdgeAdded().getGrEdge().getAdvancedText().addInputEventListener(new PNBasicInputEventHandler(this.petriNet.getLastEdgeAdded().getGrEdge().getAdvancedText(), this.petriNet.getLastEdgeAdded().getGrEdge(), this.petriNet.getGrPetriNet()));
                            this.petriNet.getLastEdgeAdded().replaceKnots(this.tmpKnotList);
                            this.petriNet.refresh();
                            this.tmpNode = null;
                            this.petriNet.getGrPetriNet().setEdited(true);
                        } else if (this.tmpNode instanceof PNGUITransition && tmpNode22 instanceof PNGUIPlace) {
                            if (this.petriNet instanceof PNLPetriNet) {
                                this.petriNet.addEdge(new PNLEdge(((PNGUITransition)this.tmpNode).getPNLSelf(), ((PNGUIPlace)tmpNode22).getPNLSelf(), NameGenerator.generateNextNewEdgeId(this.petriNet), 1));
                            } else if (this.petriNet instanceof pn.evpn.logic.PNLPetriNet) {
                                this.petriNet.addEdge(new pn.evpn.logic.PNLEdge(((PNGUITransition)this.tmpNode).getPNLSelf(), ((PNGUIPlace)tmpNode22).getPNLSelf(), NameGenerator.generateNextNewEdgeId(this.petriNet), 1));
                            } else if (this.petriNet instanceof pn.logic.PNLPetriNet) {
                                this.petriNet.addEdge(new pn.logic.PNLEdge(((PNGUITransition)this.tmpNode).getPNLSelf(), ((PNGUIPlace)tmpNode22).getPNLSelf(), NameGenerator.generateNextNewEdgeId(this.petriNet), 1));
                            }
                            this.petriNet.getLastEdgeAdded().getGrEdge().addInputEventListener(new EdgeInputEventHandler(this.petriNet.getLastEdgeAdded().getGrEdge(), this.petriNet.getGrPetriNet()));
                            this.petriNet.getLastEdgeAdded().getGrEdge().getBasicText().addInputEventListener(new PNBasicInputEventHandler(this.petriNet.getLastEdgeAdded().getGrEdge().getBasicText(), this.petriNet.getLastEdgeAdded().getGrEdge(), this.petriNet.getGrPetriNet()));
                            this.petriNet.getLastEdgeAdded().getGrEdge().getAdvancedText().addInputEventListener(new PNBasicInputEventHandler(this.petriNet.getLastEdgeAdded().getGrEdge().getAdvancedText(), this.petriNet.getLastEdgeAdded().getGrEdge(), this.petriNet.getGrPetriNet()));
                            this.petriNet.getLastEdgeAdded().replaceKnots(this.tmpKnotList);
                            this.petriNet.refresh();
                            this.tmpNode = null;
                            this.petriNet.getGrPetriNet().setEdited(true);
                        }
                    }
                }
            } else if (this.tmpNode != null && (tmpNode2 = this.petriNet.getGrPetriNet().getChildByPos((float)xClicked, (float)yClicked)) == null) {
                PNGUIKnot knot = new PNGUIKnot((float)xClicked, (float)yClicked, this.petriNet.getGrPetriNet());
                this.tmpKnotList.add(knot);
                this.petriNet.getGrPetriNet().getLayer().addChild(knot);
            }
        }
    }

    private void handleSimulationClick(double xClicked, double yClicked) {
        PNode v = this.petriNet.getGrPetriNet().getChildByPos((float)xClicked, (float)yClicked);
        if (v instanceof PNGUITransition) {
            this.simulator.fire(((PNGUITransition)v).getPNLSelf());
        }
        this.petriNet.getGrPetriNet().repaint();
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        double xClicked = (double)me.getX() / this.petriNet.getGrPetriNet().getCamera().getViewScale() + this.petriNet.getGrPetriNet().getCamera().getViewBounds().getX();
        double yClicked = (double)me.getY() / this.petriNet.getGrPetriNet().getCamera().getViewScale() + this.petriNet.getGrPetriNet().getCamera().getViewBounds().getY();
        int s = ((PNGUIPanel)me.getSource()).getSelected().size();
        this.tmpNode = null;
        this.tmpNode = ((PNGUIPanel)me.getSource()).getChildByPos((float)xClicked, (float)yClicked);
        IPNLVertex v = null;
        if (this.tmpNode == null) {
            this.tmpNode = ((PNGUIPanel)me.getSource()).getChildByPosIncludeEdges((float)xClicked, (float)yClicked);
        }
        if (((PNGUIToolBar)this.toolBar).delete() && !SwingUtilities.isRightMouseButton(me) && s == 0 && me.getClickCount() == 1 && this.tmpNode instanceof PNGUIEdge) {
            int c = JOptionPane.showConfirmDialog(null, "Do you want to delete selected edge?", "Warning!", 0);
            switch (c) {
                case 0: {
                    break;
                }
                case 1: {
                    return;
                }
                default: {
                    return;
                }
            }
            if (this.tmpNode instanceof PNGUIEdge) {
                this.petriNet.removeEdge(((PNGUIEdge)this.tmpNode).getPNLSelf());
                this.tmpNode = null;
            }
        } else if (((PNGUIToolBar)this.toolBar).delete() && !SwingUtilities.isRightMouseButton(me) && s > 0 && me.getClickCount() == 1 && this.tmpNode != null) {
            int ss = 0;
            ArrayList<PNode> selected = ((PNGUIPanel)me.getSource()).getSelected();
            int sss = s - 1;
            while (sss >= 0) {
                this.tmpNode = selected.get(sss);
                if (this.tmpNode instanceof PNGUIPlace) {
                    ++ss;
                } else if (this.tmpNode instanceof PNGUITransition) {
                    ++ss;
                }
                --sss;
            }
            int c = JOptionPane.showConfirmDialog(null, "Do you want to delete " + String.valueOf(ss) + " selected item(s)?", "Warning!", 0);
            switch (c) {
                case 0: {
                    break;
                }
                case 1: {
                    return;
                }
                default: {
                    return;
                }
            }
            --s;
            while (s >= 0) {
                this.tmpNode = selected.get(s);
                v = null;
                if (this.tmpNode instanceof PNGUIPlace) {
                    v = ((PNGUIPlace)this.tmpNode).getPNLSelf();
                } else if (this.tmpNode instanceof PNGUITransition) {
                    v = ((PNGUITransition)this.tmpNode).getPNLSelf();
                } else if (this.tmpNode instanceof PNGUIEdge) {
                    this.petriNet.removeEdge(((PNGUIEdge)this.tmpNode).getPNLSelf());
                    this.tmpNode = null;
                }
                if (v == null) {
                    this.tmpNode = null;
                }
                int i = this.petriNet.getEdges().size() - 1;
                while (i >= 0) {
                    if (this.petriNet.getEdge(i).getVertex1() == v || this.petriNet.getEdge(i).getVertex2() == v) {
                        this.petriNet.removeEdge(i);
                    }
                    --i;
                }
                this.tmpNode = null;
                if (v != null) {
                    this.petriNet.removeVertex(v);
                }
                this.petriNet.getGrPetriNet().setEdited(true);
                --s;
            }
            ((PNGUIPanel)me.getSource()).forceUnselectAll();
        }
    }
}

