/*
 * Decompiled with CFR 0.152.
 */
package pn.gui;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.geom.Dimension2D;
import pn.gui.PNGUIEdge;
import pn.gui.PNGUIKnot;
import pn.gui.PNGUIPanel;
import pn.gui.PNGUIText;
import pn.gui.PNGUIVertex;

public class PNBasicInputEventHandler
extends PBasicInputEventHandler {
    protected PNode node;
    protected Object parent;
    protected PNGUIPanel panel;

    public PNBasicInputEventHandler(PNode n, Object parent) {
        this.node = n;
        this.parent = parent;
    }

    public PNBasicInputEventHandler(PNode n, Object parent, PNGUIPanel panel) {
        this.node = n;
        this.parent = parent;
        this.panel = panel;
    }

    @Override
    public void mousePressed(PInputEvent aEvent) {
        aEvent.setHandled(true);
        if (this.node instanceof PNGUIText) {
            this.node.setTransparency(0.5f);
            if (this.parent instanceof PNGUIVertex) {
                if (((PNGUIVertex)this.parent).getBasicText().equals(this.node)) {
                    ((PNGUIVertex)this.parent).getAdvancedText().setTransparency(0.5f);
                } else if (((PNGUIVertex)this.parent).getAdvancedText().equals(this.node)) {
                    ((PNGUIVertex)this.parent).getBasicText().setTransparency(0.5f);
                }
            } else if (this.parent instanceof PNGUIEdge) {
                if (((PNGUIEdge)this.parent).getBasicText().equals(this.node)) {
                    ((PNGUIEdge)this.parent).getAdvancedText().setTransparency(0.5f);
                } else if (((PNGUIEdge)this.parent).getAdvancedText().equals(this.node)) {
                    ((PNGUIEdge)this.parent).getBasicText().setTransparency(0.5f);
                }
            }
        }
    }

    @Override
    public void mouseDragged(PInputEvent aEvent) {
        if (this.node instanceof PNGUIText || this.node instanceof PNGUIKnot) {
            this.panel.setEdited(true);
            if (this.node instanceof PNGUIText) {
                PDimension delta = aEvent.getDeltaRelativeTo(this.node);
                this.node.translate(((Dimension2D)delta).getWidth(), ((Dimension2D)delta).getHeight());
                if (this.parent instanceof PNGUIVertex) {
                    if (((PNGUIVertex)this.parent).getBasicText().equals(this.node)) {
                        ((PNGUIVertex)this.parent).getAdvancedText().translate(((Dimension2D)delta).getWidth(), ((Dimension2D)delta).getHeight());
                    } else if (((PNGUIVertex)this.parent).getAdvancedText().equals(this.node)) {
                        ((PNGUIVertex)this.parent).getBasicText().translate(((Dimension2D)delta).getWidth(), ((Dimension2D)delta).getHeight());
                    }
                } else if (this.parent instanceof PNGUIEdge) {
                    if (((PNGUIEdge)this.parent).getBasicText().equals(this.node)) {
                        ((PNGUIEdge)this.parent).getAdvancedText().translate(((Dimension2D)delta).getWidth(), ((Dimension2D)delta).getHeight());
                    } else if (((PNGUIEdge)this.parent).getAdvancedText().equals(this.node)) {
                        ((PNGUIEdge)this.parent).getBasicText().translate(((Dimension2D)delta).getWidth(), ((Dimension2D)delta).getHeight());
                    }
                }
            }
        }
        if (this.parent instanceof PNGUIPanel) {
            ((PNGUIPanel)this.parent).repaint();
        }
        aEvent.setHandled(true);
    }

    @Override
    public void mouseReleased(PInputEvent aEvent) {
        aEvent.setHandled(true);
        if (this.node instanceof PNGUIText) {
            this.node.setTransparency(1.0f);
            if (this.parent instanceof PNGUIVertex) {
                if (((PNGUIVertex)this.parent).getBasicText().equals(this.node)) {
                    ((PNGUIVertex)this.parent).getAdvancedText().setTransparency(1.0f);
                } else if (((PNGUIVertex)this.parent).getAdvancedText().equals(this.node)) {
                    ((PNGUIVertex)this.parent).getBasicText().setTransparency(1.0f);
                }
            } else if (this.parent instanceof PNGUIEdge) {
                if (((PNGUIEdge)this.parent).getBasicText().equals(this.node)) {
                    ((PNGUIEdge)this.parent).getAdvancedText().setTransparency(1.0f);
                } else if (((PNGUIEdge)this.parent).getAdvancedText().equals(this.node)) {
                    ((PNGUIEdge)this.parent).getBasicText().setTransparency(1.0f);
                }
            }
        }
    }

    @Override
    public void mouseClicked(PInputEvent aEvent) {
        if (this.parent instanceof PNGUIPanel) {
            int j = 0;
            while (j < ((PNGUIPanel)this.parent).getLayer().getChildrenCount()) {
                if (((PNGUIPanel)this.parent).getLayer().getChild(j) instanceof PNGUIEdge) {
                    int i = 0;
                    while (i < ((PNGUIEdge)((PNGUIPanel)this.parent).getLayer().getChild(j)).getKnotCount()) {
                        ((PNGUIEdge)((PNGUIPanel)this.parent).getLayer().getChild(j)).getKnot(i).setVisible(false);
                        ++i;
                    }
                }
                ++j;
            }
            ((PNGUIPanel)this.parent).repaint();
        }
    }
}

