/*
 * Decompiled with CFR 0.152.
 */
package pn.gui;

import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;

public class Arrow
extends PPath {
    private Path2D path;
    private double[][] points;
    private boolean isFilled;

    public Arrow() {
        this.setStroke(new BasicStroke(5.0f));
        this.isFilled = true;
    }

    public Arrow(double[] point1, double[] point2, double[] point3) {
        this.points = new double[][]{{point1[0], point1[1]}, {point2[0], point2[1]}, {point3[0], point3[1]}};
        this.setStroke(new BasicStroke(5.0f));
        this.isFilled = true;
    }

    public Arrow(double[] point1, double[] point2) {
        this.setStroke(new BasicStroke(5.0f));
        this.setBounds(point2[0], point2[1]);
        this.calculatePoints(point1, point2);
        this.isFilled = true;
    }

    public void calculatePoints(double[] point1, double[] point2) {
        double angle = Math.atan2(point2[1] - point1[1], point2[0] - point1[0]);
        double[] p = new double[]{point2[0] - 10.0 * Math.cos(angle), point2[1] - 10.0 * Math.sin(angle)};
        double[] a = new double[]{p[0] + 5.0 * Math.cos(angle + 1.5707963267948966), p[1] + 5.0 * Math.sin(angle + 1.5707963267948966)};
        double[] c = new double[]{p[0] - 5.0 * Math.cos(angle + 1.5707963267948966), p[1] - 5.0 * Math.sin(angle + 1.5707963267948966)};
        this.points = new double[][]{{a[0], a[1]}, {point2[0], point2[1]}, {c[0], c[1]}};
    }

    public Path2D getPath() {
        return this.path;
    }

    @Override
    public boolean setBounds(double x1, double y1, double x2, double y2) {
        if (this.path == null) {
            this.path = new Path2D.Double();
        }
        if (super.setBounds(x1, y1, x2, y2)) {
            this.path.reset();
            return true;
        }
        return false;
    }

    public boolean setBounds(double x, double y) {
        if (this.path == null) {
            this.path = new Path2D.Double();
        }
        if (super.setBounds(x, y, 10.0, 10.0)) {
            this.path.reset();
            return true;
        }
        return false;
    }

    @Override
    public void paint(PPaintContext aPaintContext) {
        if (this.getPaint() == null) {
            this.setPaint(new Color(0, 0, 0));
        }
        this.path.reset();
        this.path.moveTo(this.points[0][0], this.points[0][1]);
        this.path.lineTo(this.points[1][0], this.points[1][1]);
        this.path.lineTo(this.points[2][0], this.points[2][1]);
        this.path.lineTo(this.points[0][0], this.points[0][1]);
        Graphics2D g2 = aPaintContext.getGraphics();
        g2.setColor((Color)this.getPaint());
        g2.fill(this.path);
    }
}

