/*
 * Decompiled with CFR 0.152.
 */
package pn.dialogs;

import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.AbstractListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pn.simulation.Simulation;
import pn.simulation.SimulationReader;

public class SimulationDialog
extends JDialog {
    private Simulation simulation;
    private SimulationReader simulationReader;
    private JButton jButton_nextStep;
    private JButton jButton_restartSimulation;
    private JLabel jLabel_commentOfFiringTitle;
    private JLabel jLabel_simulationCommentTitle;
    private JLabel jLabel_simulationName;
    private JLabel jLabel_simulationNameTitle;
    private JLabel jLabel_transitionToBeFiredTitle;
    private JList jList_transitionsToBeFired;
    private JProgressBar jProgressBar_SimulationIndicator;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JTextArea jTextArea_commentOfFiring;
    private JTextArea jTextArea_simulationComment;

    public SimulationDialog(Frame parent, boolean modal, SimulationReader simR, Simulation sim) {
        super(parent, modal);
        this.initComponents();
        this.simulationReader = simR;
        this.simulation = sim;
        this.jTextArea_simulationComment.setText(this.simulation.comment);
        this.jLabel_simulationName.setText(this.simulation.name);
        ArrayList<String> transitionsToBeFired = new ArrayList<String>();
        int i = 0;
        while (i < this.simulation.firingSequence.size()) {
            transitionsToBeFired.add(i, String.valueOf(i + 1) + ": " + this.simulation.firingSequence.get((int)i).transition);
            ++i;
        }
        this.jList_transitionsToBeFired.setListData(transitionsToBeFired.toArray());
        this.upgradeGUI(0);
        this.jProgressBar_SimulationIndicator.setMaximum(this.simulation.firingSequence.size());
    }

    private void upgradeGUI(int index) {
        if (index > -1) {
            this.jList_transitionsToBeFired.setSelectedIndex(index);
            this.jTextArea_commentOfFiring.setText(this.simulation.firingSequence.get((int)index).comment);
            this.jProgressBar_SimulationIndicator.setValue(index);
        } else {
            this.jList_transitionsToBeFired.clearSelection();
            this.jTextArea_commentOfFiring.setText(null);
            this.jProgressBar_SimulationIndicator.setValue(this.jProgressBar_SimulationIndicator.getMaximum());
        }
    }

    private void initComponents() {
        this.jLabel_transitionToBeFiredTitle = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jList_transitionsToBeFired = new JList();
        this.jScrollPane2 = new JScrollPane();
        this.jTextArea_commentOfFiring = new JTextArea();
        this.jLabel_commentOfFiringTitle = new JLabel();
        this.jLabel_simulationNameTitle = new JLabel();
        this.jLabel_simulationCommentTitle = new JLabel();
        this.jProgressBar_SimulationIndicator = new JProgressBar();
        this.jLabel_simulationName = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.jTextArea_simulationComment = new JTextArea();
        this.jSeparator2 = new JSeparator();
        this.jButton_nextStep = new JButton();
        this.jButton_restartSimulation = new JButton();
        this.jSeparator1 = new JSeparator();
        this.setDefaultCloseOperation(2);
        this.setTitle("Simulation from file");
        this.jLabel_transitionToBeFiredTitle.setText("Transitions to be fired:");
        this.jList_transitionsToBeFired.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jList_transitionsToBeFired.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SimulationDialog.this.jList_transitionsToBeFiredMouseClicked(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                SimulationDialog.this.jList_transitionsToBeFiredMousePressed(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jList_transitionsToBeFired);
        this.jTextArea_commentOfFiring.setColumns(20);
        this.jTextArea_commentOfFiring.setRows(5);
        this.jTextArea_commentOfFiring.setEnabled(false);
        this.jScrollPane2.setViewportView(this.jTextArea_commentOfFiring);
        this.jLabel_commentOfFiringTitle.setText("Description:");
        this.jLabel_simulationNameTitle.setText("Simulation name:");
        this.jLabel_simulationCommentTitle.setText("Description:");
        this.jProgressBar_SimulationIndicator.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                SimulationDialog.this.jProgressBar_SimulationIndicatorStateChanged(evt);
            }
        });
        this.jTextArea_simulationComment.setColumns(20);
        this.jTextArea_simulationComment.setRows(5);
        this.jTextArea_simulationComment.setEnabled(false);
        this.jScrollPane3.setViewportView(this.jTextArea_simulationComment);
        this.jButton_nextStep.setIcon(new ImageIcon(this.getClass().getResource("/pn/simulation/icons/fwd.png")));
        this.jButton_nextStep.setToolTipText("Do one step in simulation");
        this.jButton_nextStep.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_nextStep.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulationDialog.this.jButton_nextStepActionPerformed(evt);
            }
        });
        this.jButton_restartSimulation.setIcon(new ImageIcon(this.getClass().getResource("/pn/simulation/icons/rst.png")));
        this.jButton_restartSimulation.setToolTipText("Restart simulation");
        this.jButton_restartSimulation.setMargin(new Insets(0, 0, 0, 0));
        this.jButton_restartSimulation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimulationDialog.this.jButton_restartSimulationActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jSeparator2, -1, 297, Short.MAX_VALUE).addGap(20, 20, 20)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel_simulationNameTitle).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel_simulationName)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel_simulationCommentTitle).addGap(18, 18, 18).addComponent(this.jScrollPane3, -2, 230, -2))).addContainerGap()).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jScrollPane1).addComponent(this.jLabel_transitionToBeFiredTitle, -1, -1, Short.MAX_VALUE)).addGap(36, 36, 36).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel_commentOfFiringTitle).addComponent(this.jScrollPane2, -2, 162, -2)).addContainerGap(-1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jSeparator1, -1, 297, Short.MAX_VALUE).addGap(20, 20, 20)))).addGroup(layout.createSequentialGroup().addGap(130, 130, 130).addComponent(this.jButton_restartSimulation).addGap(4, 4, 4).addComponent(this.jButton_nextStep).addContainerGap(143, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jProgressBar_SimulationIndicator, -1, 297, Short.MAX_VALUE).addGap(20, 20, 20)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(8, 8, 8).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel_simulationNameTitle).addComponent(this.jLabel_simulationName)).addGap(8, 8, 8).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel_simulationCommentTitle).addComponent(this.jScrollPane3, -2, 40, -2)).addGap(18, 18, 18).addComponent(this.jSeparator2, -1, 10, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel_transitionToBeFiredTitle).addComponent(this.jLabel_commentOfFiringTitle)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane2, -1, 99, Short.MAX_VALUE).addGap(25, 25, 25)).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 99, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addGap(20, 20, 20).addComponent(this.jSeparator1, -2, 10, -2).addGap(2, 2, 2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jButton_nextStep).addComponent(this.jButton_restartSimulation)).addGap(21, 21, 21)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(236, Short.MAX_VALUE).addComponent(this.jProgressBar_SimulationIndicator, -2, -1, -2).addGap(76, 76, 76)));
        this.pack();
    }

    private void jList_transitionsToBeFiredMousePressed(MouseEvent evt) {
    }

    private void jButton_nextStepActionPerformed(ActionEvent evt) {
        this.simulationReader.executeNextStep();
        short index = this.simulationReader.getIndexOfNextTransition();
        if (index < this.simulation.firingSequence.size()) {
            this.upgradeGUI(index);
        } else {
            this.upgradeGUI(-1);
        }
    }

    private void jButton_restartSimulationActionPerformed(ActionEvent evt) {
        this.simulationReader.reset();
        this.upgradeGUI(0);
    }

    private void jProgressBar_SimulationIndicatorStateChanged(ChangeEvent evt) {
    }

    private void jList_transitionsToBeFiredMouseClicked(MouseEvent evt) {
        int index;
        if (evt.getButton() == 1 && (index = this.jList_transitionsToBeFired.getSelectedIndex()) > -1) {
            this.jTextArea_commentOfFiring.setText(this.simulation.firingSequence.get((int)index).comment);
            if (evt.getClickCount() == 2) {
                ++index;
                this.simulationReader.reset();
                int i = 0;
                while (i < index) {
                    this.simulationReader.executeNextStep();
                    ++i;
                }
                if (index < this.simulation.firingSequence.size()) {
                    this.upgradeGUI(index);
                } else {
                    this.upgradeGUI(-1);
                }
            }
        }
    }
}

