/*
 * Decompiled with CFR 0.152.
 */
package pn;

import com.jogamp.opencl.CLContext;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pn.Editor;
import pn.HelpFrame;
import pn.dialogs.ModulesDialog;
import pn.help.GenerateMapFile;
import pn.help.GenerateTOC;
import pn.help.HelpException;
import pn.logic.PNLPetriNet;
import pn.logic.PNType;
import pn.modules.IResponseListener;
import pn.modules.ModuleCtrl;
import pn.modules.PetriNetConverter;
import pn.modules.pn.IPetriNet;
import pn.project.PNPROJFilter;
import pn.project.Project;
import pn.project.ProjectPanel;
import pn.simulation.SimPanel;
import pn.util.ConfigCtrl;

public class MainFrame
extends JFrame
implements IResponseListener {
    private static JLabel popupInfo;
    private String filePath = null;
    private ModuleCtrl moduleCtrl;
    private ConfigCtrl configCtrl;
    private IPetriNet bkpPetriNet;
    private HelpBroker hb_sk;
    private HelpBroker hb_eng;
    private HelpSet hs_sk;
    private HelpSet hs_eng;
    private Boolean b_openedproject = false;
    private JLabel clLabel;
    private JMenuItem english;
    private JMenu helpMenu;
    private JButton jButton1;
    private JButton jButton3;
    private JButton jButton5;
    private JButton jButton6;
    private JCheckBoxMenuItem jCheckBoxMenuItem1;
    private JCheckBoxMenuItem jCheckBoxMenuItem2;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenu jMenu3;
    private JMenu jMenu5;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem10;
    private JMenuItem jMenuItem11;
    private JMenuItem jMenuItem12;
    private JMenuItem jMenuItem13;
    private JMenuItem jMenuItem14;
    private JMenuItem jMenuItem15;
    private JMenuItem jMenuItem16;
    private JMenuItem jMenuItem17;
    private JMenuItem jMenuItem18;
    private JMenuItem jMenuItem19;
    private JMenuItem jMenuItem2;
    private JMenuItem jMenuItem20;
    private JMenuItem jMenuItem3;
    private JMenuItem jMenuItem4;
    private JMenuItem jMenuItem5;
    private JMenuItem jMenuItem6;
    private JMenuItem jMenuItem7;
    private JMenuItem jMenuItem8;
    private JMenuItem jMenuItem9;
    private JPanel jPanel1;
    private JPanel jPanel4;
    private JPopupMenu jPopupMenu1;
    private JSeparator jSeparator1;
    private JPopupMenu.Separator jSeparator2;
    private JPopupMenu.Separator jSeparator3;
    private JPopupMenu.Separator jSeparator4;
    private JSplitPane jSplitPane1;
    private JTabbedPane jTabbedPane1;
    private JTextField jTextField1;
    private ProjectPanel projectPanel1;
    private SimPanel simPanel1;
    private JMenuItem slovak;

    public MainFrame() throws HelpException {
        this.initComponents();
        ImageIcon image = new ImageIcon(ClassLoader.getSystemResource("pn/gui/icons/icon.png"));
        this.setIconImage(image.getImage());
        this.projectPanel1.setParent(this);
        popupInfo = new JLabel("");
        this.simPanel1.setMainFrame(this);
        this.configCtrl = new ConfigCtrl();
        this.moduleCtrl = new ModuleCtrl(this);
        String[] s = this.moduleCtrl.getNames();
        int i = 0;
        while (i < s.length) {
            JMenuItem jm = new JMenuItem(s[i]);
            if (this.moduleCtrl.getControlPanels()[i] == null) {
                jm.setEnabled(false);
            }
            final int index = i++;
            jm.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MainFrame.this.modulesMenuItemActionPerformed(index);
                }
            });
        }
        JComponent[] modulePanels = this.moduleCtrl.getControlPanels();
        int h = 30;
        int i2 = 0;
        while (i2 < modulePanels.length) {
            if (modulePanels[i2] != null) {
                double ratio = (double)h / modulePanels[i2].getPreferredSize().getHeight();
                int w = (int)Math.round(modulePanels[i2].getPreferredSize().getWidth() * ratio);
                modulePanels[i2].setPreferredSize(new Dimension(w, h));
                this.jPanel1.add(modulePanels[i2]);
            }
            ++i2;
        }
        try {
            CLContext cl = CLContext.create();
            ImageIcon opencl = new ImageIcon(ClassLoader.getSystemResource("pn/gui/icons/opencl.png"));
            this.clLabel.setIcon(opencl);
            this.clLabel.setToolTipText("OpenCL device available, GPGPU enabled!");
        }
        catch (Exception ex) {
            System.out.println("OpenCL initialization failed\nOpenCL not supported, running aplication in normal mode...\n");
            System.out.println(ex);
            ImageIcon opencl = new ImageIcon(ClassLoader.getSystemResource("pn/gui/icons/opencl_mono.png"));
            this.clLabel.setIcon(opencl);
            this.clLabel.setToolTipText("OpenCL device not found!");
        }
        new GenerateMapFile(this.moduleCtrl);
        new GenerateTOC("_sk", this.moduleCtrl);
        new GenerateTOC("_eng", this.moduleCtrl);
        try {
            this.prepareJavaHelp();
        }
        catch (IOException ex) {
            System.out.println("Error: " + ex.getMessage());
        }
    }

    private void initComponents() {
        this.jPopupMenu1 = new JPopupMenu();
        this.jMenuItem9 = new JMenuItem();
        this.jTextField1 = new JTextField();
        this.jPanel1 = new JPanel();
        this.jSplitPane1 = new JSplitPane();
        this.projectPanel1 = new ProjectPanel();
        this.jPanel4 = new JPanel();
        this.jTabbedPane1 = new JTabbedPane();
        this.simPanel1 = new SimPanel();
        this.jButton3 = new JButton();
        this.jButton5 = new JButton();
        this.jButton6 = new JButton();
        this.jButton1 = new JButton();
        this.clLabel = new JLabel();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.jMenuItem1 = new JMenuItem();
        this.jMenuItem2 = new JMenuItem();
        this.jMenuItem7 = new JMenuItem();
        this.jMenuItem10 = new JMenuItem();
        this.jMenu2 = new JMenu();
        this.jMenuItem5 = new JMenuItem();
        this.jMenuItem11 = new JMenuItem();
        this.jMenuItem12 = new JMenuItem();
        this.jMenuItem13 = new JMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.jMenuItem14 = new JMenuItem();
        this.jMenuItem15 = new JMenuItem();
        this.jSeparator3 = new JPopupMenu.Separator();
        this.jMenuItem16 = new JMenuItem();
        this.jMenuItem17 = new JMenuItem();
        this.jSeparator4 = new JPopupMenu.Separator();
        this.jMenuItem18 = new JMenuItem();
        this.jMenuItem20 = new JMenuItem();
        this.jMenuItem19 = new JMenuItem();
        this.jMenu5 = new JMenu();
        this.jMenuItem3 = new JMenuItem();
        this.jMenuItem4 = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.jCheckBoxMenuItem1 = new JCheckBoxMenuItem();
        this.jCheckBoxMenuItem2 = new JCheckBoxMenuItem();
        this.jMenu3 = new JMenu();
        this.jMenuItem8 = new JMenuItem();
        this.helpMenu = new JMenu();
        this.english = new JMenuItem();
        this.slovak = new JMenuItem();
        this.jMenuItem6 = new JMenuItem();
        this.jMenuItem9.setText("Close tab");
        this.jMenuItem9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jMenuItem9ActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItem9);
        this.setDefaultCloseOperation(0);
        this.setTitle("PNTool 2.1");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                MainFrame.this.formWindowClosing(evt);
            }
        });
        this.jTextField1.setEditable(false);
        this.jTextField1.setBackground(new Color(212, 208, 200));
        this.jTextField1.setBorder(BorderFactory.createEtchedBorder());
        this.jTextField1.setDisabledTextColor(new Color(212, 208, 200));
        this.jTextField1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jTextField1ActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createBevelBorder(0));
        this.jPanel1.setPreferredSize(new Dimension(14, 35));
        this.jPanel1.setLayout(new FlowLayout(0));
        this.jSplitPane1.setBorder(null);
        this.projectPanel1.setMinimumSize(new Dimension(150, 23));
        this.projectPanel1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MainFrame.this.projectPanel1MouseClicked(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                MainFrame.this.projectPanel1MousePressed(evt);
            }
        });
        this.jSplitPane1.setLeftComponent(this.projectPanel1);
        this.jPanel4.setBorder(BorderFactory.createEtchedBorder());
        this.jTabbedPane1.setComponentPopupMenu(null);
        this.jTabbedPane1.setCursor(new Cursor(0));
        this.jTabbedPane1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MainFrame.this.jTabbedPane1StateChanged(evt);
            }
        });
        this.jTabbedPane1.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                MainFrame.this.jTabbedPane1MouseMoved(evt);
            }
        });
        this.jTabbedPane1.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MainFrame.this.jTabbedPane1FocusLost(evt);
            }
        });
        this.jButton3.setIcon(new ImageIcon(this.getClass().getResource("/pn/gui/icons/save.png")));
        this.jButton3.setToolTipText("Save net");
        this.jButton3.setEnabled(false);
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jButton3ActionPerformed(evt);
            }
        });
        this.jButton5.setIcon(new ImageIcon(this.getClass().getResource("/pn/gui/icons/zoomIn.png")));
        this.jButton5.setToolTipText("Zoom in");
        this.jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jButton5ActionPerformed(evt);
            }
        });
        this.jButton6.setIcon(new ImageIcon(this.getClass().getResource("/pn/gui/icons/zoomOut.png")));
        this.jButton6.setToolTipText("Zoom out");
        this.jButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jButton6ActionPerformed(evt);
            }
        });
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/pn/gui/icons/reset.png")));
        this.jButton1.setToolTipText("Reset the zoom");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jButton1ActionPerformed(evt);
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1, -1, 771, Short.MAX_VALUE).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.simPanel1, -2, 472, -2).addGap(18, 18, 18).addComponent(this.jButton3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton6))).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jButton6).addComponent(this.jButton3).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButton1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButton5, GroupLayout.Alignment.TRAILING)))).addComponent(this.simPanel1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTabbedPane1, -1, 481, Short.MAX_VALUE).addContainerGap()));
        this.jSplitPane1.setRightComponent(this.jPanel4);
        this.clLabel.setIcon(new ImageIcon(this.getClass().getResource("/pn/gui/icons/opencl.png")));
        this.jMenu1.setText("File");
        this.jMenuItem1.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.jMenuItem1.setIcon(new ImageIcon(this.getClass().getResource("/pn/gui/icons/new.png")));
        this.jMenuItem1.setText("New project");
        this.jMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jMenuItem1ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem1);
        this.jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.jMenuItem2.setIcon(new ImageIcon(this.getClass().getResource("/pn/gui/icons/open.png")));
        this.jMenuItem2.setText("Open project");
        this.jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jMenuItem2ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem2);
        this.jMenuItem7.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.jMenuItem7.setIcon(new ImageIcon(this.getClass().getResource("/pn/gui/icons/save.png")));
        this.jMenuItem7.setText("Save project");
        this.jMenuItem7.setEnabled(false);
        this.jMenuItem7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jMenuItem7ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem7);
        this.jMenuItem10.setIcon(new ImageIcon(this.getClass().getResource("/pn/gui/icons/delete.png")));
        this.jMenuItem10.setText("Close project");
        this.jMenuItem10.setEnabled(false);
        this.jMenuItem10.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jMenuItem10ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem10);
        this.jMenuBar1.add(this.jMenu1);
        this.jMenu2.setText("Project");
        this.jMenuItem5.setText("New file");
        this.jMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jMenuItem5ActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem5);
        this.jMenuItem11.setText("New GPN");
        this.jMenuItem11.setToolTipText("");
        this.jMenuItem11.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jMenuItem11ActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem11);
        this.jMenuItem12.setText("New EvPN");
        this.jMenuItem12.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jMenuItem12ActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem12);
        this.jMenuItem13.setText("New TB");
        this.jMenuItem13.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jMenuItem13ActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem13);
        this.jMenu2.add(this.jSeparator2);
        this.jMenuItem14.setText("Open file");
        this.jMenuItem14.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jMenuItem14ActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem14);
        this.jMenuItem15.setText("Open PetriNet");
        this.jMenuItem15.setEnabled(false);
        this.jMenu2.add(this.jMenuItem15);
        this.jMenu2.add(this.jSeparator3);
        this.jMenuItem17.setText("Save project");
        this.jMenuItem17.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jMenuItem17ActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem17);
        this.jMenu2.add(this.jSeparator4);
        this.jMenuItem18.setText("Close project");
        this.jMenuItem18.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jMenuItem18ActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem18);
        this.jMenuItem20.setText("Delete project");
        this.jMenuItem20.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jMenuItem20ActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem20);
        this.jMenuItem19.setText("Rename project");
        this.jMenuItem19.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jMenuItem19ActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem19);
        this.jMenu5.setText("View");
        this.jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(107, 2));
        this.jMenuItem3.setIcon(new ImageIcon(this.getClass().getResource("/pn/gui/icons/zoomIn.png")));
        this.jMenuItem3.setText("Zoom In");
        this.jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jMenuItem3ActionPerformed(evt);
            }
        });
        this.jMenu5.add(this.jMenuItem3);
        this.jMenuItem4.setAccelerator(KeyStroke.getKeyStroke(109, 2));
        this.jMenuItem4.setIcon(new ImageIcon(this.getClass().getResource("/pn/gui/icons/zoomOut.png")));
        this.jMenuItem4.setText("Zoom Out");
        this.jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jMenuItem4ActionPerformed(evt);
            }
        });
        this.jMenu5.add(this.jMenuItem4);
        this.jMenu5.add(this.jSeparator1);
        this.jCheckBoxMenuItem1.setSelected(true);
        this.jCheckBoxMenuItem1.setText("Show Basic Information");
        this.jCheckBoxMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jCheckBoxMenuItem1ActionPerformed(evt);
            }
        });
        this.jMenu5.add(this.jCheckBoxMenuItem1);
        this.jCheckBoxMenuItem2.setText("Show Advanced Information");
        this.jCheckBoxMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jCheckBoxMenuItem2ActionPerformed(evt);
            }
        });
        this.jCheckBoxMenuItem2.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                MainFrame.this.jCheckBoxMenuItem2KeyPressed(evt);
            }
        });
        this.jMenu5.add(this.jCheckBoxMenuItem2);
        this.jMenuBar1.add(this.jMenu5);
        this.jMenu3.setText("Help");
        this.jMenuItem8.setText("Quick help");
        this.jMenuItem8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jMenuItem8ActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.jMenuItem8);
        this.helpMenu.setText("Help");
        this.english.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.english.setText("English");
        this.helpMenu.add(this.english);
        this.slovak.setText("Slovensk\u00fd");
        this.helpMenu.add(this.slovak);
        this.jMenu3.add(this.helpMenu);
        this.jMenuItem6.setText("About");
        this.jMenuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jMenuItem6ActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.jMenuItem6);
        this.jMenuBar1.add(this.jMenu3);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextField1, -1, 954, Short.MAX_VALUE).addComponent(this.jSplitPane1, -1, 954, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clLabel, -2, 45, -2).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.clLabel, -2, 45, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSplitPane1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField1, -2, -1, -2)));
        this.pack();
    }

    private void jMenuItem6ActionPerformed(ActionEvent evt) {
        new ModulesDialog((Frame)this, false, this.moduleCtrl, 1).showDialog();
    }

    private void jMenuItem2ActionPerformed(ActionEvent evt) {
        if (this.projectPanel1.getMainProject() == null) {
            this.b_openedproject = false;
        }
        if (this.b_openedproject.booleanValue()) {
            int i = JOptionPane.showConfirmDialog(this, "Project has been opened. Do you want to save it?", "Warning!", 1);
            switch (i) {
                case 0: {
                    this.projectPanel1.getMainProject().save();
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    return;
                }
            }
            this.b_openedproject = false;
            this.projectPanel1.closeMainProject();
            this.jMenuItem7.setEnabled(this.projectPanel1.getMainProject() != null);
            this.jMenuItem10.setEnabled(this.projectPanel1.getMainProject() != null);
        }
        this.openProject();
        this.jMenuItem7.setEnabled(this.projectPanel1.getMainProject() != null);
        this.jMenuItem10.setEnabled(this.projectPanel1.getMainProject() != null);
        this.b_openedproject = true;
    }

    private void jMenuItem1ActionPerformed(ActionEvent evt) {
        String n;
        if (this.projectPanel1.getMainProject() == null) {
            this.b_openedproject = false;
        }
        if (this.b_openedproject.booleanValue()) {
            int i = JOptionPane.showConfirmDialog(this, "Project has been opened. Do you want to save it?", "Warning!", 1);
            switch (i) {
                case 0: {
                    this.projectPanel1.getMainProject().save();
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    return;
                }
            }
            this.b_openedproject = false;
            this.projectPanel1.closeMainProject();
            this.jMenuItem7.setEnabled(this.projectPanel1.getMainProject() != null);
            this.jMenuItem10.setEnabled(this.projectPanel1.getMainProject() != null);
        }
        if ((n = JOptionPane.showInputDialog(this, "Project name:", "New project", 3)) == null) {
            return;
        }
        if (n.length() == 0) {
            return;
        }
        Project p = new Project(this.projectPanel1);
        p.createNew(n);
        if (p.getProjFileName() != null) {
            this.projectPanel1.addProject(p);
            this.jMenuItem7.setEnabled(this.projectPanel1.getMainProject() != null);
            this.jMenuItem10.setEnabled(this.projectPanel1.getMainProject() != null);
            this.b_openedproject = true;
        }
    }

    private void jMenuItem8ActionPerformed(ActionEvent evt) {
        new HelpFrame().setVisible(true);
    }

    private void jMenuItem9ActionPerformed(ActionEvent evt) {
        if (this.jTabbedPane1.getSelectedIndex() == -1) {
            return;
        }
        if (this.getSelectedEditor().isEdited()) {
            int i = JOptionPane.showConfirmDialog(this, "Petri Net has been edited. Do you want to save changes?", "Warning!", 1);
            switch (i) {
                case 0: {
                    this.getSelectedEditor().getProject().updatePetriNet(PetriNetConverter.convert(this.getSelectedEditor().getPetriNet()));
                    this.getSelectedEditor().getProject().saveWithoutUpdate();
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    return;
                }
            }
        }
        this.jTabbedPane1.remove(this.jTabbedPane1.getSelectedIndex());
        if (this.jTabbedPane1.getTabCount() == 0) {
            this.jButton3.setEnabled(false);
        }
    }

    private void jTabbedPane1FocusLost(FocusEvent evt) {
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        if (this.getSelectedEditor() == null) {
            return;
        }
        this.setEdited(false);
        this.getSelectedEditor().getProject().save();
    }

    private void jButton5ActionPerformed(ActionEvent evt) {
        if (this.getSelectedEditor() == null) {
            return;
        }
        this.getSelectedEditor().getPetriNet().getGrPetriNet().getCamera().setViewScale(this.getSelectedEditor().getPetriNet().getGrPetriNet().getCamera().getViewScale() + 0.2);
    }

    private void jButton6ActionPerformed(ActionEvent evt) {
        if (this.getSelectedEditor() == null) {
            return;
        }
        this.getSelectedEditor().getPetriNet().getGrPetriNet().getCamera().setViewScale(this.getSelectedEditor().getPetriNet().getGrPetriNet().getCamera().getViewScale() - 0.2);
    }

    private void jMenuItem3ActionPerformed(ActionEvent evt) {
        if (this.getSelectedEditor() == null) {
            return;
        }
        this.getSelectedEditor().getPetriNet().getGrPetriNet().getCamera().setViewScale(this.getSelectedEditor().getPetriNet().getGrPetriNet().getCamera().getViewScale() + 0.2);
    }

    private void jMenuItem4ActionPerformed(ActionEvent evt) {
        if (this.getSelectedEditor() == null) {
            return;
        }
        this.getSelectedEditor().getPetriNet().getGrPetriNet().getCamera().setViewScale(this.getSelectedEditor().getPetriNet().getGrPetriNet().getCamera().getViewScale() - 0.2);
    }

    private void jCheckBoxMenuItem1ActionPerformed(ActionEvent evt) {
        int i = 0;
        while (i < this.jTabbedPane1.getTabCount()) {
            ((Editor)this.jTabbedPane1.getComponentAt(i)).setLevel1Shown(this.getShowLevel1Texts());
            ++i;
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        int i = 0;
        while (i < this.jTabbedPane1.getTabCount()) {
            if (((Editor)this.jTabbedPane1.getComponentAt(i)).isEdited()) {
                int x = JOptionPane.showConfirmDialog(this, "Some Petri Nets have been edited. Do you want to save changes?", "Warning!", 1);
                switch (x) {
                    case 0: {
                        this.getSelectedEditor().getProject().save();
                        System.exit(0);
                        break;
                    }
                    case 1: {
                        System.exit(0);
                        break;
                    }
                    case 2: {
                        return;
                    }
                }
            }
            ++i;
        }
        System.exit(0);
    }

    private void jCheckBoxMenuItem2ActionPerformed(ActionEvent evt) {
        int i = 0;
        while (i < this.jTabbedPane1.getTabCount()) {
            ((Editor)this.jTabbedPane1.getComponentAt(i)).setLevel2Shown(this.getShowLevel2Texts());
            ++i;
        }
    }

    private void jMenuItem7ActionPerformed(ActionEvent evt) {
        this.projectPanel1.getMainProject().save();
    }

    private void jMenuItem10ActionPerformed(ActionEvent evt) {
        if (this.projectPanel1.getMainProject() == null) {
            this.b_openedproject = false;
        }
        if (this.b_openedproject.booleanValue()) {
            int i = JOptionPane.showConfirmDialog(this, "Project has been opened. Do you want to save it?", "Warning!", 1);
            switch (i) {
                case 0: {
                    this.projectPanel1.getMainProject().save();
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    return;
                }
            }
        }
        this.b_openedproject = false;
        this.projectPanel1.closeMainProject();
        this.jMenuItem7.setEnabled(this.projectPanel1.getMainProject() != null);
        this.jMenuItem10.setEnabled(this.projectPanel1.getMainProject() != null);
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.getSelectedEditor().getPetriNet().getGrPetriNet().getCamera().setViewScale(1.0);
        this.getSelectedEditor().getPetriNet().getGrPetriNet().getCamera().setWidth(681.0);
        this.getSelectedEditor().getPetriNet().getGrPetriNet().getCamera().setHeight(418.0);
    }

    private void jCheckBoxMenuItem2KeyPressed(KeyEvent evt) {
    }

    private void jTextField1ActionPerformed(ActionEvent evt) {
    }

    private void jTabbedPane1StateChanged(ChangeEvent evt) {
        if (this.jTabbedPane1.getTabCount() == 0) {
            this.jTabbedPane1.setComponentPopupMenu(null);
        } else {
            this.jTabbedPane1.setComponentPopupMenu(this.jPopupMenu1);
        }
    }

    private void projectPanel1MouseClicked(MouseEvent evt) {
    }

    private void jMenuItem14ActionPerformed(ActionEvent evt) {
        this.projectPanel1.SimulatePopupMenuClick(4);
    }

    private void jMenuItem16ActionPerformed(ActionEvent evt) {
        this.projectPanel1.SimulatePopupMenuClick(6);
    }

    private void jMenuItem18ActionPerformed(ActionEvent evt) {
        this.projectPanel1.SimulatePopupMenuClick(8);
    }

    private void projectPanel1MousePressed(MouseEvent evt) {
    }

    private void jTabbedPane1MouseMoved(MouseEvent evt) {
    }

    private void jMenuItem5ActionPerformed(ActionEvent evt) {
        this.projectPanel1.SimulatePopupMenuClick(0);
    }

    private void jMenuItem11ActionPerformed(ActionEvent evt) {
        this.projectPanel1.SimulatePopupMenuClick(1);
    }

    private void jMenuItem12ActionPerformed(ActionEvent evt) {
        this.projectPanel1.SimulatePopupMenuClick(2);
    }

    private void jMenuItem13ActionPerformed(ActionEvent evt) {
        this.projectPanel1.SimulatePopupMenuClick(3);
    }

    private void jMenuItem17ActionPerformed(ActionEvent evt) {
        this.projectPanel1.getMainProject().save();
    }

    private void jMenuItem20ActionPerformed(ActionEvent evt) {
        this.projectPanel1.SimulatePopupMenuClick(9);
    }

    private void jMenuItem19ActionPerformed(ActionEvent evt) {
        this.projectPanel1.SimulatePopupMenuClick(10);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    new MainFrame().setVisible(true);
                }
                catch (HelpException ex) {
                    System.out.println("Error: " + ex.getMessage());
                }
            }
        });
    }

    public void prepareJavaHelp() throws IOException {
        File file = new File("help/helpSet_sk.hs");
        File file2 = new File("help/helpSet_eng.hs");
        this.hs_sk = this.getHelpSet(file.getCanonicalPath());
        this.hs_eng = this.getHelpSet(file2.getCanonicalPath());
        this.hb_sk = this.hs_sk.createHelpBroker();
        this.hb_eng = this.hs_eng.createHelpBroker();
        this.hb_sk.enableHelpOnButton(this.slovak, "index_sk", this.hs_sk);
        this.hb_eng.enableHelpKey(this.getRootPane(), "index_eng", this.hs_eng);
        this.hb_eng.enableHelpOnButton(this.english, "index_eng", this.hs_eng);
    }

    public HelpSet getHelpSet(String helpsetfile) {
        HelpSet hs = null;
        ClassLoader cl = this.getClass().getClassLoader();
        try {
            URL hsURL = new URL("file:/" + helpsetfile);
            hs = new HelpSet(cl, hsURL);
        }
        catch (Exception ee) {
            System.out.println("HelpSet: " + ee.getMessage());
            System.out.println("HelpSet: " + helpsetfile + " not found");
        }
        return hs;
    }

    public void updateProject(Project p) {
        int i = 0;
        while (i < this.jTabbedPane1.getTabCount()) {
            if (((Editor)this.jTabbedPane1.getComponentAt(i)).getProject().equals(p)) {
                ((Editor)this.jTabbedPane1.getComponentAt(i)).updateProject();
            }
            ++i;
        }
    }

    public void openProject() {
        JFileChooser fc = new JFileChooser();
        fc.setFileFilter(new PNPROJFilter());
        fc.setCurrentDirectory(new File(this.configCtrl.getLastDir()));
        int a = fc.showOpenDialog(this);
        if (a == 0) {
            this.filePath = fc.getSelectedFile().getAbsolutePath();
            this.configCtrl.setLastDir(fc.getCurrentDirectory().getPath());
            Project p = new Project(this.projectPanel1);
            p.open(this.filePath);
            this.projectPanel1.addProject(p);
        }
    }

    @Override
    public Image convertToImage(IPetriNet ipn) {
        Editor e = this.getNewEditor(ipn, null);
        e.getPetriNet().getGrPetriNet().setLevel1Shown(true);
        e.getPetriNet().getGrPetriNet().setLevel2Shown(true);
        Image img = e.getPetriNet().getGrPetriNet().getLayer().toImage();
        BufferedImage bImage = PImage.toBufferedImage(img, false);
        return bImage;
    }

    @Override
    public void respond(IPetriNet pn) {
        this.addPetriNetToMainProject(pn);
    }

    @Override
    public ArrayList<IPetriNet> requestPetriNets() {
        ArrayList<IPetriNet> a = new ArrayList<IPetriNet>();
        if (this.getSelectedEditor() == null) {
            return null;
        }
        a.add(PetriNetConverter.convert(this.getSelectedEditor().getPetriNet()));
        int i = 0;
        while (i < this.getSelectedEditor().getProject().getPetriNetsCount()) {
            a.add(this.getSelectedEditor().getProject().getPetriNet(i));
            ++i;
        }
        return a;
    }

    private void modulesMenuItemActionPerformed(int index) {
    }

    public void addPetriNetToMainProject(IPetriNet pn) {
        block21: {
            block20: {
                if (this.projectPanel1.getMainProject() != null) break block20;
                this.b_openedproject = false;
                int i = JOptionPane.showConfirmDialog(this, "Project has not been opened. Do you want to open it?", "Warning!", 1);
                switch (i) {
                    case 0: {
                        String n = JOptionPane.showInputDialog(this, "Project name:", "New project", 3);
                        if (n == null) {
                            return;
                        }
                        if (n.length() == 0) {
                            return;
                        }
                        Project p = new Project(this.projectPanel1);
                        p.createNew(n);
                        if (p.getProjFileName() != null) {
                            this.projectPanel1.addProject(p);
                            this.jMenuItem7.setEnabled(this.projectPanel1.getMainProject() != null);
                            this.jMenuItem10.setEnabled(this.projectPanel1.getMainProject() != null);
                            this.b_openedproject = true;
                            break;
                        }
                        break block21;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        return;
                    }
                }
                break block21;
            }
            int i = JOptionPane.showConfirmDialog(this, "Project has been opened. Do you want to create new?", "Warning!", 1);
            switch (i) {
                case 0: {
                    int ii = JOptionPane.showConfirmDialog(this, "Do you want to save opened project?", "Warning!", 1);
                    switch (ii) {
                        case 0: {
                            this.projectPanel1.getMainProject().save();
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 2: {
                            return;
                        }
                    }
                    this.b_openedproject = false;
                    this.projectPanel1.closeMainProject();
                    this.jMenuItem7.setEnabled(this.projectPanel1.getMainProject() != null);
                    this.jMenuItem10.setEnabled(this.projectPanel1.getMainProject() != null);
                    String n = JOptionPane.showInputDialog(this, "Project name:", "New project", 3);
                    if (n == null) {
                        return;
                    }
                    if (n.length() == 0) {
                        return;
                    }
                    Project p = new Project(this.projectPanel1);
                    p.createNew(n);
                    if (p.getProjFileName() == null) break;
                    this.projectPanel1.addProject(p);
                    this.jMenuItem7.setEnabled(this.projectPanel1.getMainProject() != null);
                    this.jMenuItem10.setEnabled(this.projectPanel1.getMainProject() != null);
                    this.b_openedproject = true;
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    return;
                }
            }
        }
        this.projectPanel1.getMainProject().addPetriNet(pn);
        this.projectPanel1.resetModel();
    }

    private boolean getShowLevel1Texts() {
        return this.jCheckBoxMenuItem1.isSelected();
    }

    private boolean getShowLevel2Texts() {
        return this.jCheckBoxMenuItem2.isSelected();
    }

    public void addPetriNet(IPetriNet pn, Project p) {
        int i = 0;
        while (i < this.jTabbedPane1.getTabCount()) {
            if (((Editor)this.jTabbedPane1.getComponentAt(i)).getPetriNet().getId().equals(pn.getId())) {
                return;
            }
            ++i;
        }
        this.jTabbedPane1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (MainFrame.this.getSelectedEditor() != null) {
                    MainFrame.this.getSelectedEditor().setLevel1Shown(MainFrame.this.getShowLevel1Texts());
                    MainFrame.this.getSelectedEditor().setLevel2Shown(MainFrame.this.getShowLevel2Texts());
                }
                MainFrame.this.simPanel1.update();
            }
        });
        this.jTabbedPane1.addTab(String.valueOf(pn.getName()) + " (" + pn.getType() + ")", this.getNewEditor(pn, p));
        this.jButton3.setEnabled(true);
    }

    public void addPetriNet(String name, PNType type, Project p) {
        this.jTabbedPane1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (MainFrame.this.getSelectedEditor() != null) {
                    MainFrame.this.getSelectedEditor().setLevel1Shown(MainFrame.this.getShowLevel1Texts());
                    MainFrame.this.getSelectedEditor().setLevel2Shown(MainFrame.this.getShowLevel2Texts());
                }
                MainFrame.this.simPanel1.update();
            }
        });
        this.jTabbedPane1.addTab(String.valueOf(name) + " (" + type + ")", this.getNewEditor(name, type, p));
    }

    public void notifyPetriNetRenamed(IPetriNet ipn) {
        int i = 0;
        while (i < this.jTabbedPane1.getTabCount()) {
            if (((Editor)this.jTabbedPane1.getComponentAt(i)).getPetriNet().getId().equals(ipn.getId())) {
                this.jTabbedPane1.setTitleAt(i, ipn.getName());
                ((Editor)this.jTabbedPane1.getComponentAt(i)).getPetriNet().setName(ipn.getName());
            }
            ++i;
        }
    }

    public void notifyPetriNetRemoved(IPetriNet ipn) {
        int i = 0;
        while (i < this.jTabbedPane1.getTabCount()) {
            if (((Editor)this.jTabbedPane1.getComponentAt(i)).getPetriNet().getId().equals(ipn.getId())) {
                this.jTabbedPane1.remove(i);
            }
            ++i;
        }
    }

    public void setToolbarEnabled(boolean b) {
        this.getSelectedEditor().setToolbarEnabled(b);
    }

    public Editor getSelectedEditor() {
        return (Editor)this.jTabbedPane1.getSelectedComponent();
    }

    private Editor getNewEditor(IPetriNet ipn, Project p) {
        return new Editor(this.jTextField1, ipn, p, this);
    }

    private Editor getNewEditor(String pnName, PNType type, Project p) {
        return new Editor(this.jTextField1, pnName, type, p);
    }

    public PNLPetriNet getPetriNet() {
        if (this.getSelectedEditor() == null) {
            return null;
        }
        return this.getSelectedEditor().getPetriNet();
    }

    public void reset() {
        this.simPanel1.getAssignedEditor().setPetriNet(this.bkpPetriNet);
        if (this.getSelectedEditor() != null) {
            this.getSelectedEditor().getPetriNet().getGrPetriNet().setLevel1Shown(this.getShowLevel1Texts());
            this.getSelectedEditor().getPetriNet().getGrPetriNet().setLevel2Shown(this.getShowLevel2Texts());
        }
    }

    public void backupPetriNet() {
        this.bkpPetriNet = PetriNetConverter.convert(this.getSelectedEditor().getPetriNet());
    }

    public void startSimulation() {
        if (this.getSelectedEditor() != null) {
            this.getSelectedEditor().startSimulation(this.simPanel1.getSimulator());
        }
    }

    public void stopSimulation() {
        this.simPanel1.getAssignedEditor().stopSimulation();
    }

    public void setEdited(boolean b) {
        if (this.getSelectedEditor() != null) {
            this.getSelectedEditor().setEdited(b);
        }
        this.jButton3.setEnabled(b);
    }

    public void closeTabs(Project p) {
        int i = 0;
        while (i < this.jTabbedPane1.getTabCount()) {
            if (((Editor)this.jTabbedPane1.getComponentAt(i)).getProject().equals(p)) {
                this.jTabbedPane1.remove(i);
                --i;
            }
            ++i;
        }
    }

    public void notifyProjectClosed() {
        this.jMenuItem7.setEnabled(this.projectPanel1.getMainProject() != null);
        this.jMenuItem10.setEnabled(this.projectPanel1.getMainProject() != null);
    }
}

