/*
 * Decompiled with CFR 0.152.
 */
package pn;

import edu.umd.cs.piccolox.swing.PScrollPane;
import java.awt.Color;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import pn.MainFrame;
import pn.evpn.logic.PNLTransition;
import pn.gui.EdgeInputEventHandler;
import pn.gui.PNBasicInputEventHandler;
import pn.gui.PNGUICanvasClickHandler;
import pn.gui.PNGUIKnot;
import pn.gui.PNGUIToolBar;
import pn.gui.PlaceInputEventHandler;
import pn.gui.TransitionInputEventHandler;
import pn.logic.IPNLPlace;
import pn.logic.IPNLVertex;
import pn.logic.PNLPlace;
import pn.logic.PNLVertex;
import pn.logic.PNType;
import pn.modules.PetriNetConverter;
import pn.modules.pn.IPetriNet;
import pn.project.Project;
import pn.simulation.Simulator;
import pn.tb.logic.PNLEdge;
import pn.tb.logic.PNLPetriNet;

public class Editor
extends JPanel {
    private pn.logic.PNLPetriNet petriNet;
    private PNGUIToolBar toolBar1;
    private JLabel popupInfo;
    private boolean isInSimulation;
    private PScrollPane scrollPane;
    private final Project project;
    private MainFrame mainFrame;
    private boolean edited;
    private PNGUICanvasClickHandler canvasClick;
    private JPanel jPanel1;
    private JPanel jPanel2;

    public Editor(JTextField helpBar, IPetriNet ipn, Project p, MainFrame mainFrame) {
        this.initComponents();
        this.edited = false;
        this.project = p;
        this.toolBar1 = new PNGUIToolBar(2, 5, 30, 150, false, this);
        this.toolBar1.setHelpBar(helpBar);
        this.jPanel1.add(this.toolBar1);
        this.petriNet = this.convert(ipn);
        this.isInSimulation = false;
        this.petriNet.getGrPetriNet().setBounds(2, 2, this.jPanel2.getWidth() - 4, this.jPanel2.getHeight() - 4);
        this.canvasClick = new PNGUICanvasClickHandler(this.toolBar1, this.petriNet);
        this.petriNet.getGrPetriNet().addMouseListener(this.canvasClick);
        this.scrollPane = new PScrollPane(this.petriNet.getGrPetriNet());
        this.jPanel2.add(this.scrollPane);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                Editor.this.scrollPane.setBounds(2, 2, Editor.this.jPanel2.getWidth() - 4, Editor.this.jPanel2.getHeight() - 4);
                Editor.this.petriNet.getGrPetriNet().setBounds(0, 0, Editor.this.scrollPane.getWidth(), Editor.this.scrollPane.getHeight());
            }
        });
        this.popupInfo = new JLabel("");
        this.petriNet.getGrPetriNet().add(this.popupInfo);
        this.mainFrame = mainFrame;
        this.petriNet.getGrPetriNet().setMainFrame(mainFrame);
    }

    public Editor(JTextField helpBar, String pnName, PNType type, Project p) {
        this.initComponents();
        this.edited = false;
        this.project = p;
        this.toolBar1 = new PNGUIToolBar(2, 5, 30, 150, false, this);
        this.toolBar1.setHelpBar(helpBar);
        this.jPanel1.add(this.toolBar1);
        switch (type) {
            case GPN: {
                this.petriNet = new pn.logic.PNLPetriNet("GPN");
                break;
            }
            case TB: {
                this.petriNet = new PNLPetriNet();
                break;
            }
            case EvPN: {
                this.petriNet = new pn.evpn.logic.PNLPetriNet();
                break;
            }
        }
        this.isInSimulation = false;
        this.petriNet.setName(pnName);
        this.petriNet.setId(pnName);
        this.petriNet.getGrPetriNet().setBounds(2, 2, this.jPanel2.getWidth() - 4, this.jPanel2.getHeight() - 4);
        this.canvasClick = new PNGUICanvasClickHandler(this.toolBar1, this.petriNet);
        this.petriNet.getGrPetriNet().addMouseListener(this.canvasClick);
        this.scrollPane = new PScrollPane(this.petriNet.getGrPetriNet());
        this.jPanel2.add(this.scrollPane);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                Editor.this.scrollPane.setBounds(2, 2, Editor.this.jPanel2.getWidth() - 4, Editor.this.jPanel2.getHeight() - 4);
                Editor.this.petriNet.getGrPetriNet().setBounds(0, 0, Editor.this.scrollPane.getWidth(), Editor.this.scrollPane.getHeight());
            }
        });
        this.popupInfo = new JLabel("");
        this.petriNet.getGrPetriNet().add(this.popupInfo);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 32, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 355, Short.MAX_VALUE));
        this.jPanel2.setBorder(BorderFactory.createEtchedBorder());
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 441, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 355, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
    }

    private pn.logic.PNLPetriNet convert(IPetriNet ipn) {
        String type = ipn.getType();
        pn.logic.PNLPetriNet pn = type.equals("GPN") ? new pn.logic.PNLPetriNet("GPN") : (type.equals("TB") ? new PNLPetriNet() : (type.equals("EvPN") ? new pn.evpn.logic.PNLPetriNet() : new pn.logic.PNLPetriNet("GPN")));
        if (ipn.getAdditionalData() instanceof Properties) {
            pn.setProperties((Properties)ipn.getAdditionalData());
        }
        pn.setName(ipn.getName());
        pn.setId(ipn.getId());
        int i = 0;
        while (i < ipn.getPlaces().size()) {
            PNLVertex p;
            if (type.equals("GPN")) {
                p = new PNLPlace((int)ipn.getPlaces().get(i).getX(), (int)ipn.getPlaces().get(i).getY(), ipn.getPlaces().get(i).getTokens());
            } else if (type.equals("TB")) {
                p = new pn.tb.logic.PNLPlace((int)ipn.getPlaces().get(i).getX(), (int)ipn.getPlaces().get(i).getY());
                if (ipn.getPlaces().get(i).getAdditionalData() instanceof Properties && ((Properties)ipn.getPlaces().get(i).getAdditionalData()).get("TB Tokens") != null && ((Properties)ipn.getPlaces().get(i).getAdditionalData()).get("TB Tokens") instanceof ArrayList) {
                    ArrayList a = (ArrayList)((Properties)ipn.getPlaces().get(i).getAdditionalData()).get("TB Tokens");
                    int j = 0;
                    while (j < a.size()) {
                        ((pn.tb.logic.PNLPlace)p).addToken((int)Math.round(((double[])a.get(j))[0]), (int)Math.round(((double[])a.get(j))[1]));
                        ++j;
                    }
                }
            } else if (type.equals("EvPN")) {
                p = new pn.evpn.logic.PNLPlace((int)ipn.getPlaces().get(i).getX(), (int)ipn.getPlaces().get(i).getY(), ipn.getPlaces().get(i).getTokens());
                ((pn.evpn.logic.PNLPlace)p).setType(0);
            } else {
                p = new PNLPlace((int)ipn.getPlaces().get(i).getX(), (int)ipn.getPlaces().get(i).getY(), ipn.getPlaces().get(i).getTokens());
            }
            p.setId(ipn.getPlaces().get(i).getId());
            p.setName(ipn.getPlaces().get(i).getName());
            try {
                p.setColor((Color)((Properties)ipn.getPlaces().get(i).getAdditionalData()).get("Color"));
            }
            catch (Exception a) {
                // empty catch block
            }
            p.getGrPlace().setNamePosition(ipn.getPlaces().get(i).getNameX(), ipn.getPlaces().get(i).getNameY());
            p.getGrPlace().addInputEventListener(new PlaceInputEventHandler(p.getGrVertex(), pn.getGrPetriNet()));
            p.getGrPlace().getBasicText().addInputEventListener(new PNBasicInputEventHandler(p.getGrPlace().getBasicText(), p.getGrPlace(), pn.getGrPetriNet()));
            p.getGrPlace().getAdvancedText().addInputEventListener(new PNBasicInputEventHandler(p.getGrPlace().getAdvancedText(), p.getGrPlace(), pn.getGrPetriNet()));
            pn.addVertex(p);
            ++i;
        }
        i = 0;
        while (i < ipn.getPlaces().size()) {
            if (pn.getVertex(i) instanceof pn.evpn.logic.PNLPlace && ipn.getPlaces().get(i).getType() != null) {
                if (ipn.getPlaces().get(i).getType().equals("pe")) {
                    ((pn.evpn.logic.PNLPlace)pn.getVertex(i)).setType(1);
                    ((pn.evpn.logic.PNLPlace)pn.getVertex(i)).setFunction(((Properties)ipn.getPlaces().get(i).getAdditionalData()).getProperty("EvPN Pe"), (pn.evpn.logic.PNLPetriNet)pn);
                }
                if (ipn.getPlaces().get(i).getType().equals("pf")) {
                    ((pn.evpn.logic.PNLPlace)pn.getVertex(i)).setType(2);
                    ((pn.evpn.logic.PNLPlace)pn.getVertex(i)).setFunction(((Properties)ipn.getPlaces().get(i).getAdditionalData()).getProperty("EvPN Pf"), (pn.evpn.logic.PNLPetriNet)pn);
                }
            }
            ++i;
        }
        i = 0;
        while (i < ipn.getTransitions().size()) {
            PNLVertex t;
            if (type.equals("GPN")) {
                t = new pn.logic.PNLTransition((int)ipn.getTransitions().get(i).getX(), (int)ipn.getTransitions().get(i).getY());
            } else if (type.equals("TB")) {
                t = new pn.tb.logic.PNLTransition((int)ipn.getTransitions().get(i).getX(), (int)ipn.getTransitions().get(i).getY());
                if (ipn.getTransitions().get(i).getAdditionalData() instanceof Properties && ((Properties)ipn.getTransitions().get(i).getAdditionalData()).get("TB Function") != null) {
                    ((pn.tb.logic.PNLTransition)t).setFunction((String)((Properties)ipn.getTransitions().get(i).getAdditionalData()).get("TB Function"), (PNLPetriNet)pn);
                }
            } else {
                t = type.equals("EvPN") ? new PNLTransition((int)ipn.getTransitions().get(i).getX(), (int)ipn.getTransitions().get(i).getY()) : new pn.logic.PNLTransition((int)ipn.getTransitions().get(i).getX(), (int)ipn.getTransitions().get(i).getY());
            }
            t.setId(ipn.getTransitions().get(i).getId());
            t.setName(ipn.getTransitions().get(i).getName());
            try {
                t.setColor((Color)((Properties)ipn.getTransitions().get(i).getAdditionalData()).get("Color"));
            }
            catch (Exception a) {
                // empty catch block
            }
            t.getGrTransition().setNamePosition(ipn.getTransitions().get(i).getNameX(), ipn.getTransitions().get(i).getNameY());
            t.getGrTransition().addInputEventListener(new TransitionInputEventHandler(t.getGrVertex(), pn.getGrPetriNet()));
            t.getGrTransition().getBasicText().addInputEventListener(new PNBasicInputEventHandler(t.getGrTransition().getBasicText(), t.getGrTransition(), pn.getGrPetriNet()));
            t.getGrTransition().getAdvancedText().addInputEventListener(new PNBasicInputEventHandler(t.getGrTransition().getAdvancedText(), t.getGrTransition(), pn.getGrPetriNet()));
            pn.addVertex(t);
            ++i;
        }
        i = 0;
        while (i < ipn.getArcs().size()) {
            pn.logic.PNLEdge e;
            if (type.equals("GPN")) {
                e = new pn.logic.PNLEdge(pn.getVertexById(ipn.getArcs().get(i).getStartingVertex().getId()), pn.getVertexById(ipn.getArcs().get(i).getEndingVertex().getId()), ipn.getArcs().get(i).getId(), ipn.getArcs().get(i).getCount());
            } else if (type.equals("TB")) {
                e = new PNLEdge(pn.getVertexById(ipn.getArcs().get(i).getStartingVertex().getId()), pn.getVertexById(ipn.getArcs().get(i).getEndingVertex().getId()), ipn.getArcs().get(i).getId(), ipn.getArcs().get(i).getCount());
            } else if (type.equals("EvPN")) {
                e = new pn.evpn.logic.PNLEdge(pn.getVertexById(ipn.getArcs().get(i).getStartingVertex().getId()), pn.getVertexById(ipn.getArcs().get(i).getEndingVertex().getId()), ipn.getArcs().get(i).getId(), ipn.getArcs().get(i).getCount());
                if (ipn.getArcs().get(i).getAdditionalData() instanceof Properties) {
                    if (((Properties)ipn.getArcs().get(i).getAdditionalData()).get("EvPN Function") != null) {
                        if (((Properties)ipn.getArcs().get(i).getAdditionalData()).get("EvPN Function") instanceof Integer) {
                            ((pn.evpn.logic.PNLEdge)e).setFunction("" + ((Properties)ipn.getArcs().get(i).getAdditionalData()).get("EvPN Function"), (pn.evpn.logic.PNLPetriNet)pn);
                            IPNLVertex v = pn.getVertexById("" + ((Properties)ipn.getArcs().get(i).getAdditionalData()).get("EvPN Function"));
                            if (v instanceof IPNLPlace) {
                                ((pn.evpn.logic.PNLEdge)e).setRelPlace((IPNLPlace)v);
                            }
                        } else {
                            IPNLVertex v = pn.getVertexById((String)((Properties)ipn.getArcs().get(i).getAdditionalData()).get("EvPN Function"));
                            if (v instanceof IPNLPlace) {
                                ((pn.evpn.logic.PNLEdge)e).setRelPlace((IPNLPlace)v);
                            }
                            ((pn.evpn.logic.PNLEdge)e).setFunction((String)((Properties)ipn.getArcs().get(i).getAdditionalData()).get("EvPN Function"), (pn.evpn.logic.PNLPetriNet)pn);
                        }
                    }
                    if (((Properties)ipn.getArcs().get(i).getAdditionalData()).get("EvPN d") != null) {
                        ((pn.evpn.logic.PNLEdge)e).setD((Boolean)((Properties)ipn.getArcs().get(i).getAdditionalData()).get("EvPN d"));
                    }
                    if (((Properties)ipn.getArcs().get(i).getAdditionalData()).get("EvPN w") != null) {
                        ((pn.evpn.logic.PNLEdge)e).setW((Integer)((Properties)ipn.getArcs().get(i).getAdditionalData()).get("EvPN w"));
                    }
                }
            } else {
                e = new pn.logic.PNLEdge(pn.getVertexById(ipn.getArcs().get(i).getStartingVertex().getId()), pn.getVertexById(ipn.getArcs().get(i).getEndingVertex().getId()), ipn.getArcs().get(i).getId(), ipn.getArcs().get(i).getCount());
            }
            e.setId(ipn.getArcs().get(i).getId());
            e.getGrEdge().setCountPosition((int)ipn.getArcs().get(i).getCountX(), (int)ipn.getArcs().get(i).getCountY());
            int j = 0;
            while (j < ipn.getArcs().get(i).getKnots().size()) {
                e.addKnot(new PNGUIKnot((int)ipn.getArcs().get(i).getKnots().get(j)[0], (int)ipn.getArcs().get(i).getKnots().get(j)[1], e));
                ++j;
            }
            e.getGrEdge().addInputEventListener(new EdgeInputEventHandler(e.getGrEdge(), pn.getGrPetriNet()));
            e.getGrEdge().getBasicText().addInputEventListener(new PNBasicInputEventHandler(e.getGrEdge().getBasicText(), e.getGrEdge(), pn.getGrPetriNet()));
            e.getGrEdge().getAdvancedText().addInputEventListener(new PNBasicInputEventHandler(e.getGrEdge().getAdvancedText(), e.getGrEdge(), pn.getGrPetriNet()));
            e.getGrEdge().setCountPosition((float)ipn.getArcs().get(i).getCountX(), (float)ipn.getArcs().get(i).getCountY());
            pn.addEdge(e);
            ++i;
        }
        return pn;
    }

    public void setEdited(boolean b) {
        this.edited = b;
    }

    public boolean isEdited() {
        return this.edited;
    }

    public PNGUIToolBar getToolBar() {
        return this.toolBar1;
    }

    public Project getProject() {
        return this.project;
    }

    public void setPetriNet(pn.logic.PNLPetriNet pn) {
        this.jPanel2.remove(this.scrollPane);
        this.petriNet = pn;
        this.petriNet.getGrPetriNet().addMouseListener(new PNGUICanvasClickHandler(this.toolBar1, this.petriNet));
        this.scrollPane = new PScrollPane(this.petriNet.getGrPetriNet());
        this.scrollPane.setBounds(2, 2, this.jPanel2.getWidth() - 4, this.jPanel2.getHeight() - 4);
        this.petriNet.getGrPetriNet().setBounds(0, 0, this.scrollPane.getWidth(), this.scrollPane.getHeight());
        this.petriNet.getGrPetriNet().setMainFrame(this.mainFrame);
        this.jPanel2.add(this.scrollPane);
        this.petriNet.refresh();
    }

    public void setPetriNet(IPetriNet pn) {
        this.jPanel2.remove(this.scrollPane);
        this.petriNet = this.convert(pn);
        this.petriNet.getGrPetriNet().addMouseListener(new PNGUICanvasClickHandler(this.toolBar1, this.petriNet));
        this.scrollPane = new PScrollPane(this.petriNet.getGrPetriNet());
        this.scrollPane.setBounds(2, 2, this.jPanel2.getWidth() - 4, this.jPanel2.getHeight() - 4);
        this.petriNet.getGrPetriNet().setBounds(0, 0, this.scrollPane.getWidth(), this.scrollPane.getHeight());
        this.petriNet.getGrPetriNet().setMainFrame(this.mainFrame);
        this.jPanel2.add(this.scrollPane);
        this.petriNet.refresh();
    }

    public void updateProject() {
        this.project.updatePetriNet(PetriNetConverter.convert(this.petriNet));
    }

    public void setLevel1Shown(boolean b) {
        this.petriNet.getGrPetriNet().setLevel1Shown(b);
    }

    public void setLevel2Shown(boolean b) {
        this.petriNet.getGrPetriNet().setLevel2Shown(b);
    }

    public void setToolbarEnabled(boolean b) {
        this.toolBar1.setEnabled(b);
    }

    public void startSimulation(Simulator sim) {
        this.petriNet.getGrPetriNet().startSimulation(sim);
    }

    public void stopSimulation() {
        this.petriNet.getGrPetriNet().stopSimulation();
    }

    public boolean isSimulating() {
        return this.petriNet.getGrPetriNet().isSimulating();
    }

    public PNGUICanvasClickHandler getPNGUICanvasClickHandler() {
        return this.canvasClick;
    }

    public void resetProperties(JTable table) {
        block3: {
            pn.logic.PNLEdge e;
            block2: {
                e = this.petriNet.getEdgeById((String)table.getValueAt(0, 1));
                IPNLVertex v = this.petriNet.getVertexById((String)table.getValueAt(0, 1));
                if (v == null) break block2;
                int i = 1;
                while (i < table.getModel().getRowCount()) {
                    table.setValueAt("" + v.getProperty((String)table.getValueAt(i, 0)), i, 1);
                    ++i;
                }
                break block3;
            }
            if (e == null) break block3;
            int i = 1;
            while (i < table.getModel().getRowCount()) {
                table.setValueAt("" + e.getProperty((String)table.getValueAt(i, 0)), i, 1);
                ++i;
            }
        }
    }

    public void setProperties(JTable table) {
        pn.logic.PNLEdge e = null;
        IPNLVertex v = null;
        int i = 0;
        while (i < table.getRowCount()) {
            if (((String)table.getValueAt(i, 0)).equals("Id")) {
                e = this.petriNet.getEdgeById((String)table.getValueAt(i, 1));
                v = this.petriNet.getVertexById((String)table.getValueAt(i, 1));
                break;
            }
            ++i;
        }
        if (v != null) {
            i = 0;
            while (i < table.getModel().getRowCount()) {
                try {
                    if (table.getValueAt(i, 0).equals("EvPN Pe") || table.getValueAt(i, 0).equals("EvPN Pf")) {
                        ((pn.evpn.logic.PNLPlace)v).setFunction((String)table.getValueAt(i, 1), (pn.evpn.logic.PNLPetriNet)this.petriNet);
                    } else {
                        v.setProperty((String)table.getValueAt(i, 0), table.getValueAt(i, 1));
                    }
                }
                catch (Exception exc) {
                    JOptionPane.showMessageDialog(this, "Property " + (String)table.getValueAt(i, 0) + " contains illegal characters!", "Error!", 0);
                    System.out.println("error onEditor.setProperties: " + exc.toString());
                }
                ++i;
            }
        } else if (e != null) {
            i = 0;
            while (i < table.getModel().getRowCount()) {
                try {
                    if (table.getValueAt(i, 0).equals("EvPN Function")) {
                        ((pn.evpn.logic.PNLEdge)e).setFunction((String)table.getValueAt(i, 1), (pn.evpn.logic.PNLPetriNet)this.petriNet);
                    } else {
                        e.setProperty((String)table.getValueAt(i, 0), table.getValueAt(i, 1));
                    }
                }
                catch (Exception exc) {
                    JOptionPane.showMessageDialog(this, "Property " + (String)table.getValueAt(i, 0) + " contains illegal characters!", "Error!", 0);
                    System.out.println("error onEditor.setProperties: " + exc.toString());
                }
                ++i;
            }
        }
        this.petriNet.refresh();
    }

    public pn.logic.PNLPetriNet getPetriNet() {
        return this.petriNet;
    }
}

