/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.event;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PDragSequenceEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolo.util.PNodeFilter;
import edu.umd.cs.piccolox.event.PNotificationCenter;
import edu.umd.cs.piccolox.handles.PBoundsHandle;
import java.awt.AWTException;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Robot;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PSelectionEventHandler
extends PDragSequenceEventHandler {
    public static final String SELECTION_CHANGED_NOTIFICATION = "SELECTION_CHANGED_NOTIFICATION";
    static final int DASH_WIDTH = 5;
    static final int NUM_STROKES = 10;
    private boolean startingDrag = false;
    private int minDragSize = 15;
    private int startedDragX = 0;
    private int startedDragY = 0;
    private HashMap selection = null;
    private List selectableParents = null;
    private PPath marquee = null;
    private PNode marqueeParent = null;
    private Point2D presspt = null;
    private Point2D canvasPressPt = null;
    private float strokeNum = 0.0f;
    private Stroke[] strokes = null;
    private HashMap allItems = null;
    private ArrayList unselectList = null;
    private HashMap marqueeMap = null;
    private PNode pressNode = null;
    private boolean deleteKeyActive = true;
    private Paint marqueePaint;
    private float marqueePaintTransparency = 1.0f;

    public PSelectionEventHandler(PNode marqueeParent, PNode selectableParent) {
        this.marqueeParent = marqueeParent;
        this.selectableParents = new ArrayList();
        this.selectableParents.add(selectableParent);
        this.init();
    }

    public PSelectionEventHandler(PNode marqueeParent, List selectableParents) {
        this.marqueeParent = marqueeParent;
        this.selectableParents = selectableParents;
        this.init();
    }

    protected void init() {
        float[] dash = new float[]{5.0f, 5.0f};
        this.strokes = new Stroke[10];
        int i = 0;
        while (i < 10) {
            this.strokes[i] = new BasicStroke(1.0f, 0, 0, 1.0f, dash, i);
            ++i;
        }
        this.selection = new HashMap();
        this.allItems = new HashMap();
        this.unselectList = new ArrayList();
        this.marqueeMap = new HashMap();
    }

    public void select(Collection items) {
        boolean changes = false;
        for (PNode node : items) {
            changes |= this.internalSelect(node);
        }
        if (changes) {
            this.postSelectionChanged();
        }
    }

    public void select(Map items) {
        this.select(items.keySet());
    }

    private boolean internalSelect(PNode node) {
        if (this.isSelected(node)) {
            return false;
        }
        this.selection.put(node, Boolean.TRUE);
        this.decorateSelectedNode(node);
        return true;
    }

    private void postSelectionChanged() {
        PNotificationCenter.defaultCenter().postNotification(SELECTION_CHANGED_NOTIFICATION, this);
    }

    public void select(PNode node) {
        if (this.internalSelect(node)) {
            this.postSelectionChanged();
        }
    }

    public void decorateSelectedNode(PNode node) {
        PBoundsHandle.addBoundsHandlesTo(node);
    }

    public void unselect(Collection items) {
        boolean changes = false;
        for (PNode node : items) {
            changes |= this.internalUnselect(node);
        }
        if (changes) {
            this.postSelectionChanged();
        }
    }

    private boolean internalUnselect(PNode node) {
        if (!this.isSelected(node)) {
            return false;
        }
        this.undecorateSelectedNode(node);
        this.selection.remove(node);
        return true;
    }

    public void unselect(PNode node) {
        if (this.internalUnselect(node)) {
            this.postSelectionChanged();
        }
    }

    public void undecorateSelectedNode(PNode node) {
        PBoundsHandle.removeBoundsHandlesFrom(node);
    }

    public void unselectAll() {
        ArrayList sel = new ArrayList(this.selection.keySet());
        this.unselect(sel);
    }

    public boolean isSelected(PNode node) {
        return node != null && this.selection.containsKey(node);
    }

    public Collection getSelection() {
        ArrayList sel = new ArrayList(this.selection.keySet());
        return sel;
    }

    public Collection getSelectionReference() {
        return Collections.unmodifiableCollection(this.selection.keySet());
    }

    protected boolean isSelectable(PNode node) {
        boolean selectable = false;
        block0: for (PNode parent : this.selectableParents) {
            if (parent.getChildrenReference().contains(node)) {
                selectable = true;
                break;
            }
            if (!(parent instanceof PCamera)) continue;
            int i = 0;
            while (i < ((PCamera)parent).getLayerCount()) {
                PLayer layer = ((PCamera)parent).getLayer(i);
                if (layer.getChildrenReference().contains(node)) {
                    selectable = true;
                    continue block0;
                }
                ++i;
            }
        }
        return selectable;
    }

    public void addSelectableParent(PNode node) {
        this.selectableParents.add(node);
    }

    public void removeSelectableParent(PNode node) {
        this.selectableParents.remove(node);
    }

    public void setSelectableParent(PNode node) {
        this.selectableParents.clear();
        this.selectableParents.add(node);
    }

    public void setSelectableParents(Collection c) {
        this.selectableParents.clear();
        this.selectableParents.addAll(c);
    }

    public Collection getSelectableParents() {
        return new ArrayList(this.selectableParents);
    }

    @Override
    protected void startDrag(PInputEvent e) {
        this.startedDragX = (int)e.getPosition().getX();
        this.startedDragY = (int)e.getPosition().getY();
        this.startingDrag = false;
        super.startDrag(e);
        this.initializeSelection(e);
        if (this.isMarqueeSelection(e)) {
            this.initializeMarquee(e);
            if (!this.isOptionSelection(e)) {
                this.startMarqueeSelection(e);
            } else {
                this.startOptionMarqueeSelection(e);
            }
        } else if (!this.isOptionSelection(e)) {
            this.startStandardSelection(e);
        } else {
            this.startStandardOptionSelection(e);
        }
    }

    @Override
    protected void drag(PInputEvent e) {
        int dragX = (int)e.getPosition().getX();
        int dragY = (int)e.getPosition().getY();
        this.startingDrag = true;
        if (Math.abs(dragX - this.startedDragX) < this.minDragSize && Math.abs(dragY - this.startedDragY) < this.minDragSize) {
            return;
        }
        this.startingDrag = false;
        super.drag(e);
        if (this.isMarqueeSelection(e)) {
            this.updateMarquee(e);
            if (!this.isOptionSelection(e)) {
                this.computeMarqueeSelection(e);
            } else {
                this.computeOptionMarqueeSelection(e);
            }
        } else {
            this.dragStandardSelection(e);
        }
    }

    @Override
    protected void endDrag(PInputEvent e) {
        super.endDrag(e);
        if (this.isMarqueeSelection(e)) {
            this.endMarqueeSelection(e);
        } else {
            this.endStandardSelection(e);
        }
        if (this.startingDrag) {
            e.setHandled(true);
            try {
                Robot robot = new Robot();
                robot.mousePress(16);
                robot.mouseRelease(16);
            }
            catch (AWTException aWTException) {
                // empty catch block
            }
        }
    }

    public boolean isOptionSelection(PInputEvent pie) {
        return pie.isShiftDown();
    }

    protected boolean isMarqueeSelection(PInputEvent pie) {
        return this.pressNode == null;
    }

    protected void initializeSelection(PInputEvent pie) {
        this.canvasPressPt = pie.getCanvasPosition();
        this.presspt = pie.getPosition();
        this.pressNode = pie.getPath().getPickedNode();
        if (this.pressNode instanceof PCamera) {
            this.pressNode = null;
        }
    }

    protected void initializeMarquee(PInputEvent e) {
        this.marquee = PPath.createRectangle((float)this.presspt.getX(), (float)this.presspt.getY(), 0.0f, 0.0f);
        this.marquee.setPaint(this.marqueePaint);
        this.marquee.setTransparency(this.marqueePaintTransparency);
        this.marquee.setStrokePaint(Color.black);
        this.marquee.setStroke(this.strokes[0]);
        this.marqueeParent.addChild(this.marquee);
        this.marqueeMap.clear();
    }

    protected void startOptionMarqueeSelection(PInputEvent e) {
    }

    protected void startMarqueeSelection(PInputEvent e) {
        this.unselectAll();
    }

    protected void startStandardSelection(PInputEvent pie) {
        if (!this.isSelected(this.pressNode)) {
            this.unselectAll();
            if (this.isSelectable(this.pressNode)) {
                this.select(this.pressNode);
            }
        }
    }

    protected void startStandardOptionSelection(PInputEvent pie) {
        if (this.isSelectable(this.pressNode)) {
            if (this.isSelected(this.pressNode)) {
                this.unselect(this.pressNode);
            } else {
                this.select(this.pressNode);
            }
        }
    }

    protected void updateMarquee(PInputEvent pie) {
        PBounds b = new PBounds();
        if (this.marqueeParent instanceof PCamera) {
            b.add(this.canvasPressPt);
            b.add(pie.getCanvasPosition());
        } else {
            b.add(this.presspt);
            b.add(pie.getPosition());
        }
        this.marquee.setPathToRectangle((float)b.x, (float)b.y, (float)b.width, (float)b.height);
        b.reset();
        b.add(this.presspt);
        b.add(pie.getPosition());
        this.allItems.clear();
        PNodeFilter filter = this.createNodeFilter(b);
        for (PNode parent : this.selectableParents) {
            Collection items;
            if (parent instanceof PCamera) {
                items = new ArrayList();
                int i = 0;
                while (i < ((PCamera)parent).getLayerCount()) {
                    ((PCamera)parent).getLayer(i).getAllNodes(filter, items);
                    ++i;
                }
            } else {
                items = parent.getAllNodes(filter, null);
            }
            Iterator itemsIt = items.iterator();
            while (itemsIt.hasNext()) {
                this.allItems.put(itemsIt.next(), Boolean.TRUE);
            }
        }
    }

    protected void computeMarqueeSelection(PInputEvent pie) {
        this.unselectList.clear();
        for (PNode node : this.selection.keySet()) {
            if (this.allItems.containsKey(node)) continue;
            this.unselectList.add(node);
        }
        this.unselect(this.unselectList);
        for (PNode node : this.allItems.keySet()) {
            if (!this.selection.containsKey(node) && !this.marqueeMap.containsKey(node) && this.isSelectable(node)) {
                this.marqueeMap.put(node, Boolean.TRUE);
                continue;
            }
            if (this.isSelectable(node)) continue;
            this.allItems.remove(node);
        }
        this.select(this.allItems);
    }

    protected void computeOptionMarqueeSelection(PInputEvent pie) {
        this.unselectList.clear();
        for (PNode node : this.selection.keySet()) {
            if (this.allItems.containsKey(node) || !this.marqueeMap.containsKey(node)) continue;
            this.marqueeMap.remove(node);
            this.unselectList.add(node);
        }
        this.unselect(this.unselectList);
        for (PNode node : this.allItems.keySet()) {
            if (!this.selection.containsKey(node) && !this.marqueeMap.containsKey(node) && this.isSelectable(node)) {
                this.marqueeMap.put(node, Boolean.TRUE);
                continue;
            }
            if (this.isSelectable(node)) continue;
            this.allItems.remove(node);
        }
        this.select(this.allItems);
    }

    protected PNodeFilter createNodeFilter(PBounds bounds) {
        return new BoundsFilter(bounds);
    }

    protected PBounds getMarqueeBounds() {
        if (this.marquee != null) {
            return this.marquee.getBounds();
        }
        return new PBounds();
    }

    protected void dragStandardSelection(PInputEvent e) {
        PDimension d = e.getCanvasDelta();
        e.getTopCamera().localToView(d);
        PDimension gDist = new PDimension();
        for (PNode node : this.selection.keySet()) {
            gDist.setSize(d);
            node.getParent().globalToLocal(d);
            node.offset(d.getWidth(), d.getHeight());
        }
    }

    protected void endMarqueeSelection(PInputEvent e) {
        this.marquee.removeFromParent();
        this.marquee = null;
    }

    protected void endStandardSelection(PInputEvent e) {
        this.pressNode = null;
    }

    @Override
    protected void dragActivityStep(PInputEvent aEvent) {
        if (this.marquee != null) {
            float origStrokeNum = this.strokeNum;
            this.strokeNum = (this.strokeNum + 0.5f) % 10.0f;
            if ((int)this.strokeNum != (int)origStrokeNum) {
                this.marquee.setStroke(this.strokes[(int)this.strokeNum]);
            }
        }
    }

    @Override
    public void keyPressed(PInputEvent e) {
        switch (e.getKeyCode()) {
            case 127: {
                if (!this.deleteKeyActive) break;
                for (PNode node : this.selection.keySet()) {
                    node.removeFromParent();
                }
                this.selection.clear();
            }
        }
    }

    public boolean getSupportDeleteKey() {
        return this.deleteKeyActive;
    }

    public boolean isDeleteKeyActive() {
        return this.deleteKeyActive;
    }

    public void setDeleteKeyActive(boolean deleteKeyActive) {
        this.deleteKeyActive = deleteKeyActive;
    }

    public Paint getMarqueePaint() {
        return this.marqueePaint;
    }

    public void setMarqueePaint(Paint paint) {
        this.marqueePaint = paint;
    }

    public float getMarqueePaintTransparency() {
        return this.marqueePaintTransparency;
    }

    public void setMarqueePaintTransparency(float marqueePaintTransparency) {
        this.marqueePaintTransparency = marqueePaintTransparency;
    }

    public boolean getstartingDrag() {
        return this.startingDrag;
    }

    protected class BoundsFilter
    implements PNodeFilter {
        PBounds localBounds = new PBounds();
        PBounds bounds;

        protected BoundsFilter(PBounds bounds) {
            this.bounds = bounds;
        }

        @Override
        public boolean accept(PNode node) {
            boolean isMarquee;
            this.localBounds.setRect(this.bounds);
            node.globalToLocal(this.localBounds);
            boolean boundsIntersects = node.intersects2(this.localBounds);
            boolean bl = isMarquee = node == PSelectionEventHandler.this.marquee;
            return node.getPickable() && boundsIntersects && !isMarquee && !PSelectionEventHandler.this.selectableParents.contains(node) && !this.isCameraLayer(node);
        }

        @Override
        public boolean acceptChildrenOf(PNode node) {
            return PSelectionEventHandler.this.selectableParents.contains(node) || this.isCameraLayer(node);
        }

        public boolean isCameraLayer(PNode node) {
            if (node instanceof PLayer) {
                for (PNode parent : PSelectionEventHandler.this.selectableParents) {
                    if (!(parent instanceof PCamera) || ((PCamera)parent).indexOfLayer((PLayer)node) == -1) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

