/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.event;

import edu.umd.cs.piccolox.event.PNotification;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class PNotificationCenter {
    public static final Object NULL_MARKER = new Object();
    protected static PNotificationCenter DEFAULT_CENTER;
    protected HashMap listenersMap = new HashMap();
    protected ReferenceQueue keyQueue = new ReferenceQueue();

    public static PNotificationCenter defaultCenter() {
        if (DEFAULT_CENTER == null) {
            DEFAULT_CENTER = new PNotificationCenter();
        }
        return DEFAULT_CENTER;
    }

    private PNotificationCenter() {
    }

    public void addListener(Object listener, String callbackMethodName, String notificationName, Object object) {
        this.processKeyQueue();
        Object name = notificationName;
        Method method = null;
        try {
            method = listener.getClass().getMethod(callbackMethodName, PNotification.class);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return;
        }
        if (name == null) {
            name = NULL_MARKER;
        }
        if (object == null) {
            object = NULL_MARKER;
        }
        CompoundKey key = new CompoundKey(name, object);
        CompoundValue value = new CompoundValue(listener, method);
        ArrayList<CompoundValue> list = (ArrayList<CompoundValue>)this.listenersMap.get(key);
        if (list == null) {
            list = new ArrayList<CompoundValue>();
            this.listenersMap.put(new CompoundKey(name, object, this.keyQueue), list);
        }
        if (!list.contains(value)) {
            list.add(value);
        }
    }

    public void removeListener(Object listener) {
        this.processKeyQueue();
        Iterator i = new LinkedList(this.listenersMap.keySet()).iterator();
        while (i.hasNext()) {
            this.removeListener(listener, i.next());
        }
    }

    public void removeListener(Object listener, String notificationName, Object object) {
        this.processKeyQueue();
        List keys = this.matchingKeys(notificationName, object);
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            this.removeListener(listener, it.next());
        }
    }

    public void postNotification(String notificationName, Object object) {
        this.postNotification(notificationName, object, null);
    }

    public void postNotification(String notificationName, Object object, Map userInfo) {
        this.postNotification(new PNotification(notificationName, object, userInfo));
    }

    public void postNotification(PNotification aNotification) {
        CompoundKey key;
        List listenersList;
        LinkedList mergedListeners = new LinkedList();
        String name = aNotification.getName();
        Object object = aNotification.getObject();
        if (name != null) {
            if (object != null) {
                listenersList = (List)this.listenersMap.get(new CompoundKey(name, object));
                if (listenersList != null) {
                    mergedListeners.addAll(listenersList);
                }
                if ((listenersList = (List)this.listenersMap.get(new CompoundKey(name, NULL_MARKER))) != null) {
                    mergedListeners.addAll(listenersList);
                }
                if ((listenersList = (List)this.listenersMap.get(new CompoundKey(NULL_MARKER, object))) != null) {
                    mergedListeners.addAll(listenersList);
                }
            } else {
                listenersList = (List)this.listenersMap.get(new CompoundKey(name, NULL_MARKER));
                if (listenersList != null) {
                    mergedListeners.addAll(listenersList);
                }
            }
        } else if (object != null && (listenersList = (List)this.listenersMap.get(new CompoundKey(NULL_MARKER, object))) != null) {
            mergedListeners.addAll(listenersList);
        }
        if ((listenersList = (List)this.listenersMap.get(key = new CompoundKey(NULL_MARKER, NULL_MARKER))) != null) {
            mergedListeners.addAll(listenersList);
        }
        Iterator it = mergedListeners.iterator();
        while (it.hasNext()) {
            CompoundValue value = (CompoundValue)it.next();
            if (value.get() == null) {
                it.remove();
                continue;
            }
            try {
                value.getMethod().invoke(value.get(), aNotification);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    protected List matchingKeys(String name, Object object) {
        LinkedList<CompoundKey> result = new LinkedList<CompoundKey>();
        for (CompoundKey key : this.listenersMap.keySet()) {
            if (name != null && name != key.name() || object != null && object != key.get()) continue;
            result.add(key);
        }
        return result;
    }

    protected void removeListener(Object listener, Object key) {
        if (listener == null) {
            this.listenersMap.remove(key);
            return;
        }
        List list = (List)this.listenersMap.get(key);
        if (list == null) {
            return;
        }
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Object observer = ((CompoundValue)it.next()).get();
            if (observer != null && listener != observer) continue;
            it.remove();
        }
        if (list.size() == 0) {
            this.listenersMap.remove(key);
        }
    }

    protected void processKeyQueue() {
        CompoundKey key;
        while ((key = (CompoundKey)this.keyQueue.poll()) != null) {
            this.listenersMap.remove(key);
        }
    }

    protected static class CompoundKey
    extends WeakReference {
        private Object name;
        private int hashCode;

        public CompoundKey(Object aName, Object anObject) {
            super(anObject);
            this.name = aName;
            this.hashCode = aName.hashCode() + anObject.hashCode();
        }

        public CompoundKey(Object aName, Object anObject, ReferenceQueue aQueue) {
            super(anObject, aQueue);
            this.name = aName;
            this.hashCode = aName.hashCode() + anObject.hashCode();
        }

        public Object name() {
            return this.name;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object anObject) {
            Object object;
            if (this == anObject) {
                return true;
            }
            CompoundKey key = (CompoundKey)anObject;
            return (this.name == key.name || this.name != null && this.name.equals(key.name)) && (object = this.get()) != null && object == key.get();
        }

        public String toString() {
            return "[CompoundKey:" + this.name() + ":" + this.get() + "]";
        }
    }

    protected static class CompoundValue
    extends WeakReference {
        protected int hashCode;
        protected Method method;

        public CompoundValue(Object object, Method method) {
            super(object);
            this.hashCode = object.hashCode();
            this.method = method;
        }

        public Method getMethod() {
            return this.method;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            Object o;
            if (this == object) {
                return true;
            }
            CompoundValue value = (CompoundValue)object;
            return (this.method == value.method || this.method != null && this.method.equals(value.method)) && (o = this.get()) != null && o == value.get();
        }

        public String toString() {
            return "[CompoundValue:" + this.get() + ":" + this.getMethod().getName() + "]";
        }
    }
}

